/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.types;

import java.nio.charset.Charset;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.types.Declaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition2;

public class DynamicLengthStringDeclaration
extends Declaration {
    private final Charset fEncoding;
    private final @NonNull String fLengthName;

    public DynamicLengthStringDeclaration(@NonNull String lengthName, Charset encoding) {
        this.fLengthName = lengthName;
        this.fEncoding = encoding;
    }

    public Charset getEncoding() {
        return this.fEncoding;
    }

    public @NonNull String getLengthName() {
        return this.fLengthName;
    }

    @Override
    public StringDefinition2 createDefinition(@Nullable IDefinitionScope definitionScope, String fieldName, BitBuffer input) throws CTFException {
        IDefinition lenDef = null;
        if (definitionScope != null) {
            lenDef = definitionScope.lookupDefinition(this.fLengthName);
        }
        if (lenDef == null) {
            throw new CTFException("Length field not found: " + this.fLengthName);
        }
        if (!(lenDef instanceof IntegerDefinition)) {
            throw new CTFException("Length field must be an integer");
        }
        long rawLength = ((IntegerDefinition)lenDef).getValue();
        if (rawLength < 0L) {
            throw new CTFException("Cannot have a length < 0, declared = " + rawLength);
        }
        if ((double)rawLength > 1000000.0) {
            throw new CTFException("Cannot have a length > 1000000, declared = " + rawLength);
        }
        this.alignRead(input);
        int length = (int)rawLength;
        byte[] bytes = new byte[length];
        if (input.getByteBuffer().remaining() < length) {
            throw new CTFException("Insufficient space in buffer, requested: " + length + " remaining: " + input.getByteBuffer().remaining());
        }
        int i = 0;
        while (i < length) {
            bytes[i] = (byte)input.get(8, false);
            ++i;
        }
        String value = new String(bytes, this.fEncoding);
        int nullIndex = value.indexOf(0);
        if (nullIndex >= 0) {
            value = value.substring(0, nullIndex);
        }
        return new StringDefinition2(this, definitionScope, fieldName, value);
    }

    @Override
    public long getAlignment() {
        return 8L;
    }

    @Override
    public int getMaximumSize() {
        return Integer.MAX_VALUE;
    }

    public String toString() {
        return "dynamic_string[" + this.fLengthName + "]<" + this.fEncoding.name() + ">";
    }

    @Override
    public boolean isBinaryEquivalent(IDeclaration other) {
        return false;
    }
}

