/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.core.ast.IExplicitConstructorCall;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class ExplicitConstructorCall
extends Statement
implements InvocationSite,
IExplicitConstructorCall {
    public Expression[] arguments;
    public Expression qualification;
    public MethodBinding binding;
    protected MethodBinding codegenBinding;
    public int accessMode;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;
    public static final int ImplicitSuper = 1;
    public static final int This = 3;
    public VariableBinding[][] implicitArguments;
    public int typeArgumentsSourceStart;

    public ExplicitConstructorCall(int accessMode) {
        this.accessMode = accessMode;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        try {
            ((MethodScope)currentScope).isConstructorCall = true;
            if (this.qualification != null) {
                flowInfo = this.qualification.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            }
            if (this.arguments != null) {
                int i = 0;
                int max = this.arguments.length;
                while (i < max) {
                    flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
                    ++i;
                }
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
            FlowInfo flowInfo2 = flowInfo;
            return flowInfo2;
        }
        finally {
            ((MethodScope)currentScope).isConstructorCall = false;
        }
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isImplicitSuper() {
        return this.accessMode == 1;
    }

    @Override
    public boolean isSuperAccess() {
        return this.accessMode != 3;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding superTypeErasure = this.binding.declaringClass;
        if ((flowInfo.tagBits & 1) == 0 && superTypeErasure.isNestedType() && currentScope.enclosingSourceType().isLocalType() && superTypeErasure.isLocalType()) {
            ((LocalTypeBinding)superTypeErasure).addInnerEmulationDependent(currentScope, this.qualification != null);
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.codegenBinding = this.binding.original();
            if (this.binding.isPrivate() && this.accessMode != 3) {
                ReferenceBinding declaringClass = this.codegenBinding.declaringClass;
                if ((declaringClass.tagBits & 0x10L) != 0L && currentScope.compilerOptions().complianceLevel >= 0x300000L) {
                    this.codegenBinding.tagBits |= 0x400L;
                }
            }
        }
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        ExplicitConstructorCall.printIndent(indent, output);
        if (this.qualification != null) {
            this.qualification.printExpression(0, output).append('.');
        }
        if (this.typeArguments != null) {
            output.append('<');
            int max = this.typeArguments.length - 1;
            int j = 0;
            while (j < max) {
                this.typeArguments[j].print(0, output);
                output.append(", ");
                ++j;
            }
            this.typeArguments[max].print(0, output);
            output.append('>');
        }
        if (this.accessMode == 3) {
            output.append("this(");
        } else {
            output.append("super(");
        }
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.arguments[i].printExpression(0, output);
                ++i;
            }
        }
        return output.append(");");
    }

    @Override
    public void resolve(BlockScope scope) {
        MethodScope methodScope = scope.methodScope();
        try {
            AbstractMethodDeclaration methodDeclaration = methodScope.referenceMethod();
            if (methodDeclaration == null || !methodDeclaration.isConstructor() || ((ConstructorDeclaration)methodDeclaration).constructorCall != this) {
                int max;
                int i;
                if (this.qualification != null) {
                    this.qualification.resolveType(scope);
                }
                if (this.typeArguments != null) {
                    i = 0;
                    max = this.typeArguments.length;
                    while (i < max) {
                        this.typeArguments[i].resolveType(scope, true);
                        ++i;
                    }
                }
                if (this.arguments != null) {
                    i = 0;
                    max = this.arguments.length;
                    while (i < max) {
                        this.arguments[i].resolveType(scope);
                        ++i;
                    }
                }
                return;
            }
            methodScope.isConstructorCall = true;
            ReferenceBinding receiverType = scope.enclosingReceiverType();
            if (this.accessMode != 3) {
                receiverType = receiverType.getSuperBinding();
            }
            if (receiverType == null) {
                return;
            }
            if (this.qualification != null) {
                ReferenceBinding enclosingType = receiverType.enclosingType();
                if (enclosingType == null) {
                    this.bits |= 0x2000;
                } else {
                    this.qualification.resolveTypeExpecting(scope, enclosingType);
                }
            }
            if (this.typeArguments != null) {
                int length = this.typeArguments.length;
                boolean argHasError = false;
                this.genericTypeArguments = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    TypeReference typeReference = this.typeArguments[i];
                    this.genericTypeArguments[i] = typeReference.resolveType(scope, true);
                    if (this.genericTypeArguments[i] == null) {
                        argHasError = true;
                    }
                    ++i;
                }
                if (argHasError) {
                    return;
                }
            }
            TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
            boolean argsContainCast = false;
            if (this.arguments != null) {
                boolean argHasError = false;
                int length = this.arguments.length;
                argumentTypes = new TypeBinding[length];
                int i = 0;
                while (i < length) {
                    Expression argument = this.arguments[i];
                    argumentTypes[i] = argument.resolveType(scope);
                    if (argumentTypes[i] == null) {
                        argHasError = true;
                    }
                    ++i;
                }
                if (argHasError) {
                    MethodBinding closestMatch;
                    TypeBinding[] pseudoArgs = new TypeBinding[length];
                    int i2 = length;
                    while (--i2 >= 0) {
                        TypeBinding typeBinding = pseudoArgs[i2] = argumentTypes[i2] == null ? TypeBinding.NULL : argumentTypes[i2];
                    }
                    this.binding = scope.findMethod(receiverType, TypeConstants.INIT, pseudoArgs, this);
                    if (this.binding != null && !this.binding.isValidBinding() && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                        this.binding = closestMatch;
                        MethodBinding closestMatchOriginal = closestMatch.original();
                        if ((closestMatchOriginal.isPrivate() || closestMatchOriginal.declaringClass.isLocalType()) && !scope.isDefinedInMethod(closestMatchOriginal)) {
                            closestMatchOriginal.modifiers |= 0x8000000;
                        }
                    }
                    return;
                }
            }
            if ((this.binding = scope.getConstructor(receiverType, argumentTypes, this)).isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, scope, this.accessMode != 1)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
                ExplicitConstructorCall.checkInvocationArguments(scope, null, receiverType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
                if (this.binding.isPrivate() || receiverType.isLocalType()) {
                    this.binding.original().modifiers |= 0x8000000;
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = receiverType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
            }
        }
        finally {
            methodScope.isConstructorCall = false;
        }
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int depth) {
    }

    @Override
    public void setFieldIndex(int depth) {
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i;
            if (this.qualification != null) {
                this.qualification.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.arguments != null) {
                i = 0;
                int argumentLength = this.arguments.length;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 32;
    }
}

