/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.details;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.IDetailPane;
import org.eclipse.debug.ui.IDetailPaneFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.Messages;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.details.FunctionBreakpointDetailPane;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.details.LineBreakpointDetailPane;
import org.eclipse.wst.jsdt.debug.internal.ui.breakpoints.details.StandardBreakpointDetailPane;

public class BreakpointDetailPaneFactory
implements IDetailPaneFactory {
    private Map fNameMap;

    public Set getDetailPaneTypes(IStructuredSelection selection) {
        HashSet<String> set = new HashSet<String>();
        if (selection.size() == 1) {
            IBreakpoint b = (IBreakpoint)selection.getFirstElement();
            try {
                String type = b.getMarker().getType();
                if ("org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker".equals(type)) {
                    set.add("org.eclipse.wst.jsdt.debug.ui.line_breakpoint_detail_pane");
                } else if ("org.eclipse.wst.jsdt.debug.core.function.breakpoint.marker".equals(type)) {
                    set.add("org.eclipse.wst.jsdt.debug.ui.function_breakpoint_detail_pane");
                } else {
                    set.add("org.eclipse.wst.jsdt.debug.ui.standard_detail_pane");
                }
            }
            catch (CoreException coreException) {}
        }
        return set;
    }

    public String getDefaultDetailPane(IStructuredSelection selection) {
        if (selection.size() == 1) {
            String type;
            block5: {
                IBreakpoint b = (IBreakpoint)selection.getFirstElement();
                try {
                    type = b.getMarker().getType();
                    if (!"org.eclipse.wst.jsdt.debug.core.line.breakpoint.marker".equals(type)) break block5;
                    return "org.eclipse.wst.jsdt.debug.ui.line_breakpoint_detail_pane";
                }
                catch (CoreException coreException) {}
            }
            if ("org.eclipse.wst.jsdt.debug.core.function.breakpoint.marker".equals(type)) {
                return "org.eclipse.wst.jsdt.debug.ui.function_breakpoint_detail_pane";
            }
            return "org.eclipse.wst.jsdt.debug.ui.standard_detail_pane";
        }
        return null;
    }

    public IDetailPane createDetailPane(String paneID) {
        if ("org.eclipse.wst.jsdt.debug.ui.line_breakpoint_detail_pane".equals(paneID)) {
            return new LineBreakpointDetailPane();
        }
        if ("org.eclipse.wst.jsdt.debug.ui.standard_detail_pane".equals(paneID)) {
            return new StandardBreakpointDetailPane();
        }
        if ("org.eclipse.wst.jsdt.debug.ui.function_breakpoint_detail_pane".equals(paneID)) {
            return new FunctionBreakpointDetailPane();
        }
        return null;
    }

    public String getDetailPaneName(String paneID) {
        return (String)this.getNameMap().get(paneID);
    }

    public String getDetailPaneDescription(String paneID) {
        return (String)this.getNameMap().get(paneID);
    }

    private Map getNameMap() {
        if (this.fNameMap == null) {
            this.fNameMap = new HashMap();
            this.fNameMap.put("org.eclipse.wst.jsdt.debug.ui.line_breakpoint_detail_pane", Messages.line_breakpoint_settings);
            this.fNameMap.put("org.eclipse.wst.jsdt.debug.ui.function_breakpoint_detail_pane", Messages.function_breakpoint_settings);
            this.fNameMap.put("org.eclipse.wst.jsdt.debug.ui.standard_detail_pane", Messages.breakpoint_settings);
        }
        return this.fNameMap;
    }
}

