/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model;

import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderCapabilities;

public class DataProviderCapabilities
implements IDataProviderCapabilities {
    public static final IDataProviderCapabilities NULL_INSTANCE = new Builder().build();
    private final boolean canCreate;
    private final boolean canDelete;

    public DataProviderCapabilities(Builder builder) {
        this.canCreate = builder.canCreate;
        this.canDelete = builder.canDelete;
    }

    @Override
    public boolean canCreate() {
        return this.canCreate;
    }

    @Override
    public boolean canDelete() {
        return this.canDelete;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "canCreate=" + this.canCreate() + ", canDelete=" + this.canDelete() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.canCreate, this.canDelete);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataProviderCapabilities)) {
            return false;
        }
        DataProviderCapabilities other = (DataProviderCapabilities)obj;
        return this.canCreate == other.canCreate && this.canDelete == other.canDelete;
    }

    public static class Builder {
        private boolean canCreate = false;
        private boolean canDelete = false;

        public Builder setCanCreate(boolean canCreate) {
            this.canCreate = canCreate;
            return this;
        }

        public Builder setCanDelete(boolean canDelete) {
            this.canDelete = canDelete;
            return this;
        }

        public IDataProviderCapabilities build() {
            return new DataProviderCapabilities(this);
        }
    }
}

