/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.perf.profiling.core.symbol;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.perf.profiling.core.Activator;
import org.eclipse.tracecompass.incubator.internal.perf.profiling.core.symbol.PerfMmapAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.perf.profiling.core.symbol.TmfLibrarySymbol;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.symbols.IMappingFile;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class PerfMmapSymbolProvider
implements ISymbolProvider {
    private final PerfMmapAnalysisModule fMmapModule;
    private final ITmfTrace fTrace;
    private final Map<String, IMappingFile> fSymbolMapping = new HashMap<String, IMappingFile>();

    public PerfMmapSymbolProvider(ITmfTrace trace, PerfMmapAnalysisModule module) {
        this.fTrace = trace;
        this.fMmapModule = module;
        module.schedule();
    }

    public void loadConfiguration(@Nullable IProgressMonitor monitor) {
    }

    public @Nullable TmfResolvedSymbol getSymbol(int pid, long timestamp, long address) {
        Map.Entry lastEntry;
        block6: {
            PerfMmapAnalysisModule mmapModule = this.fMmapModule;
            ITmfStateSystem stateSystem = mmapModule.getStateSystem();
            if (stateSystem == null) {
                return null;
            }
            int pidQuark = stateSystem.optQuarkAbsolute(new String[]{String.valueOf(pid)});
            if (pidQuark == -2) {
                return null;
            }
            List baddrQuarks = stateSystem.getSubAttributes(pidQuark, false);
            baddrQuarks = baddrQuarks.stream().filter(quark -> {
                String baddrStr = stateSystem.getAttributeName(quark.intValue());
                long baddr = Long.parseLong(baddrStr);
                return baddr <= address;
            }).collect(Collectors.toList());
            Iterable intervals = stateSystem.query2D(baddrQuarks, Collections.singleton(timestamp));
            TreeMap<Long, ITmfStateInterval> map = new TreeMap<Long, ITmfStateInterval>();
            for (ITmfStateInterval interval : intervals) {
                String baddrStr = stateSystem.getAttributeName(interval.getAttribute());
                long baddr = Long.parseLong(baddrStr);
                map.put(baddr, interval);
            }
            lastEntry = map.lastEntry();
            if (lastEntry != null) break block6;
            return null;
        }
        try {
            String filename = String.valueOf(((ITmfStateInterval)lastEntry.getValue()).getValue());
            TmfResolvedSymbol symbol = this.getSymbolInFile(pid, filename, address, (Long)lastEntry.getKey());
            return symbol == null ? new TmfResolvedSymbol(((Long)lastEntry.getKey()).longValue(), filename) : symbol;
        }
        catch (IndexOutOfBoundsException | StateSystemDisposedException | TimeRangeException e) {
            Activator.getInstance().logWarning("Exceptions while getting perf mmap symbol", e);
            return this.getSymbol(address);
        }
    }

    private @Nullable TmfResolvedSymbol getSymbolInFile(int pid, String filename, long address, long offset) {
        TmfResolvedSymbol symbolEntry;
        long addressInFile = address - offset;
        IMappingFile mappingFile = this.fSymbolMapping.get(filename);
        if (mappingFile == null) {
            Path path = Paths.get(filename, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            mappingFile = IMappingFile.create((String)filename, (boolean)true, (int)pid);
            if (mappingFile == null) {
                return null;
            }
            this.fSymbolMapping.put(filename, mappingFile);
        }
        return (symbolEntry = mappingFile.getSymbolEntry(addressInFile)) == null ? null : new TmfLibrarySymbol(symbolEntry.getBaseAddress() + offset, symbolEntry.getSymbolName(), filename);
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public @Nullable TmfResolvedSymbol getSymbol(long address) {
        return null;
    }
}

