/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.presentation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;

public class QualitativePaletteProvider
implements IPaletteProvider {
    private final List<RGBAColor> fColors;
    private final int fNbColors;
    private final float fSaturation;
    private final float fBrightness;
    private final float fAttenuationFactor;

    public QualitativePaletteProvider(int nbColors, float saturation, float brightness, float attenuationFactor) {
        this.fNbColors = nbColors;
        this.fSaturation = saturation;
        this.fBrightness = brightness;
        this.fAttenuationFactor = attenuationFactor;
        ImmutableList.Builder builder = new ImmutableList.Builder();
        boolean odd = false;
        float hue = 0.0f;
        double step = Math.PI * 2 / (double)(nbColors + 1);
        int i = 0;
        while (i < nbColors) {
            hue = (float)((double)hue + step);
            RGBAColor color = odd ? RGBAColor.fromHSBA(hue, saturation * (1.0f - attenuationFactor), brightness * (1.0f - attenuationFactor), 1.0f) : RGBAColor.fromHSBA(hue, saturation, brightness, 1.0f);
            builder.add((Object)color);
            odd = !odd;
            ++i;
        }
        this.fColors = builder.build();
    }

    public int getNbColors() {
        return this.fNbColors;
    }

    public float getSaturation() {
        return this.fSaturation;
    }

    public float getBrightness() {
        return this.fBrightness;
    }

    public float getAttenuationFactor() {
        return this.fAttenuationFactor;
    }

    @Override
    public List<RGBAColor> get() {
        return this.fColors;
    }

    public static class Builder {
        private static final float DEFAULT_BRIGHTNESS = 0.8f;
        private static final float DEFAULT_SATURATION = 0.8f;
        private static final int DEFAULT_NB_COLOR = 360;
        private int fBuilderNbColors = 360;
        private float fBuilderSaturation = 0.8f;
        private float fBuilderBrightness = 0.8f;
        private float fBuilderAttenuation = 0.15f;

        public Builder setBrightness(float brightness) {
            this.fBuilderBrightness = brightness;
            return this;
        }

        public Builder setSaturation(float saturation) {
            this.fBuilderSaturation = saturation;
            return this;
        }

        public Builder setNbColors(int nbColors) {
            this.fBuilderNbColors = nbColors;
            return this;
        }

        public Builder setAttenuation(float attenuation) {
            this.fBuilderAttenuation = attenuation;
            return this;
        }

        public QualitativePaletteProvider build() {
            return new QualitativePaletteProvider(this.fBuilderNbColors, this.fBuilderSaturation, this.fBuilderBrightness, this.fBuilderAttenuation);
        }
    }
}

