/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.TmfCheckboxChangedSignal;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.eventdensity.EventDensityViewer;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.TmfGenericTreeEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfXYChartSettings;

public class MultipleEventDensityViewer
extends EventDensityViewer {
    List<ITmfTreeViewerEntry> fWholeTraceList = new ArrayList<ITmfTreeViewerEntry>();

    public MultipleEventDensityViewer(Composite parent, TmfXYChartSettings settings) {
        super(parent, settings);
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(@Nullable TmfSelectionRangeUpdatedSignal signal) {
        ITmfTrace trace;
        if (signal == null) {
            return;
        }
        if (!(signal.getSource() instanceof MultipleEventDensityViewer)) {
            trace = this.getTrace();
            if (trace != null) {
                ITmfTimestamp selectedTime = signal.getBeginTime();
                ITmfTimestamp selectedEndTime = signal.getEndTime();
                TmfTraceManager.getInstance().updateTraceContext(trace, builder -> builder.setSelection(new TmfTimeRange(selectedTime, selectedEndTime)));
            }
            super.selectionRangeUpdated(signal);
        }
        if (signal.getSource() == this && (trace = this.getTrace()) != null) {
            long selectedTime = signal.getBeginTime().toNanos();
            long selectedEndTime = signal.getEndTime().toNanos();
            this.setSelectionRange(selectedTime, selectedEndTime);
        }
    }

    public void handleCheckStateChangedEvent(Collection<ITmfTreeViewerEntry> entries) {
        super.handleCheckStateChangedEvent(entries);
        this.updateTraceList(entries);
        ArrayList<String> traceNames = new ArrayList<String>();
        for (ITmfTreeViewerEntry entry : entries) {
            TmfTreeDataModel model;
            TmfGenericTreeEntry genericEntry;
            if (!(entry instanceof TmfGenericTreeEntry) || !((genericEntry = (TmfGenericTreeEntry)entry).getModel() instanceof TmfTreeDataModel) || (model = (TmfTreeDataModel)genericEntry.getModel()) == null) continue;
            String name = model.getName();
            traceNames.add(name);
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfCheckboxChangedSignal((Object)this, traceNames));
    }

    private void updateTraceList(Collection<ITmfTreeViewerEntry> entries) {
        for (ITmfTreeViewerEntry entry : entries) {
            if (this.fWholeTraceList.contains(entry)) continue;
            this.fWholeTraceList.add(entry);
        }
    }

    public List<ITmfTreeViewerEntry> getWholeCheckedItems() {
        return this.fWholeTraceList;
    }

    public void updateCheckStateChangedEvent(Collection<ITmfTreeViewerEntry> entries) {
        super.handleCheckStateChangedEvent(entries);
    }
}

