/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.strategies;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceContext;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocation;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocationInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersion;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceVersionHeader;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceIterator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.parser.BinaryFTraceFileParser;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.strategies.IBinaryFTraceStrategy;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.BinaryFTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class BinaryFTraceV6Strategy
implements IBinaryFTraceStrategy {
    private static final byte[] MAGIC_VALUES = new byte[]{23, 8, 68, 116, 114, 97, 99, 105, 110, 103};
    private BinaryFTraceHeaderInfo fTraceHeaderData;
    private final @NonNull BinaryFTrace fFTrace;

    public BinaryFTraceV6Strategy(@NonNull BinaryFTrace trace) {
        this.fFTrace = trace;
    }

    public static boolean validate(BinaryFTraceVersionHeader versionHeader) {
        boolean isValidMagicValue = Arrays.equals(MAGIC_VALUES, versionHeader.getMagicValues());
        boolean isSupportedVersion = versionHeader.getFTraceVersion().equals(BinaryFTraceVersion.V6);
        return isValidMagicValue && isSupportedVersion;
    }

    @Override
    public void initTrace(String path) throws TmfTraceException {
        this.fTraceHeaderData = BinaryFTraceFileParser.parse(path);
        BinaryFTraceContext ctx = (BinaryFTraceContext)this.fFTrace.seekEvent(0L);
        if (ctx.getLocation().equals((Object)BinaryFTraceIterator.NULL_LOCATION) || ctx.getCurrentEvent() == null) {
            this.fFTrace.setStartTime(TmfTimestamp.BIG_BANG);
        } else {
            ITmfEvent event = this.fFTrace.getNext(ctx);
            ITmfTimestamp curTime = event.getTimestamp();
            this.fFTrace.setStartTime(curTime);
            this.fFTrace.setEndTime(curTime);
        }
    }

    @Override
    public ITmfEvent getNext(ITmfContext context) {
        if (this.fTraceHeaderData == null) {
            return null;
        }
        GenericFtraceEvent event = null;
        if (context instanceof BinaryFTraceContext) {
            if (context.getLocation() == null || BinaryFTraceLocation.INVALID_LOCATION.equals(context.getLocation().getLocationInfo())) {
                return null;
            }
            BinaryFTraceContext ftraceCtx = (BinaryFTraceContext)context;
            event = ftraceCtx.getCurrentEvent();
            if (event != null) {
                this.fFTrace.updateAttributes(context, (ITmfEvent)event);
                ftraceCtx.advance();
                ftraceCtx.increaseRank();
            }
        }
        return event;
    }

    @Override
    public ITmfContext seekEvent(ITmfLocation location) {
        BinaryFTraceLocation currentLocation = (BinaryFTraceLocation)location;
        BinaryFTraceContext context = new BinaryFTraceContext(this.fFTrace);
        if (this.fTraceHeaderData == null) {
            context.setLocation(null);
            context.setRank(-1L);
            return context;
        }
        if (currentLocation == null) {
            currentLocation = new BinaryFTraceLocation(new BinaryFTraceLocationInfo(0L, 0L));
            context.setRank(0L);
        } else {
            context.setRank(-1L);
        }
        context.setLocation((ITmfLocation)currentLocation);
        return context;
    }

    @Override
    public ITmfContext createIterator() throws IOException {
        return new BinaryFTraceIterator(this.fTraceHeaderData, this.fFTrace);
    }

    @Override
    public void dispose() {
        this.fTraceHeaderData = null;
    }
}

