/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.callstack.context;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxPidAspect;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.incubator.analysis.core.concepts.AggregatedCallSite;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.ITree;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.base.CallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.CallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackGroupDescriptor;
import org.eclipse.tracecompass.incubator.callstack.core.sampled.callgraph.ProfilingCallGraphAnalysisModule;
import org.eclipse.tracecompass.incubator.internal.kernel.core.callstack.context.Messages;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class ContextCallStackAnalysis
extends ProfilingCallGraphAnalysisModule {
    public static final String ID = "org.eclipse.tracecompass.incubator.kernel.core.callstack.core.context";
    private static final long UNDEFINED_SYMBOL = -1L;
    private static final String KERNEL_CALLSTACK_FIELD = "context._callstack_kernel";
    private static final String USER_CALLSTACK_FIELD = "context._callstack_user";
    private static final String KERNEL_STACK_NAME = "kernel";
    private static final String USER_STACK_NAME = "user";
    private final CallStackGroupDescriptor fEventDescriptor = new CallStackGroupDescriptor(Objects.requireNonNull(Messages.ContextCallStackAnalysis_GroupEvents), null, false);
    private final CallStackGroupDescriptor fProcessDescriptor = new CallStackGroupDescriptor(Objects.requireNonNull(Messages.ContextCallStackAnalysis_GroupProcess), (ICallStackGroupDescriptor)this.fEventDescriptor, false);
    private final CallStackGroupDescriptor fThreadDescriptor = new CallStackGroupDescriptor(Objects.requireNonNull(Messages.ContextCallStackAnalysis_GroupThread), (ICallStackGroupDescriptor)this.fProcessDescriptor, false);

    protected @Nullable Pair<ICallStackElement, AggregatedCallSite> getProfiledStackTrace(ITmfEvent event) {
        Collection<Object> userCs;
        Map<String, Collection<Object>> callStack = this.getCallStack(event);
        if (callStack.isEmpty()) {
            return null;
        }
        ICallStackElement element = this.getElement(event);
        Collection<Object> kernelCs = callStack.get(KERNEL_STACK_NAME);
        if (kernelCs == null) {
            kernelCs = Collections.emptyList();
        }
        if ((userCs = callStack.get(USER_STACK_NAME)) == null) {
            userCs = Collections.emptyList();
        }
        if (kernelCs.size() + userCs.size() == 0) {
            long[] stack = new long[]{0L};
            return new Pair((Object)element, (Object)this.getCallSite(element, stack, event.getTimestamp().getValue()));
        }
        long[] stack = new long[userCs.size() + kernelCs.size()];
        int i = 0;
        for (Object call : userCs) {
            stack[i] = call instanceof Long ? (Long)call : -1L;
            ++i;
        }
        for (Object call : kernelCs) {
            stack[i] = call instanceof Long ? (Long)call : -1L;
            ++i;
        }
        return new Pair((Object)element, (Object)this.getCallSite(element, stack, event.getTimestamp().getValue()));
    }

    private ICallStackElement getElement(ITmfEvent event) {
        int pid;
        Collection rootElements = this.getRootElements();
        String name = event.getName();
        Optional<ICallStackElement> events = rootElements.stream().filter(e -> e.getName().equals(String.valueOf(name))).findFirst();
        Integer threadId = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxTidAspect.class, (ITmfEvent)event);
        int tid = threadId == null ? -1 : threadId;
        Integer pId = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), LinuxPidAspect.class, (ITmfEvent)event);
        int n = pid = pId == null ? -1 : pId;
        if (events.isPresent()) {
            Object processEl;
            ICallStackElement eventEl = events.get();
            Optional<ICallStackElement> process = eventEl.getChildrenElements().stream().filter(e -> e.getName().equals(String.valueOf(pid))).findFirst();
            if (process.isPresent()) {
                processEl = process.get();
            } else {
                processEl = new CallStackElement(String.valueOf(pid), (IWeightedTreeGroupDescriptor)this.fProcessDescriptor, (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, eventEl){

                    protected int retrieveSymbolKeyAt(long time) {
                        return pid;
                    }
                };
                processEl.setSymbolKeyElement(processEl);
                eventEl.addChild((ITree)processEl);
            }
            Optional<ICallStackElement> thread = processEl.getChildrenElements().stream().filter(e -> e.getName().equals(String.valueOf(tid))).findFirst();
            if (thread.isPresent()) {
                return thread.get();
            }
            CallStackElement threadEl = new CallStackElement(String.valueOf(tid), (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, null, processEl);
            processEl.addChild((ITree)threadEl);
            return threadEl;
        }
        CallStackElement eventEl = new CallStackElement(name, (IWeightedTreeGroupDescriptor)this.fEventDescriptor, null, null);
        CallStackElement processEl = new CallStackElement(String.valueOf(pid), (IWeightedTreeGroupDescriptor)this.fProcessDescriptor, null, (ICallStackElement)eventEl);
        processEl.setSymbolKeyElement((ICallStackElement)processEl);
        CallStackElement threadEl = new CallStackElement(String.valueOf(tid), (IWeightedTreeGroupDescriptor)this.fThreadDescriptor, null, (ICallStackElement)processEl);
        this.addRootElement((ICallStackElement)eventEl);
        return threadEl;
    }

    public static @Nullable Integer getCpu(ITmfEvent event) {
        Integer cpuObj = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        if (cpuObj == null) {
            return null;
        }
        return cpuObj;
    }

    public Map<String, Collection<Object>> getCallStack(ITmfEvent event) {
        HashMap<String, Collection<Object>> map = new HashMap<String, Collection<Object>>();
        ITmfEventField content = event.getContent();
        ITmfEventField field = content.getField(new String[]{KERNEL_CALLSTACK_FIELD});
        if (field != null) {
            map.put(KERNEL_STACK_NAME, ContextCallStackAnalysis.getCallstack(field));
        }
        if ((field = content.getField(new String[]{USER_CALLSTACK_FIELD})) != null) {
            map.put(USER_STACK_NAME, ContextCallStackAnalysis.getCallstack(field));
        }
        return map;
    }

    private static Collection<Object> getCallstack(ITmfEventField field) {
        Object value = field.getValue();
        if (!(value instanceof long[])) {
            return Collections.emptyList();
        }
        long[] callstack = (long[])value;
        ArrayList<Object> longList = new ArrayList<Object>();
        long[] lArray = callstack;
        int n = callstack.length;
        int n2 = 0;
        while (n2 < n) {
            long callsite = lArray[n2];
            longList.add(callsite);
            ++n2;
        }
        Collections.reverse(longList);
        return longList;
    }

    public Collection<IWeightedTreeGroupDescriptor> getGroupDescriptors() {
        return ImmutableList.of((Object)this.fEventDescriptor);
    }
}

