/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraphVisitor;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.TmfEdgeState;
import org.eclipse.tracecompass.analysis.os.linux.core.execution.graph.OsWorker;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.WeightedTree;
import org.eclipse.tracecompass.incubator.internal.kernel.core.criticalpath.Messages;

public class CriticalPathWeighted
implements IWeightedTreeSet<Object, String, WeightedTree<Object>> {
    private static final CriticalPathWeighted EMPTY_CRIT_PATH_CG = new CriticalPathWeighted();
    private static final String ALL_SUFFIX = String.valueOf(Messages.CriticalPathWeighted_ByStatus);
    private static final String PROCESS_SUFFIX = String.valueOf(Messages.CriticalPathWeighted_ByProcessName);
    private static final String THREAD_SUFFIX = String.valueOf(Messages.CriticalPathWeighted_ByThread);
    private final List<String> fElements;
    private WeightedTree<Object> fAggregatedTree;
    private WeightedTree<Object> fTree;
    private WeightedTree<Object> fProcessTree;

    private CriticalPathWeighted() {
        this.fElements = Collections.emptyList();
        this.fTree = new WeightedTree((Object)"");
        this.fAggregatedTree = new WeightedTree((Object)"");
        this.fProcessTree = new WeightedTree((Object)"");
    }

    public static CriticalPathWeighted create(@Nullable ITmfGraph graph) {
        if (graph == null) {
            return EMPTY_CRIT_PATH_CG;
        }
        ITmfVertex head = graph.getHead();
        if (head == null) {
            return EMPTY_CRIT_PATH_CG;
        }
        return new CriticalPathWeighted(graph);
    }

    private CriticalPathWeighted(ITmfGraph graph) {
        ITmfVertex head = graph.getHead();
        if (head == null) {
            throw new NullPointerException("Empty graph");
        }
        IGraphWorker worker = graph.getParentOf(head);
        if (worker == null) {
            throw new NullPointerException("head vertex has no parent");
        }
        this.fElements = ImmutableList.of((Object)(String.valueOf(worker) + THREAD_SUFFIX), (Object)(String.valueOf(worker) + ALL_SUFFIX), (Object)(String.valueOf(worker) + PROCESS_SUFFIX));
        this.fTree = new WeightedTree((Object)(String.valueOf(worker) + THREAD_SUFFIX));
        this.fAggregatedTree = new WeightedTree((Object)(String.valueOf(worker) + ALL_SUFFIX));
        this.fProcessTree = new WeightedTree((Object)(String.valueOf(worker) + PROCESS_SUFFIX));
        GraphToCallGraphConverter converter = new GraphToCallGraphConverter(worker, graph);
        graph.scanLineTraverse(worker, (ITmfGraphVisitor)converter);
    }

    public Collection<WeightedTree<Object>> getTreesFor(Object element) {
        if (!(element instanceof String)) {
            return Collections.emptyList();
        }
        String elStr = (String)element;
        if (elStr.endsWith(ALL_SUFFIX)) {
            return this.fAggregatedTree.getChildren();
        }
        if (elStr.endsWith(PROCESS_SUFFIX)) {
            return this.fProcessTree.getChildren();
        }
        return this.fTree.getChildren();
    }

    public Collection<String> getElements() {
        return this.fElements;
    }

    private class GraphToCallGraphConverter
    implements ITmfGraphVisitor {
        private final ITmfGraph fGraph;
        private final IGraphWorker fMainWorker;

        public GraphToCallGraphConverter(IGraphWorker mainWorker, ITmfGraph graph) {
            this.fGraph = graph;
            this.fMainWorker = mainWorker;
        }

        public void visitHead(ITmfVertex vertex) {
        }

        public void visit(ITmfVertex vertex) {
        }

        public void visit(ITmfEdge edge, boolean horizontal) {
            if (edge.getDuration() == 0L) {
                return;
            }
            this.addEdgeToElement(edge);
            this.addEdgeToAggregatedElement(edge);
            this.addEdgeToProcessElement(edge);
        }

        private void addEdgeToAggregatedElement(ITmfEdge edge) {
            IGraphWorker worker = this.fGraph.getParentOf(edge.getVertexTo());
            if (worker == null) {
                return;
            }
            if (worker != this.fMainWorker && edge.getEdgeContextState().getEdgeState().equals((Object)TmfEdgeState.PASS)) {
                WeightedTree callSite = new WeightedTree((Object)String.valueOf(Messages.CriticalPathWeighted_OtherRunningProcess));
                callSite.addToWeight(edge.getDuration());
                CriticalPathWeighted.this.fAggregatedTree.addChild(callSite);
                return;
            }
            WeightedTree callSite = new WeightedTree((Object)edge.getEdgeContextState().getContextEnum());
            callSite.addToWeight(edge.getDuration());
            CriticalPathWeighted.this.fAggregatedTree.addChild(callSite);
        }

        private void addEdgeToElement(ITmfEdge edge) {
            WeightedTree workerTree;
            IGraphWorker worker = this.fGraph.getParentOf(edge.getVertexTo());
            if (worker == null) {
                return;
            }
            if (worker == this.fMainWorker) {
                workerTree = new WeightedTree((Object)String.valueOf(Messages.CriticalPathWeighted_SelfWorker));
                workerTree.addToWeight(edge.getDuration());
            } else {
                workerTree = new WeightedTree((Object)String.valueOf(worker));
                workerTree.addToWeight(edge.getDuration());
            }
            if (!edge.getEdgeContextState().getEdgeState().equals((Object)TmfEdgeState.PASS)) {
                WeightedTree childType = new WeightedTree((Object)edge.getEdgeContextState().getContextEnum());
                childType.addToWeight(edge.getDuration());
                workerTree.addChild(childType);
            }
            CriticalPathWeighted.this.fTree.addChild(workerTree);
        }

        private void addEdgeToProcessElement(ITmfEdge edge) {
            WeightedTree workerTree;
            IGraphWorker worker = this.fGraph.getParentOf(edge.getVertexTo());
            if (worker == null) {
                return;
            }
            if (worker == this.fMainWorker) {
                workerTree = new WeightedTree((Object)String.valueOf(Messages.CriticalPathWeighted_SelfWorker));
                workerTree.addToWeight(edge.getDuration());
            } else {
                workerTree = new WeightedTree((Object)((OsWorker)worker).getName());
                workerTree.addToWeight(edge.getDuration());
            }
            if (!edge.getEdgeContextState().getEdgeState().equals((Object)TmfEdgeState.PASS)) {
                WeightedTree typeTree = new WeightedTree((Object)edge.getEdgeContextState().getContextEnum());
                typeTree.addToWeight(edge.getDuration());
                workerTree.addChild(typeTree);
            }
            CriticalPathWeighted.this.fProcessTree.addChild(workerTree);
        }
    }
}

