/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.parser.Scanner;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.util.CodeSnippetParsingUtil;
import org.eclipse.wst.jsdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.wst.jsdt.internal.formatter.DefaultCodeFormatterOptions;
import org.eclipse.wst.jsdt.internal.formatter.comment.CommentRegion;
import org.eclipse.wst.jsdt.internal.formatter.comment.JavaDocRegion;
import org.eclipse.wst.jsdt.internal.formatter.comment.MultiCommentRegion;

public class DefaultCodeFormatter
extends CodeFormatter {
    public static final boolean DEBUG = false;
    private static Scanner ProbingScanner;
    private CodeSnippetParsingUtil codeSnippetParsingUtil;
    private Map defaultCompilerOptions;
    private CodeFormatterVisitor newCodeFormatter;
    private Map options;
    private DefaultCodeFormatterOptions preferences;

    public static CommentRegion createRegion(int kind, IDocument document, Position range, CodeFormatterVisitor formatter) {
        switch (kind) {
            case 16: {
                return new CommentRegion(document, range, formatter);
            }
            case 32: {
                return new MultiCommentRegion(document, range, formatter);
            }
            case 64: {
                return new JavaDocRegion(document, range, formatter);
            }
        }
        return null;
    }

    public DefaultCodeFormatter() {
        this(new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings()), null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public DefaultCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map options) {
        if (options != null) {
            this.options = options;
            this.preferences = new DefaultCodeFormatterOptions(options);
        } else {
            this.options = JavaScriptCore.getOptions();
            this.preferences = new DefaultCodeFormatterOptions(DefaultCodeFormatterConstants.getJavaConventionsSettings());
        }
        this.defaultCompilerOptions = this.getDefaultCompilerOptions();
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public DefaultCodeFormatter(Map options) {
        this(null, options);
    }

    @Override
    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        int spaces = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                spaces = indentationLevel * this.preferences.tab_size;
                break;
            }
            case 1: {
                tabs = indentationLevel;
                break;
            }
            case 4: {
                int tabSize = this.preferences.tab_size;
                int spaceEquivalents = indentationLevel * this.preferences.indentation_size;
                tabs = spaceEquivalents / tabSize;
                spaces = spaceEquivalents % tabSize;
                break;
            }
            default: {
                return Util.EMPTY_STRING;
            }
        }
        if (tabs == 0 && spaces == 0) {
            return Util.EMPTY_STRING;
        }
        StringBuffer buffer = new StringBuffer(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        if (offset < 0 || length < 0 || length > source.length()) {
            throw new IllegalArgumentException(offset + ":" + length);
        }
        this.codeSnippetParsingUtil = new CodeSnippetParsingUtil();
        switch (kind) {
            case 4: {
                return this.formatClassBodyDeclarations(source, indentationLevel, lineSeparator, offset, length);
            }
            case 8: {
                return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
            }
            case 1: {
                return this.formatExpression(source, indentationLevel, lineSeparator, offset, length);
            }
            case 2: {
                return this.formatStatements(source, indentationLevel, lineSeparator, offset, length);
            }
            case 0: {
                return this.probeFormatting(source, indentationLevel, lineSeparator, offset, length);
            }
            case 16: 
            case 32: 
            case 64: {
                return this.formatComment(kind, source, indentationLevel, lineSeparator, offset, length);
            }
        }
        return null;
    }

    private TextEdit formatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ASTNode[] bodyDeclarations = this.codeSnippetParsingUtil.parseClassBodyDeclarations(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (bodyDeclarations == null) {
            return null;
        }
        return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
    }

    private TextEdit formatComment(int kind, String source, int indentationLevel, String lineSeparator, int offset, int length) {
        Object oldOption = this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_comments");
        boolean isFormattingComments = false;
        if (oldOption == null) {
            switch (kind) {
                case 16: {
                    isFormattingComments = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments"));
                    break;
                }
                case 32: {
                    isFormattingComments = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments"));
                    break;
                }
                case 64: {
                    isFormattingComments = "true".equals(this.options.get("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments"));
                }
            }
        } else {
            isFormattingComments = "true".equals(oldOption);
        }
        if (isFormattingComments) {
            this.preferences.line_separator = lineSeparator != null ? lineSeparator : Util.LINE_SEPARATOR;
            this.preferences.initial_indentation_level = indentationLevel;
            this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, null);
            CommentRegion region = DefaultCodeFormatter.createRegion(kind, (IDocument)new Document(source), new Position(offset, length), this.newCodeFormatter);
            if (region != null) {
                return this.newCodeFormatter.format(source, region);
            }
        }
        return new MultiTextEdit();
    }

    private TextEdit formatCompilationUnit(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        CompilationUnitDeclaration compilationUnitDeclaration = this.codeSnippetParsingUtil.parseCompilationUnit(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, compilationUnitDeclaration);
    }

    private TextEdit formatExpression(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        Expression expression = this.codeSnippetParsingUtil.parseExpression(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression == null) {
            return null;
        }
        return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
    }

    private TextEdit formatStatements(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(source.toCharArray(), this.getDefaultCompilerOptions(), true, false);
        if (constructorDeclaration.statements == null) {
            return null;
        }
        return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
    }

    public String getDebugOutput() {
        return this.newCodeFormatter.scribe.toString();
    }

    private Map getDefaultCompilerOptions() {
        Object sourceOption;
        if (this.defaultCompilerOptions == null) {
            HashMap<String, String> optionsMap = new HashMap<String, String>(30);
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.debug.localVariable", "do not generate");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.debug.lineNumber", "do not generate");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.debug.sourceFile", "do not generate");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.unusedLocal", "preserve");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.methodWithConstructorName", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.undefinedField", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.overridingMethodWithoutSuperInvocation", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecation", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.hiddenCatchBlock", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedLocal", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameter", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.wrongNumberOfArguments", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.noEffectAssignment", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.nonExternalizedStringLiteral", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.staticAccessReceiver", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.indirectStaticAccess", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedPrivateMember", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.localVariableHiding", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.fieldHiding", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.possibleAccidentalBooleanAssignment", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.emptyStatement", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.enumIdentifier", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.undocumentedEmptyBlock", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unnecessaryTypeCheck", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadoc", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsVisibility", "public");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTags", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTags", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsVisibility", "public");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocTagsOverriding", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocComments", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsVisibility", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.missingJavadocCommentsOverriding", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.finallyBlockNotCompletingNormally", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownException", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedDeclaredThrownExceptionWhenOverriding", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unqualifiedFieldAccess", "ignore");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.compliance", "1.4");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.2");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.taskPriorities", "");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.taskCaseSensitive", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameterWhenImplementingAbstract", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.unusedParameterWhenOverridingConcrete", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.problem.specialParameterHidingField", "disabled");
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.maxProblemPerUnit", String.valueOf(100));
            optionsMap.put("org.eclipse.wst.jsdt.core.compiler.codegen.inlineJsrBytecode", "disabled");
            this.defaultCompilerOptions = optionsMap;
        }
        if ((sourceOption = this.options.get("org.eclipse.wst.jsdt.core.compiler.source")) != null) {
            this.defaultCompilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", sourceOption);
        } else {
            this.defaultCompilerOptions.put("org.eclipse.wst.jsdt.core.compiler.source", "1.3");
        }
        return this.defaultCompilerOptions;
    }

    private TextEdit internalFormatClassBodyDeclarations(String source, int indentationLevel, String lineSeparator, ASTNode[] bodyDeclarations, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, bodyDeclarations);
    }

    private TextEdit internalFormatExpression(String source, int indentationLevel, String lineSeparator, Expression expression, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        TextEdit textEdit = this.newCodeFormatter.format(source, expression);
        return textEdit;
    }

    private TextEdit internalFormatStatements(String source, int indentationLevel, String lineSeparator, ConstructorDeclaration constructorDeclaration, int offset, int length) {
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : Util.LINE_SEPARATOR;
        this.preferences.initial_indentation_level = indentationLevel;
        this.newCodeFormatter = new CodeFormatterVisitor(this.preferences, this.options, offset, length, this.codeSnippetParsingUtil);
        return this.newCodeFormatter.format(source, constructorDeclaration);
    }

    private TextEdit probeFormatting(String source, int indentationLevel, String lineSeparator, int offset, int length) {
        if (ProbingScanner == null) {
            ProbingScanner = new Scanner(true, true, false, 0x2F0000L, 0x2F0000L, null, null, true);
        }
        ProbingScanner.setSource(source.toCharArray());
        ProbingScanner.resetTo(offset, offset + length);
        try {
            switch (ProbingScanner.getNextToken()) {
                case 1002: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == offset + length - 1) {
                        return this.formatComment(32, source, indentationLevel, lineSeparator, offset, length);
                    }
                    break;
                }
                case 1001: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == offset + length - 1) {
                        return this.formatComment(16, source, indentationLevel, lineSeparator, offset, length);
                    }
                    break;
                }
                case 1003: {
                    if (ProbingScanner.getCurrentTokenEndPosition() == offset + length - 1) {
                        return this.formatComment(64, source, indentationLevel, lineSeparator, offset, length);
                    }
                    break;
                }
            }
        }
        catch (InvalidInputException invalidInputException) {}
        ProbingScanner.setSource((char[])null);
        Expression expression = this.codeSnippetParsingUtil.parseExpression(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (expression != null) {
            return this.internalFormatExpression(source, indentationLevel, lineSeparator, expression, offset, length);
        }
        ASTNode[] bodyDeclarations = this.codeSnippetParsingUtil.parseClassBodyDeclarations(source.toCharArray(), this.getDefaultCompilerOptions(), true);
        if (bodyDeclarations != null) {
            return this.internalFormatClassBodyDeclarations(source, indentationLevel, lineSeparator, bodyDeclarations, offset, length);
        }
        ConstructorDeclaration constructorDeclaration = this.codeSnippetParsingUtil.parseStatements(source.toCharArray(), this.getDefaultCompilerOptions(), true, false);
        if (constructorDeclaration.statements != null) {
            return this.internalFormatStatements(source, indentationLevel, lineSeparator, constructorDeclaration, offset, length);
        }
        return this.formatCompilationUnit(source, indentationLevel, lineSeparator, offset, length);
    }
}

