/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.types.Encoding;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerRange;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.CtfCoreLoggerUtil;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFAntlrMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.AlignmentParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.ByteOrderParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.SizeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.BaseParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.ClockMapParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.integer.SignedParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.string.EncodingParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class IntegerDeclarationParser
implements ICommonTreeParser {
    public static final IntegerDeclarationParser INSTANCE = new IntegerDeclarationParser();
    private static final @NonNull String ENCODING = "encoding";
    private static final @NonNull String EMPTY_STRING = "";
    private static final int DEFAULT_INT_BASE = 10;
    private static final @NonNull String MAP = "map";
    private static final @NonNull String BASE = "base";
    private static final @NonNull String PREFERRED_BASE = "preferred-display-base";
    private static final @NonNull String BYTE_ORDER = "byte-order";
    private static final @NonNull String SIZE = "size";
    private static final @NonNull String LENGTH = "length";
    private static final @NonNull String SIGNED = "signed";
    private static final @NonNull String ALIGNMENT = "alignment";
    private static final @NonNull String VARINT = "varint";
    private static final @NonNull String MAPPINGS = "mappings";

    private IntegerDeclarationParser() {
    }

    @Override
    public IntegerDeclaration parse(ICTFMetadataNode integer, ICommonTreeParser.ICommonTreeParserParameter parameter) throws ParseException {
        Encoding encoding;
        String clock;
        String role;
        int base;
        long alignment;
        long size;
        ByteOrder byteOrder;
        HashMap<String, List<IntegerRange>> mappings;
        boolean signed;
        block42: {
            CTFTrace trace;
            block41: {
                if (!(parameter instanceof Param)) {
                    throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
                }
                trace = ((Param)parameter).fTrace;
                signed = false;
                boolean varint = false;
                mappings = new HashMap<String, List<IntegerRange>>();
                byteOrder = trace.getByteOrder();
                size = 0L;
                alignment = 0L;
                base = 10;
                role = null;
                clock = EMPTY_STRING;
                encoding = Encoding.NONE;
                if (!(integer instanceof JsonStructureFieldMemberMetadataNode)) break block41;
                JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)integer;
                JsonObject fieldclass = member.getFieldClass().getAsJsonObject();
                role = member.getRole();
                if (fieldclass.has(SIGNED)) {
                    signed = fieldclass.get(SIGNED).getAsBoolean();
                }
                if (fieldclass.has(PREFERRED_BASE)) {
                    base = fieldclass.get(PREFERRED_BASE).getAsInt();
                }
                if (fieldclass.has(VARINT)) {
                    varint = fieldclass.get(VARINT).getAsBoolean();
                }
                if (fieldclass.has(MAPPINGS)) {
                    JsonObject mappingsJson = fieldclass.get(MAPPINGS).getAsJsonObject();
                    for (String mappingName : mappingsJson.keySet()) {
                        if (mappingName == null) continue;
                        JsonArray mappingRangesJson = mappingsJson.getAsJsonArray(mappingName);
                        ArrayList<IntegerRange> mappingRanges = new ArrayList<IntegerRange>();
                        for (JsonElement rangeElement : mappingRangesJson) {
                            JsonArray rangeArray = rangeElement.getAsJsonArray();
                            long start = rangeArray.get(0).getAsBigInteger().longValueExact();
                            long end = rangeArray.get(1).getAsBigInteger().longValueExact();
                            IntegerRange range = new IntegerRange(start, end);
                            mappingRanges.add(range);
                        }
                        mappings.put(mappingName, mappingRanges);
                    }
                }
                if (varint) {
                    if (mappings.size() > 0) {
                        return IntegerDeclaration.createVarintDeclaration(signed, base, role, true, mappings);
                    }
                    return IntegerDeclaration.createVarintDeclaration(signed, base, role, true);
                }
                if (fieldclass.has(ALIGNMENT)) {
                    alignment = fieldclass.get(ALIGNMENT).getAsInt();
                }
                size = fieldclass.get(LENGTH).getAsInt();
                CTFJsonMetadataNode bo = new CTFJsonMetadataNode(integer, CTFParser.tokenNames[121], fieldclass.get(BYTE_ORDER).getAsString());
                byteOrder = ByteOrderParser.INSTANCE.parse(bo, new ByteOrderParser.Param(trace));
                break block42;
            }
            if (!(integer instanceof CTFAntlrMetadataNode)) break block42;
            List<ICTFMetadataNode> children = integer.getChildren();
            if (children == null) {
                throw new ParseException("integer: missing size attribute");
            }
            for (ICTFMetadataNode child : children) {
                block43: {
                    String left;
                    String type = child.getType();
                    if (!CTFParser.tokenNames[86].equals(type)) break block43;
                    ICTFMetadataNode leftNode = child.getChild(0);
                    ICTFMetadataNode rightNode = child.getChild(1);
                    List<ICTFMetadataNode> leftStrings = leftNode.getChildren();
                    if (!TsdlUtils.isAnyUnaryString(leftStrings.get(0))) {
                        throw new ParseException("Left side of ctf expression must be a string");
                    }
                    switch (left = TsdlUtils.concatenateUnaryStrings(leftStrings)) {
                        case "signed": {
                            signed = SignedParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        case "byte_order": {
                            byteOrder = ByteOrderParser.INSTANCE.parse(rightNode, new ByteOrderParser.Param(trace));
                            break;
                        }
                        case "size": {
                            size = SizeParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        case "align": {
                            alignment = AlignmentParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        case "base": {
                            base = BaseParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        case "encoding": {
                            encoding = EncodingParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        case "map": {
                            clock = ClockMapParser.INSTANCE.parse(rightNode, null);
                            break;
                        }
                        default: {
                            CtfCoreLoggerUtil.logWarning("Unknown integer attribute: " + left);
                            break;
                        }
                    }
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        if (size <= 0L) {
            throw new ParseException("Invalid size attribute in Integer: " + size);
        }
        if (alignment == 0L) {
            alignment = 1L;
        }
        if (mappings.size() > 0) {
            return IntegerDeclaration.createDeclaration(base, signed, base, byteOrder, encoding, clock, alignment, role, mappings);
        }
        return IntegerDeclaration.createDeclaration((int)size, signed, base, byteOrder, encoding, clock, alignment, role);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final CTFTrace fTrace;

        public Param(CTFTrace trace) {
            this.fTrace = trace;
        }
    }
}

