/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.traceevent.core.event;

import java.util.logging.Level;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventField;
import org.eclipse.tracecompass.incubator.internal.traceevent.core.event.TraceEventLookup;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEvent;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class TraceEventEvent
extends TmfEvent
implements ITmfSourceLookup {
    private final @Nullable ITmfCallsite fCallsite;
    private final Level fLogLevel;
    private final @NonNull String fName;
    private final TraceEventField fField;

    public TraceEventEvent(ITmfTrace trace, long rank, TraceEventField field) {
        super(trace, rank, trace.createTimestamp(field.getTs()), TraceEventLookup.get(field.getPhase()), field.getContent());
        this.fField = field;
        this.fName = field.getName();
        this.fLogLevel = Level.INFO;
        this.fCallsite = null;
    }

    public ITmfEventField getContent() {
        return this.fField.getContent();
    }

    public @NonNull String getName() {
        return this.fName;
    }

    public @Nullable ITmfCallsite getCallsite() {
        return this.fCallsite;
    }

    public Level getLevel() {
        return this.fLogLevel;
    }

    public TraceEventField getField() {
        return this.fField;
    }
}

