/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.criticalpath.OSCriticalPathModule;
import org.eclipse.tracecompass.internal.analysis.graph.core.dataprovider.OSCriticalPathDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfStartAnalysisSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class OSCriticalPathDataProviderFactory
implements IDataProviderFactory {
    private final Map<ITmfTrace, OSCriticalPathModule> map = new HashMap<ITmfTrace, OSCriticalPathModule>();

    public OSCriticalPathDataProviderFactory() {
        TmfSignalManager.register((Object)this);
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(@NonNull ITmfTrace trace) {
        OSCriticalPathModule module = this.map.remove(trace);
        if (module == null) {
            return null;
        }
        return new OSCriticalPathDataProvider(trace, module);
    }

    @TmfSignalHandler
    public synchronized void analysisStarted(TmfStartAnalysisSignal startAnalysisSignal) {
        IAnalysisModule analysis = startAnalysisSignal.getAnalysisModule();
        if (analysis instanceof OSCriticalPathModule) {
            OSCriticalPathModule criticalPath = (OSCriticalPathModule)analysis;
            this.map.put(criticalPath.getTrace(), criticalPath);
        }
    }

    @TmfSignalHandler
    public synchronized void traceClosed(TmfTraceClosedSignal traceClosedSignal) {
        this.map.remove(traceClosedSignal.getTrace());
    }
}

