/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBuffer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.SourceRange;
import org.eclipse.core.runtime.IProgressMonitor;

class SourceManipulationInfo
extends CElementInfo {
    protected int fStartPos;
    protected int fLength;
    protected int fIdStartPos;
    protected int fIdLength;
    protected int fStartLine;
    protected int fEndLine;

    protected SourceManipulationInfo(CElement element) {
        super(element);
        this.setIsStructureKnown(true);
    }

    public void setPos(int startPos, int length) {
        this.fStartPos = startPos;
        this.fLength = length;
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public int getLength() {
        return this.fLength;
    }

    public void setIdPos(int startPos, int length) {
        this.fIdStartPos = startPos;
        this.fIdLength = length;
    }

    public int getIdStartPos() {
        return this.fIdStartPos;
    }

    public int getIdLength() {
        return this.fIdLength;
    }

    public int getStartLine() {
        return this.fStartLine;
    }

    public int getEndLine() {
        return this.fEndLine;
    }

    public void setLines(int startLine, int endLine) {
        this.fStartLine = startLine;
        this.fEndLine = endLine;
    }

    protected ISourceRange getSourceRange() {
        return new SourceRange(this.fStartPos, this.fLength, this.fIdStartPos, this.fIdLength, this.fStartLine, this.fEndLine);
    }

    public String getSource() throws CModelException {
        ITranslationUnit unit = this.getTranslationUnit();
        IBuffer buffer = unit.getBuffer();
        if (buffer == null) {
            return null;
        }
        int offset = this.fStartPos;
        int length = this.fLength;
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement celem = this.getElement();
        while (celem != null) {
            if (celem instanceof ITranslationUnit) {
                return (ITranslationUnit)celem;
            }
            celem = celem.getParent();
        }
        return null;
    }

    public void copy(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException(CoreModelMessages.getString("operation.nullContainer"));
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getElement().getCModel().copy(elements, containers, siblings, renamings, force, monitor);
    }

    public void delete(boolean force, IProgressMonitor monitor) throws CModelException {
        ICElement[] elements = new ICElement[]{this.getElement()};
        this.getElement().getCModel().delete(elements, force, monitor);
    }

    public void move(ICElement container, ICElement sibling, String rename, boolean force, IProgressMonitor monitor) throws CModelException {
        if (container == null) {
            throw new IllegalArgumentException(CoreModelMessages.getString("operation.nullContainer"));
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] containers = new ICElement[]{container};
        ICElement[] siblings = null;
        if (sibling != null) {
            siblings = new ICElement[]{sibling};
        }
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getElement().getCModel().move(elements, containers, siblings, renamings, force, monitor);
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws CModelException {
        if (name == null) {
            throw new IllegalArgumentException("element.nullName");
        }
        ICElement[] elements = new ICElement[]{this.getElement()};
        ICElement[] dests = new ICElement[]{this.getElement().getParent()};
        String[] renamings = new String[]{name};
        this.getElement().getCModel().rename(elements, dests, renamings, force, monitor);
    }

    public int getModifiers() {
        return 0;
    }

    public boolean hasSameContentsAs(SourceManipulationInfo otherInfo) {
        return this.element.fType == otherInfo.element.fType;
    }
}

