/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.types;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.io.BitBuffer;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FloatDefinitionTest {
    private FloatDefinition fixture;
    private FloatDefinition singleFixture;
    private FloatDefinition doubleFixture;
    private FloatDeclaration parent;
    private static final @NonNull String fieldName = "float";

    @Before
    public void setUp() throws CTFException {
        this.testFloat248();
        this.testFloat5311();
    }

    @Test
    public void testFloat248() throws CTFException {
        this.parent = new FloatDeclaration(8, 24, ByteOrder.nativeOrder(), 0L);
        BitBuffer bb = FloatDefinitionTest.create32BitFloatByteBuffer();
        this.singleFixture = this.parent.createDefinition(null, fieldName, bb);
        Assert.assertNotNull((Object)this.singleFixture);
    }

    @Test
    public void testFloat5311() throws CTFException {
        this.parent = new FloatDeclaration(11, 53, ByteOrder.nativeOrder(), 0L);
        BitBuffer bb = FloatDefinitionTest.create64BitFloatByteBuffer();
        this.doubleFixture = this.parent.createDefinition(null, fieldName, bb);
        Assert.assertNotNull((Object)this.doubleFixture);
    }

    @Test
    public void testFloat32Bit() throws CTFException {
        int i = 1;
        while (i < 31) {
            this.parent = new FloatDeclaration(i, 32 - i, ByteOrder.nativeOrder(), 0L);
            this.fixture = this.parent.createDefinition(null, fieldName, FloatDefinitionTest.create32BitFloatByteBuffer());
            Assert.assertNotNull((Object)this.fixture);
            Assert.assertEquals((String)("test" + i), (Object)"2.0", (Object)this.fixture.toString());
            ++i;
        }
    }

    @Test
    public void testFloat64Bit() throws CTFException {
        int i = 1;
        while (i < 63) {
            this.parent = new FloatDeclaration(i, 64 - i, ByteOrder.nativeOrder(), 0L);
            this.fixture = this.parent.createDefinition(null, fieldName, FloatDefinitionTest.create64BitFloatByteBuffer());
            Assert.assertNotNull((Object)this.fixture);
            if (i <= 32) {
                Assert.assertEquals((String)("test" + i), (Object)"2.0", (Object)this.fixture.toString());
            } else if (i == 33) {
                Assert.assertEquals((String)("test" + i), (Object)"1.0", (Object)this.fixture.toString());
            } else {
                Assert.assertNotNull((Object)this.fixture.getValue());
            }
            ++i;
        }
    }

    @Test
    public void testFloat32BitNeg() throws CTFException {
        int i = 1;
        while (i < 31) {
            this.parent = new FloatDeclaration(i, 32 - i, ByteOrder.nativeOrder(), 0L);
            BitBuffer create32BitNegativeFloatByteBuffer = FloatDefinitionTest.create32BitNegativeFloatByteBuffer();
            this.fixture = this.parent.createDefinition(null, fieldName, create32BitNegativeFloatByteBuffer);
            Assert.assertNotNull((Object)this.fixture);
            Assert.assertEquals((String)("test" + i), (Object)"-2.0", (Object)this.fixture.toString());
            ++i;
        }
    }

    @Test
    public void testFloat64BitNeg() throws CTFException {
        int i = 1;
        while (i < 63) {
            this.parent = new FloatDeclaration(i, 64 - i, ByteOrder.nativeOrder(), 0L);
            BitBuffer floatBuffer = FloatDefinitionTest.create64BitNegativeFloatByteBuffer();
            this.fixture = this.parent.createDefinition(null, fieldName, floatBuffer);
            Assert.assertNotNull((Object)this.fixture);
            if (i <= 32) {
                Assert.assertEquals((String)("test" + i), (Object)"-2.0", (Object)this.fixture.toString());
            } else if (i == 33) {
                Assert.assertEquals((String)("test" + i), (Object)"-1.0", (Object)this.fixture.toString());
            } else {
                Assert.assertNotNull((Object)this.fixture.getValue());
            }
            ++i;
        }
    }

    @Test
    public void testFloat48Bit() throws CTFException {
        this.parent = new FloatDeclaration(12, 32, ByteOrder.nativeOrder(), 0L);
        this.fixture = this.parent.createDefinition(null, fieldName, FloatDefinitionTest.create64BitFloatByteBuffer());
        Assert.assertNotNull((Object)this.fixture);
        Assert.assertEquals((double)Double.NaN, (double)this.fixture.getValue(), (double)0.1);
    }

    @Test
    public void testGetDeclaration() {
        FloatDeclaration result = this.singleFixture.getDeclaration();
        Assert.assertNotNull((Object)result);
    }

    @Test
    public void testGetValue() {
        double result = this.singleFixture.getValue();
        Assert.assertEquals((double)2.0, (double)result, (double)0.1);
    }

    @Test
    public void testToString() {
        String result = this.singleFixture.toString();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)"2.0", (Object)result);
    }

    private static @NonNull BitBuffer create32BitFloatByteBuffer() {
        float[] data = new float[]{2.0f, 3.14f};
        ByteBuffer byb = ByteBuffer.allocate(128);
        byb.order(ByteOrder.nativeOrder());
        byb.mark();
        byb.putFloat(data[0]);
        byb.putFloat(data[1]);
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        return bb;
    }

    private static @NonNull BitBuffer create64BitFloatByteBuffer() {
        double[] data = new double[]{2.0, 3.14f};
        ByteBuffer byb = ByteBuffer.allocate(128);
        byb.order(ByteOrder.nativeOrder());
        byb.mark();
        byb.putDouble(data[0]);
        byb.putDouble(data[1]);
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        return bb;
    }

    private static @NonNull BitBuffer create32BitNegativeFloatByteBuffer() {
        float[] data = new float[]{-2.0f, -3.14f};
        ByteBuffer byb = ByteBuffer.allocate(128);
        byb.order(ByteOrder.nativeOrder());
        byb.mark();
        byb.putFloat(data[0]);
        byb.putFloat(data[1]);
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        return bb;
    }

    private static @NonNull BitBuffer create64BitNegativeFloatByteBuffer() {
        double[] data = new double[]{-2.0, -3.14f};
        ByteBuffer byb = ByteBuffer.allocate(128);
        byb.order(ByteOrder.nativeOrder());
        byb.mark();
        byb.putDouble(data[0]);
        byb.putDouble(data[1]);
        byb.reset();
        BitBuffer bb = new BitBuffer(byb);
        return bb;
    }
}

