/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.databinding.viewers.ViewerListProperty;
import org.eclipse.jface.internal.databinding.viewers.SelectionChangedListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class SelectionProviderMultipleSelectionProperty<S extends ISelectionProvider, E>
extends ViewerListProperty<S, E> {
    private final boolean isPostSelection;
    private final Object elementType;

    public SelectionProviderMultipleSelectionProperty(boolean isPostSelection, Object elementType) {
        this.isPostSelection = isPostSelection;
        this.elementType = elementType;
    }

    public SelectionProviderMultipleSelectionProperty(boolean isPostSelection) {
        this(isPostSelection, null);
    }

    public Object getElementType() {
        return this.elementType;
    }

    protected List<E> doGetList(ISelectionProvider source) {
        ISelection selection = source.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    protected void doSetList(S source, List<E> list, ListDiff<E> diff) {
        this.doSetList(source, list);
    }

    protected void doSetList(S source, List<E> list) {
        source.setSelection((ISelection)new StructuredSelection(list));
    }

    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ListDiff<E>> listener) {
        return new SelectionChangedListener<S, ListDiff<E>>((IProperty)this, listener, this.isPostSelection);
    }

    public String toString() {
        return this.isPostSelection ? "IPostSelectionProvider.postSelection[]" : "ISelectionProvider.selection[]";
    }
}

