/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TypeSpecifierListNameParser
implements ICommonTreeParser {
    public static final TypeSpecifierListNameParser INSTANCE = new TypeSpecifierListNameParser();

    private TypeSpecifierListNameParser() {
    }

    @Override
    public StringBuilder parse(ICTFMetadataNode typeSpecifier, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        StringBuilder sb = new StringBuilder();
        String type = typeSpecifier.getType();
        if (CTFParser.tokenNames[32].equals(type) || CTFParser.tokenNames[43].equals(type) || CTFParser.tokenNames[46].equals(type) || CTFParser.tokenNames[62].equals(type) || CTFParser.tokenNames[64].equals(type) || CTFParser.tokenNames[78].equals(type) || CTFParser.tokenNames[11].equals(type) || CTFParser.tokenNames[25].equals(type) || CTFParser.tokenNames[80].equals(type) || CTFParser.tokenNames[8].equals(type) || CTFParser.tokenNames[19].equals(type) || CTFParser.tokenNames[39].equals(type) || CTFParser.tokenNames[20].equals(type) || CTFParser.tokenNames[38].equals(type)) {
            TypeSpecifierListNameParser.parseSimple(typeSpecifier, sb);
        } else if (CTFParser.tokenNames[106].equals(type)) {
            TypeSpecifierListNameParser.parseStruct(typeSpecifier, sb);
        } else if (CTFParser.tokenNames[123].equals(type)) {
            TypeSpecifierListNameParser.parseVariant(typeSpecifier, sb);
        } else if (CTFParser.tokenNames[91].equals(type)) {
            TypeSpecifierListNameParser.parseEnum(typeSpecifier, sb);
        } else {
            if (CTFParser.tokenNames[100].equals(type) || CTFParser.tokenNames[101].equals(type) || CTFParser.tokenNames[105].equals(type)) {
                throw new ParseException("CTF type found in createTypeSpecifierString");
            }
            throw TsdlUtils.childTypeError(typeSpecifier);
        }
        return sb;
    }

    private static void parseEnum(ICTFMetadataNode typeSpecifier, StringBuilder sb) throws ParseException {
        ICTFMetadataNode enumName = typeSpecifier.getFirstChildWithType(CTFParser.tokenNames[95]);
        if (enumName == null) {
            throw new ParseException("nameless enum found in createTypeSpecifierString");
        }
        ICTFMetadataNode enumNameIdentifier = enumName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(enumNameIdentifier, sb);
    }

    private static void parseVariant(ICTFMetadataNode typeSpecifier, StringBuilder sb) throws ParseException {
        ICTFMetadataNode variantName = typeSpecifier.getFirstChildWithType(CTFParser.tokenNames[125]);
        if (variantName == null) {
            throw new ParseException("nameless variant found in createTypeSpecifierString");
        }
        ICTFMetadataNode variantNameIdentifier = variantName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(variantNameIdentifier, sb);
    }

    private static void parseSimple(ICTFMetadataNode typeSpecifier, StringBuilder sb) {
        sb.append(typeSpecifier.getText());
    }

    private static void parseStruct(ICTFMetadataNode typeSpecifier, StringBuilder sb) throws ParseException {
        ICTFMetadataNode structName = typeSpecifier.getFirstChildWithType(CTFParser.tokenNames[108]);
        if (structName == null) {
            throw new ParseException("nameless struct found in createTypeSpecifierString");
        }
        ICTFMetadataNode structNameIdentifier = structName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(structNameIdentifier, sb);
    }
}

