/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.ui.viewers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.table.ISortingLazyContentProvider;

class LamiTableContentProvider
implements ISortingLazyContentProvider {
    private @Nullable TableViewer fTableViewer = null;
    private List<LamiTableEntry> fCurrentEntries = Collections.emptyList();
    private @Nullable Comparator<LamiTableEntry> fComparator = null;
    private volatile boolean fOngoingUpdate = false;

    public void updateElement(int index) {
        TableViewer tableViewer = this.fTableViewer;
        List<LamiTableEntry> entries = this.fCurrentEntries;
        if (tableViewer != null && entries.size() > index && !this.fOngoingUpdate) {
            this.fOngoingUpdate = true;
            tableViewer.replace((Object)entries.get(index), index);
            this.fOngoingUpdate = false;
        }
    }

    public void dispose() {
        this.fCurrentEntries = Collections.emptyList();
        this.fTableViewer = null;
        this.fComparator = null;
    }

    public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        this.fTableViewer = (TableViewer)viewer;
        if (!(newInput instanceof List)) {
            return;
        }
        List entries = (List)newInput;
        this.fCurrentEntries = new ArrayList<LamiTableEntry>(entries);
        if (this.fComparator != null) {
            Collections.sort(this.fCurrentEntries, this.fComparator);
        }
    }

    public void setSortOrder(@Nullable Comparator<?> comparator) {
        if (comparator == null) {
            return;
        }
        TableViewer tableViewer = this.fTableViewer;
        if (tableViewer == null) {
            return;
        }
        Comparator<?> entryComparator = comparator;
        this.fComparator = entryComparator;
        Collections.sort(this.fCurrentEntries, this.fComparator);
        tableViewer.refresh();
    }

    public int getNbEntries() {
        return this.fCurrentEntries.size();
    }

    public int getIndexOf(LamiTableEntry entry) {
        return this.fCurrentEntries.indexOf(entry);
    }
}

