/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.graph.core.tests.graph;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.graph.core.base.IGraphWorker;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfGraph;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.analysis.graph.core.graph.WorkerSerializer;
import org.eclipse.tracecompass.analysis.graph.core.tests.graph.ITmfGraphTest;
import org.eclipse.tracecompass.analysis.graph.core.tests.stubs.TestGraphWorker;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.OsHistoryTreeGraph;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.legacy.OSEdgeContextState;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HistoryTreeGraphTest
extends ITmfGraphTest {
    private Path fGraphFile;
    private Path fGraphWorkerFiler;

    @Override
    @Before
    public void setup() throws IOException {
        this.fGraphFile = Files.createTempFile("tmpGraph", ".ht", new FileAttribute[0]);
        this.fGraphWorkerFiler = Files.createTempFile("tmpGraph", ".workers", new FileAttribute[0]);
        super.setup();
    }

    @Override
    protected ITmfGraph createNewGraph() {
        try {
            return new OsHistoryTreeGraph(this.fGraphFile, 1, (WorkerSerializer)new TestWorkerSerializer(), 0L);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    protected void deleteGraph(ITmfGraph graph) throws IOException {
        Files.deleteIfExists(this.fGraphFile);
        Files.deleteIfExists(this.fGraphWorkerFiler);
    }

    @Test
    public void testDefaultConstructor() {
        OsHistoryTreeGraph graph;
        try {
            graph = new OsHistoryTreeGraph(this.fGraphFile, 1, (WorkerSerializer)new TestWorkerSerializer(), 0L);
        }
        catch (IOException e) {
            graph = null;
            e.printStackTrace();
        }
        Assert.assertNotNull(graph);
        Iterator it = graph.getNodesOf(WORKER1);
        Assert.assertEquals((long)0L, (long)ImmutableList.copyOf((Iterator)it).size());
    }

    @Test
    public void testReReadGraph() {
        ITmfGraph graph = this.getGraph();
        ITmfVertex v0 = graph.createVertex(WORKER1, 0L);
        graph.add(v0);
        ITmfVertex v1 = graph.createVertex(WORKER1, 1L);
        ITmfEdge edge = graph.edge(v0, v1);
        ITmfVertex v2 = graph.createVertex(WORKER1, 2L);
        edge = graph.edge(v1, v2, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        ITmfVertex v3 = graph.createVertex(WORKER2, 3L);
        edge = graph.edge(v2, v3, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK));
        ITmfVertex v4 = graph.createVertex(WORKER3, 3L);
        edge = graph.edge(v3, v4, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.NETWORK), "test");
        graph.closeGraph(3L);
        graph = null;
        ITmfGraph reOpenedGraph = this.createNewGraph();
        Iterator it = reOpenedGraph.getNodesOf(WORKER1);
        Assert.assertEquals((long)3L, (long)ImmutableList.copyOf((Iterator)it).size());
        it = reOpenedGraph.getNodesOf(WORKER2);
        Assert.assertEquals((long)1L, (long)ImmutableList.copyOf((Iterator)it).size());
        it = reOpenedGraph.getNodesOf(WORKER3);
        Assert.assertEquals((long)1L, (long)ImmutableList.copyOf((Iterator)it).size());
        edge = reOpenedGraph.getEdgeFrom(v0, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.DEFAULT, (Object)edge.getEdgeContextState().getContextEnum());
        Assert.assertEquals((Object)v1, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
        Assert.assertEquals((long)(v1.getTimestamp() - v0.getTimestamp()), (long)edge.getDuration());
        edge = reOpenedGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v0, (Object)edge.getVertexFrom());
        edge = reOpenedGraph.getEdgeFrom(v2, ITmfGraph.EdgeDirection.INCOMING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v1, (Object)edge.getVertexFrom());
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.NETWORK, (Object)edge.getEdgeContextState().getContextEnum());
        edge = reOpenedGraph.getEdgeFrom(v1, ITmfGraph.EdgeDirection.OUTGOING_HORIZONTAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v2, (Object)edge.getVertexTo());
        edge = reOpenedGraph.getEdgeFrom(v2, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v3, (Object)edge.getVertexTo());
        Assert.assertEquals((Object)OSEdgeContextState.OSEdgeContextEnum.NETWORK, (Object)edge.getEdgeContextState().getContextEnum());
        edge = reOpenedGraph.getEdgeFrom(v3, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v2, (Object)edge.getVertexFrom());
        edge = reOpenedGraph.getEdgeFrom(v3, ITmfGraph.EdgeDirection.OUTGOING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v4, (Object)edge.getVertexTo());
        edge = reOpenedGraph.getEdgeFrom(v4, ITmfGraph.EdgeDirection.INCOMING_VERTICAL_EDGE);
        Assert.assertNotNull((Object)edge);
        Assert.assertEquals((Object)v3, (Object)edge.getVertexFrom());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIllegalVertex() {
        ITmfGraph graph = this.getGraph();
        ITmfVertex v0 = graph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = graph.createVertex(WORKER1, 1L);
        graph.add(v1);
        graph.add(v0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVertexNotInGraph() {
        ITmfGraph graph = this.getGraph();
        ITmfVertex v0 = graph.createVertex(WORKER1, 0L);
        ITmfVertex v1 = graph.createVertex(WORKER1, 1L);
        graph.add(v0);
        graph.add(v1);
        ITmfVertex v3 = graph.createVertex(WORKER2, 1L);
        ITmfVertex v4 = graph.createVertex(WORKER2, 2L);
        graph.add(v4);
        graph.edge(v3, v4, (ITmfEdgeContextState)new OSEdgeContextState(OSEdgeContextState.OSEdgeContextEnum.RUNNING));
    }

    private class TestWorkerSerializer
    implements WorkerSerializer {
        private TestWorkerSerializer() {
        }

        public @NonNull String serialize(@NonNull IGraphWorker worker) {
            return String.valueOf(((TestGraphWorker)worker).getValue());
        }

        public @NonNull IGraphWorker deserialize(@NonNull String serializedWorker) {
            return new TestGraphWorker(Integer.decode(serializedWorker));
        }
    }
}

