/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import com.google.common.collect.ImmutableList;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.AbstractSegmentStoreAnalysisModule;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreAnalysisModule;
import org.eclipse.tracecompass.analysis.timing.core.tests.stubs.segmentstore.StubSegmentStoreProvider;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filters.VirtualTableQueryFilter;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableDataProvider;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.TmfVirtualTableModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableCell;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.VirtualTableLine;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.BasicSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.ISegmentStore;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.TmfExperimentStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreTableDataProviderExperimentTest {
    private static ITmfVirtualTableDataProvider<@NonNull ITmfTreeDataModel, @NonNull VirtualTableLine> fMainDataProvider;
    private static ITmfVirtualTableDataProvider<@NonNull ITmfTreeDataModel, @NonNull VirtualTableLine> fDataProvider;
    private static ITmfVirtualTableDataProvider<@NonNull ITmfTreeDataModel, @NonNull VirtualTableLine> fInvalidDataProvider;
    private static final String START_TIME_COLUMN_NAME = "Start Time";
    private static final String END_TIME_COLUMN_NAME = "End Time";
    private static final String DURATION_COLUMN_NAME = "Duration";
    private static final String NS_TIME_COLUMN_NAME = "Timestamp ns";
    private static final String TRACE_COLUMN_NAME = "Trace";
    private static final String MAIN_TRACE_NAME = "main trace";
    private static final String SECOND_TRACE_NAME = "second trace";
    private static final String TABLE_SEARCH_EXPRESSION_KEY = "table_search_expressions";
    private static final String TABLE_SEARCH_DIRECTION_KEY = "table_search_direction";
    private static final String TABLE_COMPARATOR_EXPRESSION_KEY = "table_comparator_expression";
    private static final int BLOCK_SIZE = 5000;
    private static Map<String, Long> fColumns;
    private static Map<String, Long> fSingleTraceColumns;
    private static TmfExperimentStub fExperiment;
    private static TmfExperimentStub fSingleTraceExperiment;
    private static TmfExperimentStub fInvalidExperiment;
    private static TmfXmlTraceStubNs fMainTrace;
    private static TmfXmlTraceStubNs fSecondTrace;

    static {
        fColumns = Collections.emptyMap();
        fSingleTraceColumns = Collections.emptyMap();
    }

    @BeforeClass
    public static void init() throws TmfAnalysisException {
        fMainTrace = new TmfXmlTraceStubNs();
        fMainTrace.setName(MAIN_TRACE_NAME);
        StubSegmentStoreProvider simpleFixture = new StubSegmentStoreProvider();
        Assert.assertNotNull((Object)fMainTrace);
        simpleFixture.setTrace((ITmfTrace)fMainTrace);
        SecondStubSegmentStoreProvider secondSimpleFixture = new SecondStubSegmentStoreProvider();
        fSecondTrace = new TmfXmlTraceStubNs();
        fSecondTrace.setName(SECOND_TRACE_NAME);
        Assert.assertNotNull((Object)fSecondTrace);
        secondSimpleFixture.setTrace((ITmfTrace)fSecondTrace);
        fExperiment = SegmentStoreTableDataProviderExperimentTest.getValidExperiment();
        Assert.assertNotNull((Object)fExperiment);
        fMainDataProvider = SegmentStoreTableDataProviderExperimentTest.getDataProvider(fExperiment);
        fSingleTraceExperiment = SegmentStoreTableDataProviderExperimentTest.getSingleTraceExperiment();
        Assert.assertNotNull((Object)fSingleTraceExperiment);
        fDataProvider = SegmentStoreTableDataProviderExperimentTest.getDataProvider(fSingleTraceExperiment);
        fInvalidExperiment = SegmentStoreTableDataProviderExperimentTest.getInvalidExperiment();
        Assert.assertNotNull((Object)fInvalidExperiment);
        fInvalidDataProvider = SegmentStoreTableDataProviderExperimentTest.getDataProvider(fInvalidExperiment);
        fColumns = SegmentStoreTableDataProviderExperimentTest.fetchColumnId();
        fSingleTraceColumns = SegmentStoreTableDataProviderExperimentTest.fetchSingleTraceColumnId();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<String, Long> fetchColumnId() {
        @NonNull List columns = (List)fMainDataProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        if (columns == null) {
            return Collections.emptyMap();
        }
        Assert.assertEquals((Object)START_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(0)).getText());
        Assert.assertEquals((Object)END_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(1)).getText());
        Assert.assertEquals((Object)DURATION_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(2)).getText());
        Assert.assertEquals((Object)"Stub Column", (Object)((ITableColumnDescriptor)columns.get(3)).getText());
        Assert.assertEquals((Object)TRACE_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(4)).getText());
        Assert.assertEquals((Object)NS_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(5)).getText());
        LinkedHashMap<String, Long> expectedColumns = new LinkedHashMap<String, Long>();
        for (ITableColumnDescriptor column : columns) {
            expectedColumns.put(column.getText(), column.getId());
        }
        return expectedColumns;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static Map<String, Long> fetchSingleTraceColumnId() {
        @NonNull List columns = (List)fDataProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        if (columns == null) {
            return Collections.emptyMap();
        }
        Assert.assertEquals((Object)START_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(0)).getText());
        Assert.assertEquals((Object)END_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(1)).getText());
        Assert.assertEquals((Object)DURATION_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(2)).getText());
        Assert.assertEquals((Object)"Stub Column", (Object)((ITableColumnDescriptor)columns.get(3)).getText());
        Assert.assertEquals((Object)NS_TIME_COLUMN_NAME, (Object)((ITableColumnDescriptor)columns.get(4)).getText());
        LinkedHashMap<String, Long> expectedColumns = new LinkedHashMap<String, Long>();
        for (ITableColumnDescriptor column : columns) {
            expectedColumns.put(column.getText(), column.getId());
        }
        return expectedColumns;
    }

    private static ITmfVirtualTableDataProvider<@NonNull ITmfTreeDataModel, @NonNull VirtualTableLine> getDataProvider(@NonNull TmfExperimentStub experiment) throws TmfAnalysisException {
        SegmentStoreAnalysisModule m = new SegmentStoreAnalysisModule((ITmfTrace)experiment);
        try {
            experiment.addAnalysisModule((IAnalysisModule)m);
        }
        catch (TmfTraceException e) {
            throw new TmfAnalysisException(e.getMessage());
        }
        m.schedule();
        return new SegmentStoreTableDataProvider((ITmfTrace)experiment, (ISegmentStoreProvider)m, "");
    }

    private static TmfExperimentStub getSingleTraceExperiment() {
        ITmfTrace[] traces = new ITmfTrace[]{fMainTrace};
        return new TmfExperimentStub("", traces, 5000);
    }

    private static TmfExperimentStub getInvalidExperiment() {
        ITmfTrace[] traces = new ITmfTrace[]{};
        return new TmfExperimentStub("", traces, 5000);
    }

    private static TmfExperimentStub getValidExperiment() {
        ITmfTrace[] traces = new ITmfTrace[]{fMainTrace, fSecondTrace};
        return new TmfExperimentStub("", traces, 5000);
    }

    @AfterClass
    public static void tearDown() {
        fExperiment.dispose();
        fSingleTraceExperiment.dispose();
        fInvalidExperiment.dispose();
        if (fMainTrace != null) {
            fMainTrace.dispose();
        }
        if (fSecondTrace != null) {
            fSecondTrace.dispose();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testMainDataProviderFetchColumn() {
        Long startTimeColumnId = fColumns.get(START_TIME_COLUMN_NAME);
        Long endTimeColumnId = fColumns.get(END_TIME_COLUMN_NAME);
        Long durationColumnId = fColumns.get(DURATION_COLUMN_NAME);
        Long customColumnId = fColumns.get("Stub Column");
        Long traceColumnId = fColumns.get(TRACE_COLUMN_NAME);
        Long nsTimeColumnId = fColumns.get(NS_TIME_COLUMN_NAME);
        Assert.assertNotNull((Object)startTimeColumnId);
        Assert.assertNotNull((Object)endTimeColumnId);
        Assert.assertNotNull((Object)durationColumnId);
        Assert.assertNotNull((Object)customColumnId);
        Assert.assertNotNull((Object)traceColumnId);
        Assert.assertNotNull((Object)nsTimeColumnId);
        List<@NonNull ITableColumnDescriptor> expectedColumns = Arrays.asList(new TableColumnDescriptor.Builder().setId(startTimeColumnId.longValue()).setText(START_TIME_COLUMN_NAME).setTooltip("Start time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(endTimeColumnId.longValue()).setText(END_TIME_COLUMN_NAME).setTooltip("End time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(durationColumnId.longValue()).setText(DURATION_COLUMN_NAME).setTooltip("Segment duration").setDataType(DataType.DURATION).build(), new TableColumnDescriptor.Builder().setId(customColumnId.longValue()).setText("Stub Column").setTooltip("Stub segment column information").setDataType(DataType.STRING).build(), new TableColumnDescriptor.Builder().setId(traceColumnId.longValue()).setText(TRACE_COLUMN_NAME).setDataType(DataType.STRING).build(), new TableColumnDescriptor.Builder().setId(nsTimeColumnId.longValue()).setText(NS_TIME_COLUMN_NAME).setTooltip("Start time of the segment in nano seconds").setDataType(DataType.NUMBER).build());
        @NonNull List currentColumns = (List)fMainDataProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        Assert.assertNotNull((Object)currentColumns);
        Assert.assertEquals(expectedColumns, (Object)currentColumns);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testSingleTraceExperimentDataProviderFetchColumn() {
        Long startTimeColumnId = fSingleTraceColumns.get(START_TIME_COLUMN_NAME);
        Long endTimeColumnId = fSingleTraceColumns.get(END_TIME_COLUMN_NAME);
        Long durationColumnId = fSingleTraceColumns.get(DURATION_COLUMN_NAME);
        Long customColumnId = fSingleTraceColumns.get("Stub Column");
        Long nsTimeColumnId = fSingleTraceColumns.get(NS_TIME_COLUMN_NAME);
        Assert.assertNotNull((Object)startTimeColumnId);
        Assert.assertNotNull((Object)endTimeColumnId);
        Assert.assertNotNull((Object)durationColumnId);
        Assert.assertNotNull((Object)customColumnId);
        Assert.assertNotNull((Object)nsTimeColumnId);
        List<@NonNull ITableColumnDescriptor> expectedColumns = Arrays.asList(new TableColumnDescriptor.Builder().setId(startTimeColumnId.longValue()).setText(START_TIME_COLUMN_NAME).setTooltip("Start time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(endTimeColumnId.longValue()).setText(END_TIME_COLUMN_NAME).setTooltip("End time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(durationColumnId.longValue()).setText(DURATION_COLUMN_NAME).setTooltip("Segment duration").setDataType(DataType.DURATION).build(), new TableColumnDescriptor.Builder().setId(customColumnId.longValue()).setText("Stub Column").setTooltip("Stub segment column information").setDataType(DataType.STRING).build(), new TableColumnDescriptor.Builder().setId(nsTimeColumnId.longValue()).setText(NS_TIME_COLUMN_NAME).setTooltip("Start time of the segment in nano seconds").setDataType(DataType.NUMBER).build());
        @NonNull List currentColumns = (List)fDataProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        Assert.assertNotNull((Object)currentColumns);
        Assert.assertEquals(expectedColumns, (Object)currentColumns);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testInvalidExperimentDataProviderFetchColumn() {
        Long startTimeColumnId = fColumns.get(START_TIME_COLUMN_NAME);
        Long endTimeColumnId = fColumns.get(END_TIME_COLUMN_NAME);
        Long durationColumnId = fColumns.get(DURATION_COLUMN_NAME);
        Long nsTimeColumnId = fColumns.get(NS_TIME_COLUMN_NAME);
        Assert.assertNotNull((Object)startTimeColumnId);
        Assert.assertNotNull((Object)endTimeColumnId);
        Assert.assertNotNull((Object)durationColumnId);
        Assert.assertNotNull((Object)nsTimeColumnId);
        List<@NonNull ITableColumnDescriptor> expectedColumns = Arrays.asList(new TableColumnDescriptor.Builder().setId(startTimeColumnId.longValue()).setText(START_TIME_COLUMN_NAME).setTooltip("Start time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(endTimeColumnId.longValue()).setText(END_TIME_COLUMN_NAME).setTooltip("End time of the segment").setDataType(DataType.TIMESTAMP).build(), new TableColumnDescriptor.Builder().setId(durationColumnId.longValue()).setText(DURATION_COLUMN_NAME).setTooltip("Segment duration").setDataType(DataType.DURATION).build(), new TableColumnDescriptor.Builder().setId(nsTimeColumnId.longValue()).setText(NS_TIME_COLUMN_NAME).setTooltip("Start time of the segment in nano seconds").setDataType(DataType.NUMBER).build());
        @NonNull List currentColumns = (List)fInvalidDataProvider.fetchColumns(Collections.emptyMap(), null).getModel();
        Assert.assertNotNull((Object)currentColumns);
        Assert.assertEquals(expectedColumns, (Object)currentColumns);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesFromDataProviderWithExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 10);
        @NonNull List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(5L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(6L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(3L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(3L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(7L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(4L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(4L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(8L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(5L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(5L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(9L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(6L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(6L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))));
        @NonNull @NonNull TmfModelResponse response = fMainDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 66535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesFronmDataProviderWithEmptyExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull TmfModelResponse response = fInvalidDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNull((Object)currentModel);
        Assert.assertEquals((Object)response.getStatus(), (Object)ITmfResponse.Status.FAILED);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesFromDataProviderWithSingleTraceExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(new ArrayList<Long>(fSingleTraceColumns.values()), 0L, 10);
        @NonNull List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(3L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(3L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(4L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(4L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(5L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(5L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(5L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(6L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(6L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(6L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(7L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(7)))), new VirtualTableLine(8L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(8L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(7)))), new VirtualTableLine(9L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(9L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(String.valueOf(7)))));
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter), null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fSingleTraceColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesWithSearchOnAnExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderExperimentTest.lineTime(21L));
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "NEXT");
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(42L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(43L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(44L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(22L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(45L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(22L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(46L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(23L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))));
        expectedData.forEach(sl -> sl.setActiveProperties(8));
        @NonNull @NonNull TmfModelResponse response = fMainDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 42L, 66535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesWithTwoSearchFiltersOnAnExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderExperimentTest.lineTime(21L));
        searchMap.put(fColumns.get(TRACE_COLUMN_NAME), SECOND_TRACE_NAME);
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "NEXT");
        List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(43L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(45L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(22L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(47L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(23L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(46L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(22L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))), new VirtualTableLine(47L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(21L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(22L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(SECOND_TRACE_NAME), new VirtualTableCell(String.valueOf(21)))));
        expectedData.get(0).setActiveProperties(8);
        expectedData.get(1).setActiveProperties(8);
        expectedData.get(2).setActiveProperties(8);
        expectedData.get(4).setActiveProperties(8);
        @NonNull @NonNull TmfModelResponse response = fMainDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 43L, 66535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesWithTwoSearchFiltersOnASingleTraceExperiment() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 5);
        @NonNull @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        HashMap<Long, String> searchMap = new HashMap<Long, String>();
        searchMap.put(fColumns.get(START_TIME_COLUMN_NAME), SegmentStoreTableDataProviderExperimentTest.lineTime(21L));
        searchMap.put(fColumns.get(TRACE_COLUMN_NAME), SECOND_TRACE_NAME);
        fetchParameters.put(TABLE_SEARCH_EXPRESSION_KEY, searchMap);
        fetchParameters.put(TABLE_SEARCH_DIRECTION_KEY, "NEXT");
        List<@NonNull T> expectedData = Collections.emptyList();
        @NonNull @NonNull TmfModelResponse response = fDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fSingleTraceColumns.values()), expectedData, 0L, 65535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Test
    public void testFetchLinesWithTraceNameSorting() {
        VirtualTableQueryFilter queryFilter = new VirtualTableQueryFilter(Collections.emptyList(), 0L, 10);
        @NonNull @NonNull Map fetchParameters = FetchParametersUtils.virtualTableQueryToMap((VirtualTableQueryFilter)queryFilter);
        Long traceNameColumnID = fColumns.get(TRACE_COLUMN_NAME);
        Assert.assertNotNull((Object)traceNameColumnID);
        fetchParameters.put(TABLE_COMPARATOR_EXPRESSION_KEY, traceNameColumnID);
        @NonNull List<@NonNull VirtualTableLine> expectedData = Arrays.asList(new VirtualTableLine(0L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(1L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(1L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(2L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(2L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(3L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(3L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(3L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(4L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(4L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(4L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(5L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(5L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(5L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(6L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(0L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(6L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(6L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(0)))), new VirtualTableLine(7L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(0L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(7)))), new VirtualTableLine(8L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(8L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(1L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(7)))), new VirtualTableLine(9L, Arrays.asList(new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(7L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineTime(9L)), new VirtualTableCell(SegmentStoreTableDataProviderExperimentTest.lineDuration(2L)), new VirtualTableCell("Stub Content"), new VirtualTableCell(MAIN_TRACE_NAME), new VirtualTableCell(String.valueOf(7)))));
        @NonNull @NonNull TmfModelResponse response = fMainDataProvider.fetchLines(fetchParameters, null);
        @NonNull ITmfVirtualTableModel currentModel = (ITmfVirtualTableModel)response.getModel();
        Assert.assertNotNull((Object)currentModel);
        @NonNull TmfVirtualTableModel expectedModel = new TmfVirtualTableModel(new ArrayList<Long>(fColumns.values()), expectedData, 0L, 66535L);
        Assert.assertEquals((Object)expectedModel, (Object)currentModel);
    }

    private static String lineTime(long milliseconds) {
        return TmfTimestamp.fromNanos((long)milliseconds).toString();
    }

    private static String lineDuration(long duration) {
        return new DecimalFormat("###,###.##").format(duration);
    }

    private static class SecondStubSegmentStoreProvider
    extends AbstractSegmentStoreAnalysisModule {
        private static final int SIZE = 1000;
        private final List<@NonNull ISegment> fPreFixture;

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public SecondStubSegmentStoreProvider() {
            // Could not load outer class - annotation placement on inner may be incorrect
             @NonNull ImmutableList.Builder builder = new ImmutableList.Builder();
            int previousStartTime = 0;
            int i = 0;
            while (i < 1000) {
                if (i % 3 == 0) {
                    previousStartTime = i;
                }
                BasicSegment segment = new BasicSegment((long)previousStartTime, (long)i);
                builder.add((Object)segment);
                ++i;
            }
            this.fPreFixture = builder.build();
        }

        protected boolean buildAnalysisSegments(@NonNull ISegmentStore<@NonNull ISegment> segmentStore, @NonNull IProgressMonitor monitor) throws TmfAnalysisException {
            return segmentStore.addAll(this.fPreFixture);
        }

        protected void canceling() {
        }

        public boolean setTrace(@NonNull ITmfTrace trace) throws TmfAnalysisException {
            if (trace instanceof TmfXmlTraceStub) {
                TmfXmlTraceStub tmfXmlTraceStub = (TmfXmlTraceStub)trace;
                try {
                    tmfXmlTraceStub.addAnalysisModule((IAnalysisModule)this);
                }
                catch (TmfTraceException e) {
                    throw new TmfAnalysisException(e.getMessage());
                }
            }
            return super.setTrace(trace);
        }
    }
}

