/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests;

import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTreeItem;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.lttng2.control.ui.swtbot.tests.ControlViewTest;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.junit.Assert;
import org.junit.Test;

public class ControlViewLoggerTest
extends ControlViewTest {
    private static final String TEST_STREAM = "CreateSessionTestLTTng2_8.cfg";
    private static final String CREATE_SESSION_JUL_SCENARIO_NAME = "JulLogger";
    private static final String CREATE_SESSION_LOG4J_SCENARIO_NAME = "Log4jLogger";
    private static final String CREATE_SESSION_PYTHON_SCENARIO_NAME = "PythonLogger";
    private static final String SESSION_NAME = "mysession";
    private static final String PROPERTIES_VIEW = "Properties";
    private static final String LOGLEVEL_PROPERTY_NAME = "Log Level";

    @Override
    protected String getTestStream() {
        return TEST_STREAM;
    }

    @Override
    protected String getSessionName() {
        return SESSION_NAME;
    }

    @Override
    @Test
    public void testTraceSessionTree() {
        this.fProxy.setTestFile(this.fTestFile);
        this.fProxy.setScenario("Initialize");
        this.testConnectToNode();
        this.fProxy.setScenario(CREATE_SESSION_JUL_SCENARIO_NAME);
        this.testCreateSession();
        this.testEnableLoggers(TraceDomainType.JUL);
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testLoggerProperties(TraceDomainType.JUL);
        this.fProxy.setScenario(CREATE_SESSION_LOG4J_SCENARIO_NAME);
        this.testEnableLoggers(TraceDomainType.LOG4J);
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testLoggerProperties(TraceDomainType.LOG4J);
        this.fProxy.setScenario(CREATE_SESSION_PYTHON_SCENARIO_NAME);
        this.testEnableLoggers(TraceDomainType.PYTHON);
        this.testStartStopTracing(TraceSessionState.ACTIVE);
        this.testStartStopTracing(TraceSessionState.INACTIVE);
        this.testLoggerProperties(TraceDomainType.PYTHON);
        this.testDestroySession();
        this.testDisconnectFromNode();
    }

    protected void testEnableLoggers(TraceDomainType domain) {
        String domainName = new String();
        String logLevel = new String();
        switch (domain) {
            case JUL: {
                domainName = "JUL";
                logLevel = "Warning";
                break;
            }
            case LOG4J: {
                domainName = "LOG4J";
                logLevel = "Fatal";
                break;
            }
            case PYTHON: {
                domainName = "Python";
                logLevel = "Critical";
                break;
            }
        }
        SWTBotTreeItem sessionItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName()});
        sessionItem.select();
        SWTBotMenu menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        SWTBotShell shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup(domainName, "Domain").click();
        SWTBotTree loggersTree = shell.bot().treeInGroup("Loggers");
        SWTBotTreeItem treeItem = loggersTree.getTreeItem("All");
        treeItem.check();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)domainName, (SWTBotTreeItem)sessionItem));
        SWTBotTreeItem domainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName});
        Assert.assertEquals((Object)domainName, (Object)domainItem.getText());
        SWTBotTreeItem loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "*"});
        Assert.assertEquals((Object)"*", (Object)loggerItem.getText());
        sessionItem.select();
        menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup(domainName, "Domain").click();
        loggersTree = shell.bot().treeInGroup("Loggers");
        SWTBotTreeItem allItem = loggersTree.getTreeItem("All");
        allItem.expand();
        allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)loggersTree, (String[])new String[]{"All", "All - ./client_bin/challenger [PID=14237] (With logger)"});
        allItem.expand();
        treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)loggersTree, (String[])new String[]{"All", "All - ./client_bin/challenger [PID=14237] (With logger)", "logger"});
        treeItem.check();
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)domainName, (SWTBotTreeItem)sessionItem));
        domainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName});
        Assert.assertEquals((Object)domainName, (Object)domainItem.getText());
        loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "logger"});
        Assert.assertEquals((Object)"logger", (Object)loggerItem.getText());
        sessionItem.select();
        menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup(domainName, "Domain").click();
        loggersTree = shell.bot().treeInGroup("Loggers");
        allItem = loggersTree.getTreeItem("All");
        allItem.expand();
        allItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)loggersTree, (String[])new String[]{"All", "All - ./client_bin/challenger [PID=14237] (With logger)"});
        allItem.expand();
        treeItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)loggersTree, (String[])new String[]{"All", "All - ./client_bin/challenger [PID=14237] (With logger)", "anotherLogger"});
        treeItem.check();
        shell.bot().checkBoxInGroup(LOGLEVEL_PROPERTY_NAME).select();
        shell.bot().ccomboBoxInGroup(LOGLEVEL_PROPERTY_NAME).setSelection(logLevel);
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)domainName, (SWTBotTreeItem)sessionItem));
        domainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName});
        Assert.assertEquals((Object)domainName, (Object)domainItem.getText());
        loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "anotherLogger"});
        Assert.assertEquals((Object)"anotherLogger", (Object)loggerItem.getText());
        sessionItem.select();
        menuBot = sessionItem.contextMenu("Enable Event (default channel)...");
        menuBot.click();
        shell = fBot.shell("Enable Events").activate();
        shell.bot().radioInGroup(domainName, "Domain").click();
        loggersTree = shell.bot().treeInGroup("Loggers");
        shell.bot().textInGroup("Specific logger").setText("specificLogger1,specificLogger2");
        shell.bot().button("Ok").click();
        WaitUtils.waitForJobs();
        fBot.waitUntil(ConditionHelpers.isTreeChildNodeAvailable((String)domainName, (SWTBotTreeItem)sessionItem));
        domainItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName});
        Assert.assertEquals((Object)domainName, (Object)domainItem.getText());
        loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "specificLogger1"});
        Assert.assertEquals((Object)"specificLogger1", (Object)loggerItem.getText());
        loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "specificLogger2"});
        Assert.assertEquals((Object)"specificLogger2", (Object)loggerItem.getText());
    }

    protected void testLoggerProperties(TraceDomainType domain) {
        String domainName = new String();
        String logLevel = new String();
        switch (domain) {
            case JUL: {
                domainName = "JUL";
                logLevel = "<= Warning";
                break;
            }
            case LOG4J: {
                domainName = "LOG4J";
                logLevel = "<= Fatal";
                break;
            }
            case PYTHON: {
                domainName = "Python";
                logLevel = "<= Critical";
                break;
            }
        }
        SWTBotUtils.openView((String)"org.eclipse.ui.views.PropertySheet");
        fBot.viewById("org.eclipse.linuxtools.internal.lttng2.ui.views.control").show();
        SWTBotTreeItem loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "logger"});
        loggerItem.select();
        SWTBotView propertiesViewBot = fBot.viewByTitle(PROPERTIES_VIEW);
        propertiesViewBot.show();
        SWTBotTree propertiesViewTree = propertiesViewBot.bot().tree();
        SWTBotTreeItem loglevelTreeItem = propertiesViewTree.getTreeItem(LOGLEVEL_PROPERTY_NAME);
        String loglevelExpression = loglevelTreeItem.cell(1);
        Assert.assertEquals((Object)"All", (Object)loglevelExpression);
        fBot.viewById("org.eclipse.linuxtools.internal.lttng2.ui.views.control").show();
        loggerItem = SWTBotUtils.getTreeItem((SWTBot)fBot, (SWTBotTree)this.fTree, (String[])new String[]{this.getNodeName(), "Sessions", this.getSessionName(), domainName, "anotherLogger"});
        loggerItem.select();
        propertiesViewBot = fBot.viewByTitle(PROPERTIES_VIEW);
        propertiesViewBot.show();
        propertiesViewTree = propertiesViewBot.bot().tree();
        loglevelTreeItem = propertiesViewTree.getTreeItem(LOGLEVEL_PROPERTY_NAME);
        loglevelExpression = loglevelTreeItem.cell(1);
        Assert.assertEquals((Object)logLevel, (Object)loglevelExpression);
        SWTBotUtils.closeView((String)PROPERTIES_VIEW, (SWTWorkbenchBot)fBot);
    }
}

