/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.trace;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.common.core.trace.ILttngTrace;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.ContextVpidAspect;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.ContextVtidAspect;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.UstTracefAspect;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.DefaultUstEventLayout;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst20EventLayout;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst27EventLayout;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst28EventLayout;
import org.eclipse.tracecompass.internal.lttng2.ust.core.trace.layout.LttngUst29EventLayout;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoBinaryAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoFunctionAspect;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.debuginfo.UstDebugInfoSourceAspect;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstEventFactory;
import org.eclipse.tracecompass.lttng2.ust.core.trace.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;
import org.eclipse.tracecompass.tmf.core.trace.TmfEventTypeCollectionHelper;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfUtils;

public class LttngUstTrace
extends CtfTmfTrace
implements ILttngTrace {
    public static final String TRACER_NAME = "lttng-ust";
    private static final int CONFIDENCE = 100;
    private static final @NonNull Collection<ITmfEventAspect<?>> LTTNG_UST_ASPECTS;
    private @NonNull Collection<ITmfEventAspect<?>> fUstTraceAspects = ImmutableSet.copyOf(LTTNG_UST_ASPECTS);
    private @Nullable ILttngUstEventLayout fLayout = null;
    private @NonNull SymbolProviderConfig fCurrentProviderConfig = new SymbolProviderConfig(false, "");

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)CtfTmfTrace.CTF_ASPECTS);
        builder.add((Object)UstDebugInfoBinaryAspect.INSTANCE);
        builder.add((Object)UstDebugInfoFunctionAspect.INSTANCE);
        builder.add((Object)UstDebugInfoSourceAspect.INSTANCE);
        LTTNG_UST_ASPECTS = builder.build();
    }

    public LttngUstTrace() {
        super((CtfTmfEventFactory)LttngUstEventFactory.instance());
    }

    protected LttngUstTrace(@NonNull CtfTmfEventFactory factory) {
        super(factory);
    }

    public @NonNull ILttngUstEventLayout getEventLayout() {
        ILttngUstEventLayout layout = this.fLayout;
        if (layout == null) {
            throw new IllegalStateException("Cannot get the layout of a non-initialized trace!");
        }
        return layout;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        ILttngUstEventLayout layout;
        super.initTrace(resource, path, eventType);
        this.fLayout = layout = this.getLayoutFromEnv();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(LTTNG_UST_ASPECTS);
        if (this.checkFieldPresent(layout.contextVtid())) {
            builder.add((Object)new ContextVtidAspect(layout));
        }
        if (this.checkFieldPresent(layout.contextVpid())) {
            builder.add((Object)new ContextVpidAspect(layout));
        }
        if (this.getContainedEventTypes().stream().anyMatch(potentialEvent -> potentialEvent.getName().startsWith(layout.eventTracefPrefix()))) {
            builder.add(UstTracefAspect.getInstance());
        }
        builder.addAll((Iterable)this.createCounterAspects((ITmfTraceWithPreDefinedEvents)this));
        this.fUstTraceAspects = builder.build();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private boolean checkFieldPresent(@NonNull String field) {
        @NonNull @NonNull Multimap traceEvents = TmfEventTypeCollectionHelper.getEventFieldNames((Iterable)this.getContainedEventTypes());
        return traceEvents.containsValue((Object)field);
    }

    private @NonNull ILttngUstEventLayout getLayoutFromEnv() {
        String tracerName = CtfUtils.getTracerName((CtfTmfTrace)this);
        int tracerMajor = CtfUtils.getTracerMajorVersion((CtfTmfTrace)this);
        int tracerMinor = CtfUtils.getTracerMinorVersion((CtfTmfTrace)this);
        if (TRACER_NAME.equals(tracerName) && tracerMajor >= 2) {
            if (tracerMinor >= 9) {
                return LttngUst29EventLayout.getInstance();
            }
            if (tracerMinor >= 8) {
                return LttngUst28EventLayout.getInstance();
            }
            if (tracerMinor >= 7) {
                return LttngUst27EventLayout.getInstance();
            }
            return LttngUst20EventLayout.getInstance();
        }
        return DefaultUstEventLayout.getInstance();
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fUstTraceAspects;
    }

    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            CtfTraceValidationStatus ctfTraceValidationStatus = (CtfTraceValidationStatus)status;
            Map environment = ctfTraceValidationStatus.getEnvironment();
            String domain = (String)environment.get("domain");
            if (domain == null || !domain.equals("\"ust\"")) {
                return Status.error((String)Messages.LttngUstTrace_DomainError);
            }
            return new CtfTraceValidationStatus(100, "org.eclipse.tracecompass.lttng2.ust.core", environment, ctfTraceValidationStatus.getEventNames());
        }
        return status;
    }

    public @NonNull SymbolProviderConfig getSymbolProviderConfig() {
        return this.fCurrentProviderConfig;
    }

    public void setSymbolProviderConfig(@NonNull SymbolProviderConfig config) {
        this.fCurrentProviderConfig = config;
        UstDebugInfoBinaryAspect.invalidateSymbolCache();
    }

    public static class SymbolProviderConfig {
        private final boolean fUseCustomRootDir;
        private final @NonNull String fCustomRootDirPath;

        public SymbolProviderConfig(boolean useCustomRootDir, @NonNull String rootDirPath) {
            this.fUseCustomRootDir = useCustomRootDir;
            this.fCustomRootDirPath = rootDirPath;
        }

        public boolean useCustomRootDir() {
            return this.fUseCustomRootDir;
        }

        public String getCustomRootDirPath() {
            return this.fCustomRootDirPath;
        }

        public String getActualRootDirPath() {
            if (this.fUseCustomRootDir) {
                return this.fCustomRootDirPath;
            }
            return "";
        }
    }
}

