/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.control.core.tests.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.IBaseLoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.ITraceLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceJulLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceLog4jLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TracePythonLogLevel;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseLoggerInfo;
import org.eclipse.tracecompass.lttng2.control.core.tests.model.impl.ModelImplFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseLoggerInfoTest {
    private IBaseLoggerInfo fBaseLoggerInfo1 = null;
    private IBaseLoggerInfo fBaseLoggerInfo2 = null;

    @Before
    public void setUp() {
        ModelImplFactory factory = new ModelImplFactory();
        this.fBaseLoggerInfo1 = factory.getBaseLoggerInfo1();
        this.fBaseLoggerInfo2 = factory.getBaseLoggerInfo2();
    }

    @Test
    public void testBaseLoggerInfo() {
        BaseLoggerInfo fixture = new BaseLoggerInfo("logger");
        Assert.assertNotNull((Object)fixture);
        String name = fixture.getName();
        Assert.assertEquals((Object)"logger", (Object)name);
        TraceDomainType domain = fixture.getDomain();
        Assert.assertEquals((Object)"Unknown domain type", (Object)domain.getInName());
        Assert.assertEquals((Object)"UNKNOWN", (Object)domain.name());
        Assert.assertEquals((Object)"UNKNOWN", (Object)domain.toString());
        Assert.assertEquals((long)5L, (long)domain.ordinal());
        TraceJulLogLevel logLevel = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.name());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)logLevel.toString());
        Assert.assertEquals((long)9L, (long)logLevel.ordinal());
    }

    @Test
    public void testBaseLoggerInfoCopy() {
        BaseLoggerInfo fixture = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        Assert.assertEquals((Object)this.fBaseLoggerInfo1.getName(), (Object)fixture.getName());
        Assert.assertEquals((Object)this.fBaseLoggerInfo1.getDomain(), (Object)this.fBaseLoggerInfo1.getDomain());
        Assert.assertEquals((Object)this.fBaseLoggerInfo1.getLogLevel(), (Object)fixture.getLogLevel());
    }

    @Test
    public void testBaseLoggerInfoCopy2() {
        try {
            BaseLoggerInfo info = null;
            new BaseLoggerInfo(info);
            Assert.fail((String)"null copy");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSetLogLevel1() {
        BaseLoggerInfo fixture = new BaseLoggerInfo("logger");
        fixture.setLogLevel((ITraceLogLevel)TraceJulLogLevel.JUL_ALL);
        TraceJulLogLevel resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"All", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_ALL", (Object)resultJul.name());
        Assert.assertEquals((Object)"JUL_ALL", (Object)resultJul.toString());
        Assert.assertEquals((long)8L, (long)resultJul.ordinal());
        fixture.setLogLevel((ITraceLogLevel)TraceJulLogLevel.JUL_WARNING);
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Warning", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_WARNING", (Object)resultJul.name());
        Assert.assertEquals((Object)"JUL_WARNING", (Object)resultJul.toString());
        Assert.assertEquals((long)2L, (long)resultJul.ordinal());
        fixture.setDomain(TraceDomainType.LOG4J);
        fixture.setLogLevel((ITraceLogLevel)TraceLog4jLogLevel.LOG4J_ALL);
        TraceLog4jLogLevel resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"All", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_ALL", (Object)resultLog4j.name());
        Assert.assertEquals((Object)"LOG4J_ALL", (Object)resultLog4j.toString());
        Assert.assertEquals((long)7L, (long)resultLog4j.ordinal());
        fixture.setLogLevel((ITraceLogLevel)TraceLog4jLogLevel.LOG4J_FATAL);
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Fatal", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_FATAL", (Object)resultLog4j.name());
        Assert.assertEquals((Object)"LOG4J_FATAL", (Object)resultLog4j.toString());
        Assert.assertEquals((long)1L, (long)resultLog4j.ordinal());
        fixture.setDomain(TraceDomainType.PYTHON);
        fixture.setLogLevel((ITraceLogLevel)TracePythonLogLevel.PYTHON_NOTSET);
        TracePythonLogLevel resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Notset", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_NOTSET", (Object)resultPython.name());
        Assert.assertEquals((Object)"PYTHON_NOTSET", (Object)resultPython.toString());
        Assert.assertEquals((long)5L, (long)resultPython.ordinal());
        fixture.setLogLevel((ITraceLogLevel)TracePythonLogLevel.PYTHON_DEBUG);
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Debug", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_DEBUG", (Object)resultPython.name());
        Assert.assertEquals((Object)"PYTHON_DEBUG", (Object)resultPython.toString());
        Assert.assertEquals((long)4L, (long)resultPython.ordinal());
    }

    @Test
    public void testSetLogLevel2() {
        BaseLoggerInfo fixture = new BaseLoggerInfo("logger");
        fixture.setDomain(TraceDomainType.JUL);
        fixture.setLogLevel("Off");
        TraceJulLogLevel resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Off", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_OFF", (Object)resultJul.name());
        Assert.assertEquals((long)0L, (long)resultJul.ordinal());
        fixture.setLogLevel("Severe");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Severe", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_SEVERE", (Object)resultJul.name());
        Assert.assertEquals((long)1L, (long)resultJul.ordinal());
        fixture.setLogLevel("Warning");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Warning", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_WARNING", (Object)resultJul.name());
        Assert.assertEquals((long)2L, (long)resultJul.ordinal());
        fixture.setLogLevel("Info");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Info", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_INFO", (Object)resultJul.name());
        Assert.assertEquals((long)3L, (long)resultJul.ordinal());
        fixture.setLogLevel("Config");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Config", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_CONFIG", (Object)resultJul.name());
        Assert.assertEquals((long)4L, (long)resultJul.ordinal());
        fixture.setLogLevel("Fine");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Fine", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_FINE", (Object)resultJul.name());
        Assert.assertEquals((long)5L, (long)resultJul.ordinal());
        fixture.setLogLevel("Finer");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Finer", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_FINER", (Object)resultJul.name());
        Assert.assertEquals((long)6L, (long)resultJul.ordinal());
        fixture.setLogLevel("Finest");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"Finest", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_FINEST", (Object)resultJul.name());
        Assert.assertEquals((long)7L, (long)resultJul.ordinal());
        fixture.setLogLevel("All");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"All", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"JUL_ALL", (Object)resultJul.name());
        Assert.assertEquals((long)8L, (long)resultJul.ordinal());
        fixture.setLogLevel("LEVEL_UNKNOWN");
        resultJul = (TraceJulLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultJul);
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultJul.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultJul.name());
        Assert.assertEquals((long)9L, (long)resultJul.ordinal());
        fixture.setDomain(TraceDomainType.LOG4J);
        fixture.setLogLevel("Off");
        TraceLog4jLogLevel resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Off", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_OFF", (Object)resultLog4j.name());
        Assert.assertEquals((long)0L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Fatal");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Fatal", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_FATAL", (Object)resultLog4j.name());
        Assert.assertEquals((long)1L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Error");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Error", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_ERROR", (Object)resultLog4j.name());
        Assert.assertEquals((long)2L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Warn");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Warn", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_WARN", (Object)resultLog4j.name());
        Assert.assertEquals((long)3L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Info");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Info", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_INFO", (Object)resultLog4j.name());
        Assert.assertEquals((long)4L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Debug");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Debug", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_DEBUG", (Object)resultLog4j.name());
        Assert.assertEquals((long)5L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("Trace");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"Trace", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_TRACE", (Object)resultLog4j.name());
        Assert.assertEquals((long)6L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("All");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"All", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LOG4J_ALL", (Object)resultLog4j.name());
        Assert.assertEquals((long)7L, (long)resultLog4j.ordinal());
        fixture.setLogLevel("LEVEL_UNKNOWN");
        resultLog4j = (TraceLog4jLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultLog4j);
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultLog4j.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultLog4j.name());
        Assert.assertEquals((long)8L, (long)resultLog4j.ordinal());
        fixture.setDomain(TraceDomainType.PYTHON);
        fixture.setLogLevel("Critical");
        TracePythonLogLevel resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Critical", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_CRITICAL", (Object)resultPython.name());
        Assert.assertEquals((long)0L, (long)resultPython.ordinal());
        fixture.setLogLevel("Error");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Error", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_ERROR", (Object)resultPython.name());
        Assert.assertEquals((long)1L, (long)resultPython.ordinal());
        fixture.setLogLevel("Warning");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Warning", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_WARNING", (Object)resultPython.name());
        Assert.assertEquals((long)2L, (long)resultPython.ordinal());
        fixture.setLogLevel("Info");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Info", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_INFO", (Object)resultPython.name());
        Assert.assertEquals((long)3L, (long)resultPython.ordinal());
        fixture.setLogLevel("Debug");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Debug", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_DEBUG", (Object)resultPython.name());
        Assert.assertEquals((long)4L, (long)resultPython.ordinal());
        fixture.setLogLevel("Notset");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"Notset", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"PYTHON_NOTSET", (Object)resultPython.name());
        Assert.assertEquals((long)5L, (long)resultPython.ordinal());
        fixture.setLogLevel("LEVEL_UNKNOWN");
        resultPython = (TracePythonLogLevel)fixture.getLogLevel();
        Assert.assertNotNull((Object)resultPython);
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultPython.getInName());
        Assert.assertEquals((Object)"LEVEL_UNKNOWN", (Object)resultPython.name());
        Assert.assertEquals((long)6L, (long)resultPython.ordinal());
    }

    @Test
    public void testToString_1() {
        BaseLoggerInfo fixture = new BaseLoggerInfo("logger");
        fixture.setName("testName");
        fixture.setDomain(TraceDomainType.JUL);
        fixture.setLogLevel((ITraceLogLevel)TraceJulLogLevel.JUL_ALL);
        String result = fixture.toString();
        Assert.assertEquals((Object)"[BaseLoggerInfo([TraceInfo(Name=testName)],domain=JUL,level=JUL_ALL)]", (Object)result);
        fixture.setDomain(TraceDomainType.LOG4J);
        fixture.setLogLevel((ITraceLogLevel)TraceLog4jLogLevel.LOG4J_ERROR);
        result = fixture.toString();
        Assert.assertEquals((Object)"[BaseLoggerInfo([TraceInfo(Name=testName)],domain=LOG4J,level=LOG4J_ERROR)]", (Object)result);
        fixture.setDomain(TraceDomainType.PYTHON);
        fixture.setLogLevel((ITraceLogLevel)TracePythonLogLevel.PYTHON_CRITICAL);
        result = fixture.toString();
        Assert.assertEquals((Object)"[BaseLoggerInfo([TraceInfo(Name=testName)],domain=PYTHON,level=PYTHON_CRITICAL)]", (Object)result);
    }

    @Test
    public void testEqualsReflexivity() {
        Assert.assertTrue((String)"equals", (boolean)this.fBaseLoggerInfo1.equals(this.fBaseLoggerInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fBaseLoggerInfo2.equals(this.fBaseLoggerInfo2));
        Assert.assertTrue((String)"equals", (!this.fBaseLoggerInfo1.equals(this.fBaseLoggerInfo2) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fBaseLoggerInfo2.equals(this.fBaseLoggerInfo1) ? 1 : 0) != 0);
    }

    @Test
    public void testEqualsSymmetry() {
        BaseLoggerInfo info1 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        BaseLoggerInfo info2 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo2);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)this.fBaseLoggerInfo1));
        Assert.assertTrue((String)"equals", (boolean)this.fBaseLoggerInfo1.equals(info1));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)this.fBaseLoggerInfo2));
        Assert.assertTrue((String)"equals", (boolean)this.fBaseLoggerInfo2.equals(info2));
    }

    @Test
    public void testEqualsTransivity() {
        BaseLoggerInfo info1 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        BaseLoggerInfo info2 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        BaseLoggerInfo info3 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info2));
        Assert.assertTrue((String)"equals", (boolean)info2.equals((Object)info3));
        Assert.assertTrue((String)"equals", (boolean)info1.equals((Object)info3));
    }

    @Test
    public void testEqualsNull() {
        Assert.assertTrue((String)"equals", (!this.fBaseLoggerInfo1.equals(null) ? 1 : 0) != 0);
        Assert.assertTrue((String)"equals", (!this.fBaseLoggerInfo2.equals(null) ? 1 : 0) != 0);
    }

    @Test
    public void testHashCode() {
        BaseLoggerInfo info1 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo1);
        BaseLoggerInfo info2 = new BaseLoggerInfo((BaseLoggerInfo)this.fBaseLoggerInfo2);
        Assert.assertTrue((String)"hashCode", (this.fBaseLoggerInfo1.hashCode() == info1.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fBaseLoggerInfo2.hashCode() == info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fBaseLoggerInfo1.hashCode() != info2.hashCode() ? 1 : 0) != 0);
        Assert.assertTrue((String)"hashCode", (this.fBaseLoggerInfo2.hashCode() != info1.hashCode() ? 1 : 0) != 0);
    }
}

