/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.ui.internal.browser.WebBrowserViewDropAdapter;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class WebBrowserView
extends ViewPart
implements IBrowserViewerContainer,
ISetSelectionTarget {
    public static final String WEB_BROWSER_VIEW_ID = "org.eclipse.ui.browser.view";
    protected BrowserViewer viewer;
    protected ISelectionListener listener;

    public void createPartControl(Composite parent) {
        int style = WebBrowserUtil.decodeStyle(this.getViewSite().getSecondaryId());
        this.viewer = new BrowserViewer(parent, style);
        this.viewer.setContainer(this);
        this.initDragAndDrop();
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.setContainer(null);
        }
        if (this.listener != null) {
            this.removeSelectionListener();
        }
    }

    public void setURL(String url) {
        if (this.viewer != null) {
            this.viewer.setURL(url);
        }
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    @Override
    public boolean close() {
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    @Override
    public void openInExternalBrowser(String url) {
        try {
            URL theURL = new URL(url);
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            support.getExternalBrowser().openURL(theURL);
        }
        catch (MalformedURLException | PartInitException throwable) {
            // empty catch block
        }
    }

    public void addSelectionListener() {
        if (this.listener != null) {
            return;
        }
        this.listener = (part, selection) -> this.onSelectionChange(selection);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.listener);
    }

    /*
     * WARNING - void declaration
     */
    private void onSelectionChange(ISelection selection) {
        void sel;
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
        Object obj = sel.getFirstElement();
        URL url = this.getURLFrom(obj);
        if (url != null) {
            this.setURL(url.toExternalForm());
        }
    }

    private URL getURLFrom(Object adapt) {
        File file;
        IPath path = (IPath)Adapters.adapt((Object)adapt, IPath.class);
        if (path != null && (file = path.toFile()).exists() && this.isWebFile(file.getName())) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return (URL)Adapters.adapt((Object)adapt, URL.class);
    }

    public void removeSelectionListener() {
        if (this.listener == null) {
            return;
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.listener);
        this.listener = null;
    }

    protected boolean isWebFile(String name) {
        return name.endsWith("html") || name.endsWith("htm") || name.endsWith("gif") || name.endsWith("jpg");
    }

    protected void initDragAndDrop() {
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)this.viewer, 17);
        dropTarget.setTransfer(transfers);
        dropTarget.addDropListener((DropTargetListener)new WebBrowserViewDropAdapter(this.viewer));
    }

    public void selectReveal(ISelection selection) {
        this.onSelectionChange(selection);
    }

    public void setBrowserViewName(String name) {
        this.setPartName(name);
    }

    public void setBrowserViewTooltip(String tip) {
        this.setTitleToolTip(tip);
    }
}

