/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uomo.ucum.parsers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.eclipse.uomo.core.UOMoException;
import org.eclipse.uomo.ucum.internal.Messages;
import org.eclipse.uomo.ucum.model.BaseUnit;
import org.eclipse.uomo.ucum.model.ConceptKind;
import org.eclipse.uomo.ucum.model.DefinedUnit;
import org.eclipse.uomo.ucum.model.Prefix;
import org.eclipse.uomo.ucum.model.UcumModel;
import org.eclipse.uomo.ucum.model.Value;
import org.eclipse.uomo.util.Parser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DefinitionParser
implements Parser<String, UcumModel> {
    public UcumModel parse(String filename) throws UOMoException {
        try {
            return this.parse(new FileInputStream(new File(filename)));
        }
        catch (XmlPullParserException x) {
            throw new UOMoException((Throwable)x);
        }
        catch (ParseException p) {
            throw new UOMoException((Throwable)p);
        }
        catch (IOException i) {
            throw new UOMoException((Throwable)i);
        }
    }

    public UcumModel parse(InputStream stream) throws XmlPullParserException, IOException, ParseException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser xpp = factory.newPullParser();
        xpp.setInput(stream, null);
        int eventType = xpp.next();
        if (eventType != 2) {
            throw new XmlPullParserException(Messages.DefinitionParser_0);
        }
        if (!xpp.getName().equals("root")) {
            throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_2) + xpp.getName() + Messages.DefinitionParser_3);
        }
        SimpleDateFormat fmt = new SimpleDateFormat(Messages.DefinitionParser_DateFormat);
        Date date = fmt.parse(xpp.getAttributeValue(null, "revision-date").substring(7, 32));
        UcumModel root = new UcumModel(xpp.getAttributeValue(null, "version"), xpp.getAttributeValue(null, "revision"), date);
        xpp.next();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                if (StringUtils.isWhitespace((String)xpp.getText())) {
                    xpp.next();
                    continue;
                }
                throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_8) + xpp.getText());
            }
            if (xpp.getName().equals(ConceptKind.PREFIX.visibleName())) {
                root.getPrefixes().add(this.parsePrefix(xpp));
                continue;
            }
            if (xpp.getName().equals(ConceptKind.BASEUNIT.visibleName())) {
                root.getBaseUnits().add(this.parseBaseUnit(xpp));
                continue;
            }
            if (xpp.getName().equals(ConceptKind.UNIT.visibleName())) {
                root.getDefinedUnits().add(this.parseUnit(xpp));
                continue;
            }
            throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_9) + xpp.getName());
        }
        return root;
    }

    private DefinedUnit parseUnit(XmlPullParser xpp) throws XmlPullParserException, IOException {
        DefinedUnit unit = new DefinedUnit(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        unit.setMetric("yes".equals(xpp.getAttributeValue(null, "isMetric")));
        unit.setSpecial("yes".equals(xpp.getAttributeValue(null, "isSpecial")));
        unit.setClass_(xpp.getAttributeValue(null, "class"));
        xpp.next();
        this.skipWhitespace(xpp);
        while (xpp.getEventType() == 2 && "name".equals(xpp.getName())) {
            unit.getNames().add(this.readElement(xpp, "name", String.valueOf(ConceptKind.UNIT.visibleName()) + " " + unit.getCode(), false));
        }
        if (xpp.getEventType() == 2 && "printSymbol".equals(xpp.getName())) {
            unit.setPrintSymbol(this.readElement(xpp, "printSymbol", String.valueOf(ConceptKind.UNIT.visibleName()) + " " + unit.getCode(), true));
        }
        unit.setProperty(this.readElement(xpp, "property", String.valueOf(ConceptKind.UNIT.visibleName()) + " " + unit.getCode(), false));
        unit.setValue(this.parseValue(xpp, "unit " + unit.getCode()));
        xpp.next();
        this.skipWhitespace(xpp);
        return unit;
    }

    private Value<?> parseValue(XmlPullParser xpp, String context) throws XmlPullParserException, IOException {
        this.checkAtElement(xpp, "value", context);
        BigDecimal val = null;
        if (xpp.getAttributeValue(null, "value") != null) {
            try {
                val = new BigDecimal(xpp.getAttributeValue(null, "value"));
            }
            catch (NumberFormatException e) {
                throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_29) + context + Messages.DefinitionParser_30 + e.getMessage());
            }
        }
        Value value = new Value(xpp.getAttributeValue(null, "Unit"), xpp.getAttributeValue(null, "UNIT"), val);
        value.setString(this.readElement(xpp, "value", context, true));
        return value;
    }

    private BaseUnit parseBaseUnit(XmlPullParser xpp) throws XmlPullParserException, IOException {
        BaseUnit base = new BaseUnit(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        base.setDim(xpp.getAttributeValue(null, "dim").charAt(0));
        xpp.next();
        this.skipWhitespace(xpp);
        base.getNames().add(this.readElement(xpp, "name", String.valueOf(ConceptKind.BASEUNIT.visibleName()) + " " + base.getCode(), false));
        base.setPrintSymbol(this.readElement(xpp, "printSymbol", String.valueOf(ConceptKind.BASEUNIT.visibleName()) + " " + base.getCode(), false));
        base.setProperty(this.readElement(xpp, "property", String.valueOf(ConceptKind.BASEUNIT.visibleName()) + " " + base.getCode(), false));
        xpp.next();
        this.skipWhitespace(xpp);
        return base;
    }

    private Prefix parsePrefix(XmlPullParser xpp) throws XmlPullParserException, IOException {
        Prefix prefix = new Prefix(xpp.getAttributeValue(null, "Code"), xpp.getAttributeValue(null, "CODE"));
        xpp.next();
        this.skipWhitespace(xpp);
        prefix.getNames().add(this.readElement(xpp, "name", String.valueOf(ConceptKind.PREFIX.visibleName()) + " " + prefix.getCode(), false));
        prefix.setPrintSymbol(this.readElement(xpp, "printSymbol", String.valueOf(ConceptKind.PREFIX.visibleName()) + " " + prefix.getCode(), false));
        this.checkAtElement(xpp, "value", String.valueOf(ConceptKind.PREFIX.visibleName()) + " " + prefix.getCode());
        prefix.setValue(new BigDecimal(xpp.getAttributeValue(null, "value")));
        this.readElement(xpp, "value", String.valueOf(ConceptKind.PREFIX.visibleName()) + " " + prefix.getCode(), true);
        xpp.next();
        this.skipWhitespace(xpp);
        return prefix;
    }

    private String readElement(XmlPullParser xpp, String name, String context, boolean complex) throws XmlPullParserException, IOException {
        this.checkAtElement(xpp, name, context);
        xpp.next();
        this.skipWhitespace(xpp);
        String val = null;
        if (complex) {
            val = this.readText(xpp);
        } else if (xpp.getEventType() == 4) {
            val = xpp.getText();
            xpp.next();
            this.skipWhitespace(xpp);
        }
        if (xpp.getEventType() != 3) {
            throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_54) + context);
        }
        xpp.next();
        this.skipWhitespace(xpp);
        return val;
    }

    private String readText(XmlPullParser xpp) throws XmlPullParserException, IOException {
        StringBuilder bldr = new StringBuilder();
        while (xpp.getEventType() != 3) {
            if (xpp.getEventType() == 4) {
                bldr.append(xpp.getText());
                xpp.next();
                continue;
            }
            xpp.next();
            bldr.append(this.readText(xpp));
            xpp.next();
            this.skipWhitespace(xpp);
        }
        return bldr.toString();
    }

    private void skipWhitespace(XmlPullParser xpp) throws XmlPullParserException, IOException {
        while (xpp.getEventType() == 4 && StringUtils.isWhitespace((String)xpp.getText())) {
            xpp.next();
        }
    }

    private void checkAtElement(XmlPullParser xpp, String name, String context) throws XmlPullParserException {
        if (xpp.getEventType() != 2) {
            throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_55) + name + Messages.DefinitionParser_56 + Integer.toString(xpp.getEventType()) + Messages.DefinitionParser_57 + context);
        }
        if (!xpp.getName().equals(name)) {
            throw new XmlPullParserException(String.valueOf(Messages.DefinitionParser_58) + name + Messages.DefinitionParser_59 + xpp.getName() + Messages.DefinitionParser_60 + context);
        }
    }
}

