/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.ClassButtonDialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogField;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldBase;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.DialogFieldGroup;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.common.ui.internal.dialogfield.LayoutUtil;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.KeyClassType;
import org.eclipse.jst.jsf.facesconfig.emf.KeyType;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntriesType;
import org.eclipse.jst.jsf.facesconfig.emf.MapEntryType;
import org.eclipse.jst.jsf.facesconfig.emf.NullValueType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValueType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditMapEntryDialog;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.IDialogFieldGroup;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class MapEntriesEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup,
ISelectionProvider,
ISelectionChangedListener {
    private ClassButtonDialogField keyClassField;
    private ClassButtonDialogField valueClassField;
    private TableViewer tableViewer;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private IProject currentProject;
    private Button removeButton;
    private Button editButton;
    private ManagedBeanType managedBean;
    private AbstractFacesConfigSection section;
    private List selectionChangedListeners = new ArrayList();

    public MapEntriesEditGroup(AbstractFacesConfigSection section) {
        this.section = section;
    }

    public void initialize() {
    }

    private void updateButtons() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData data = new GridData(1808);
        parent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.layoutMapTypeSelectionSection(toolkit, parent);
        this.createAndLayoutMapValueSection(toolkit, parent);
    }

    private void layoutMapTypeSelectionSection(FormToolkit toolkit, Composite container) {
        Composite typeSelectionSection = null;
        if (toolkit != null) {
            typeSelectionSection = toolkit.createComposite(container);
            toolkit.paintBordersFor(typeSelectionSection);
        } else {
            typeSelectionSection = SWTUtils.createComposite((Composite)container, (int)0);
        }
        GridData gd = new GridData(768);
        typeSelectionSection.setLayoutData((Object)gd);
        int numberOfColumns = 4;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        typeSelectionSection.setLayout((Layout)gl);
        this.keyClassField = new ClassButtonDialogField(this.getProject());
        this.keyClassField.setLabelText(EditorMessages.InitializationSection_MapType_KeyClass);
        this.keyClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command cmd;
                boolean isNew;
                ManagedBeanType managedBean1 = (ManagedBeanType)MapEntriesEditGroup.this.getInput();
                String className = ((ClassButtonDialogField)field).getText();
                KeyClassType keyClass = FacesConfigFactory.eINSTANCE.createKeyClassType();
                keyClass.setTextContent(className);
                EditingDomain editingDomain = MapEntriesEditGroup.this.section.getEditingDomain();
                if (managedBean1.getMapEntries() == null) {
                    isNew = true;
                    MapEntriesType mapEntries = FacesConfigFactory.eINSTANCE.createMapEntriesType();
                    mapEntries.setKeyClass(keyClass);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)managedBean1, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_MapEntries(), (Object)mapEntries);
                } else {
                    isNew = false;
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)managedBean1.getMapEntries(), (Object)FacesConfigPackage.eINSTANCE.getMapEntriesType_KeyClass(), (Object)keyClass);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                    if (isNew) {
                        MapEntriesEditGroup.this.refreshAll();
                    }
                }
            }
        });
        this.valueClassField = new ClassButtonDialogField(this.getProject());
        this.valueClassField.setLabelText(EditorMessages.InitializationSection_MapType_ValueClass);
        this.valueClassField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                Command cmd;
                boolean isNew;
                ManagedBeanType managedBean1 = (ManagedBeanType)MapEntriesEditGroup.this.getInput();
                String className = ((ClassButtonDialogField)field).getText();
                ValueClassType valueClass = FacesConfigFactory.eINSTANCE.createValueClassType();
                valueClass.setTextContent(className);
                EditingDomain editingDomain = MapEntriesEditGroup.this.section.getEditingDomain();
                if (managedBean1.getMapEntries() == null) {
                    isNew = true;
                    MapEntriesType mapEntries = FacesConfigFactory.eINSTANCE.createMapEntriesType();
                    mapEntries.setValueClass(valueClass);
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)managedBean1, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_MapEntries(), (Object)mapEntries);
                } else {
                    isNew = false;
                    cmd = SetCommand.create((EditingDomain)editingDomain, (Object)managedBean1.getMapEntries(), (Object)FacesConfigPackage.eINSTANCE.getMapEntriesType_ValueClass(), (Object)valueClass);
                }
                if (cmd.canExecute()) {
                    editingDomain.getCommandStack().execute(cmd);
                    if (isNew) {
                        MapEntriesEditGroup.this.refreshAll();
                    }
                }
            }
        });
        this.keyClassField.doFillIntoGrid(toolkit, typeSelectionSection, numberOfColumns);
        LayoutUtil.setHorizontalGrabbing((Control)this.keyClassField.getTextControl(toolkit, container));
        this.valueClassField.doFillIntoGrid(toolkit, typeSelectionSection, numberOfColumns);
    }

    private void createAndLayoutMapValueSection(FormToolkit toolkit, Composite parent) {
        Composite mapValueSection = null;
        if (toolkit != null) {
            mapValueSection = toolkit.createComposite(parent);
            toolkit.paintBordersFor(mapValueSection);
        } else {
            mapValueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        }
        GridData gd = new GridData(1808);
        mapValueSection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        mapValueSection.setLayout((Layout)gl);
        DialogFieldBase valuesTitle = new DialogFieldBase();
        valuesTitle.setLabelText(EditorMessages.InitializationSection_MapTable_Title);
        valuesTitle.doFillIntoGrid(toolkit, mapValueSection, numberOfColumns);
        Table table = toolkit == null ? new Table(mapValueSection, 68352) : new Table(mapValueSection, 68352);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.updateButtons();
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn keyCol = new TableColumn(table, 0);
        keyCol.setText(EditorMessages.InitializationSection_MapTable_Key);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        keyCol.setResizable(true);
        TableColumn valueCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        valueCol.setText(EditorMessages.InitializationSection_MapTable_Value);
        valueCol.setResizable(true);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)MapEntriesEditGroup.this.tableViewer.getSelection()).size() > 0) {
                    MapEntriesEditGroup.this.editButtonSelected();
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.section.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.section.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getMapEntryType().isInstance(element);
            }
        });
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite operationContainer = null;
        operationContainer = toolkit != null ? toolkit.createComposite(mapValueSection) : SWTUtils.createComposite((Composite)mapValueSection, (int)0);
        gd = new GridData(1040);
        operationContainer.setLayoutData((Object)gd);
        gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = null;
        addButton = toolkit != null ? toolkit.createButton(operationContainer, EditorMessages.UI_Button_Add_more, 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Add_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        this.editButton = toolkit != null ? toolkit.createButton(operationContainer, EditorMessages.UI_Button_Edit_more, 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Edit_more);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit != null ? toolkit.createButton(operationContainer, EditorMessages.UI_Button_Remove, 8) : SWTUtils.createPushButton((Composite)operationContainer, (String)EditorMessages.UI_Button_Remove);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.addButtonSelected();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.editButtonSelected();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapEntriesEditGroup.this.removeButtonSelected();
            }
        });
    }

    private void addButtonSelected() {
        AddEditMapEntryDialog dialog = new AddEditMapEntryDialog(EditorPlugin.getActiveShell(), true);
        if (dialog.open() == 0) {
            Command command;
            MapEntryType mapEntry = FacesConfigFactory.eINSTANCE.createMapEntryType();
            if (dialog.getKey() != null) {
                KeyType key = FacesConfigFactory.eINSTANCE.createKeyType();
                key.setTextContent(dialog.getKey());
                mapEntry.setKey(key);
            }
            if (dialog.isNullValue()) {
                NullValueType nullValue = FacesConfigFactory.eINSTANCE.createNullValueType();
                mapEntry.setNullValue(nullValue);
            } else {
                ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                value.setTextContent(dialog.getValue());
                mapEntry.setValue(value);
            }
            EditingDomain editingDomain = this.section.getEditingDomain();
            boolean isNewMapEntries = false;
            if (this.managedBean.getMapEntries() == null) {
                MapEntriesType mapEntriesType = FacesConfigFactory.eINSTANCE.createMapEntriesType();
                mapEntriesType.getMapEntry().add((Object)mapEntry);
                command = SetCommand.create((EditingDomain)editingDomain, (Object)this.managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_MapEntries(), (Object)mapEntriesType);
                isNewMapEntries = true;
            } else {
                MapEntriesType mapEntries = this.managedBean.getMapEntries();
                command = AddCommand.create((EditingDomain)editingDomain, (Object)mapEntries, (Object)FacesConfigPackage.eINSTANCE.getMapEntriesType_MapEntry(), (Object)mapEntry);
            }
            if (command.canExecute()) {
                editingDomain.getCommandStack().execute(command);
                if (isNewMapEntries) {
                    this.refreshAll();
                }
            }
        }
    }

    private void editButtonSelected() {
        if (this.tableViewer.getSelection() == null || ((IStructuredSelection)this.tableViewer.getSelection()).isEmpty()) {
            return;
        }
        MapEntryType mapEntry = (MapEntryType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        AddEditMapEntryDialog dialog = new AddEditMapEntryDialog(EditorPlugin.getActiveShell(), false);
        if (mapEntry.getKey() != null) {
            dialog.setKey(mapEntry.getKey().getTextContent());
        }
        if (mapEntry.getNullValue() != null) {
            dialog.setNullValue(true);
        } else if (mapEntry.getValue() != null) {
            dialog.setValue(mapEntry.getValue().getTextContent());
        }
        if (dialog.open() == 0) {
            EditingDomain editingDomain = this.section.getEditingDomain();
            ArrayList<Command> commands = new ArrayList<Command>();
            if (mapEntry.getKey() != null) {
                Command cmd1 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry.getKey(), (Object)FacesConfigPackage.eINSTANCE.getKeyType_TextContent(), (Object)dialog.getKey());
                commands.add(cmd1);
            } else {
                KeyType keyType = FacesConfigFactory.eINSTANCE.createKeyType();
                keyType.setTextContent(dialog.getKey());
                Command cmd2 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry, (Object)FacesConfigPackage.eINSTANCE.getMapEntryType_Key(), (Object)keyType);
                commands.add(cmd2);
            }
            if (dialog.isNullValue()) {
                if (mapEntry.getValue() != null) {
                    Command cmd3 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry, (Object)FacesConfigPackage.eINSTANCE.getMapEntryType_Value(), (Object)SetCommand.UNSET_VALUE);
                    commands.add(cmd3);
                }
                Command cmd4 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry, (Object)FacesConfigPackage.eINSTANCE.getMapEntryType_NullValue(), (Object)FacesConfigFactory.eINSTANCE.createNullValueType());
                commands.add(cmd4);
            } else {
                if (mapEntry.getNullValue() != null) {
                    Command cmd5 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry, (Object)FacesConfigPackage.eINSTANCE.getMapEntryType_NullValue(), (Object)SetCommand.UNSET_VALUE);
                    commands.add(cmd5);
                }
                if (mapEntry.getValue() != null) {
                    Command cmd6 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry.getValue(), (Object)FacesConfigPackage.eINSTANCE.getValueType_TextContent(), (Object)dialog.getValue());
                    commands.add(cmd6);
                } else {
                    ValueType value = FacesConfigFactory.eINSTANCE.createValueType();
                    value.setTextContent(dialog.getValue());
                    Command cmd7 = SetCommand.create((EditingDomain)editingDomain, (Object)mapEntry, (Object)FacesConfigPackage.eINSTANCE.getMapEntryType_Value(), (Object)value);
                    commands.add(cmd7);
                }
            }
            CompoundCommand command = new CompoundCommand(commands);
            if (command.canExecute()) {
                editingDomain.getCommandStack().execute((Command)command);
                this.tableViewer.refresh((Object)mapEntry);
            }
        }
    }

    private void removeButtonSelected() {
        MapEntryType mapEntry = (MapEntryType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        EditingDomain editingDomain = this.section.getEditingDomain();
        Command cmd = RemoveCommand.create((EditingDomain)editingDomain, (Object)mapEntry);
        if (cmd.canExecute()) {
            editingDomain.getCommandStack().execute(cmd);
            this.refresh();
        }
    }

    private IProject getProject() {
        if (this.currentProject == null) {
            this.currentProject = (IProject)this.section.getPage().getEditor().getAdapter(IProject.class);
        }
        return this.currentProject;
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof ManagedBeanType) {
            this.managedBean = (ManagedBeanType)newInput;
            if (this.managedBean.getMapEntries() != null) {
                this.refreshAll();
            }
        }
    }

    void refreshAll() {
        if (this.managedBean.getMapEntries() != null && this.managedBean.getMapEntries().getKeyClass() != null) {
            this.keyClassField.setTextWithoutUpdate(this.managedBean.getMapEntries().getKeyClass().getTextContent());
        } else {
            this.keyClassField.setTextWithoutUpdate(null);
        }
        if (this.managedBean.getMapEntries() != null && this.managedBean.getMapEntries().getValueClass() != null) {
            this.valueClassField.setTextWithoutUpdate(this.managedBean.getMapEntries().getValueClass().getTextContent());
        } else {
            this.valueClassField.setTextWithoutUpdate(null);
        }
        this.tableViewer.setInput((Object)((ManagedBeanType)this.getInput()).getMapEntries());
        this.updateButtons();
    }

    public Object getInput() {
        return this.managedBean;
    }

    public void refreshData() {
        this.refresh();
    }

    public void refresh() {
        this.tableViewer.refresh();
        this.updateButtons();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, event.getSelection()));
        }
    }
}

