/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.ui.internal.style;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.json.ui.internal.ColorTypesHelper;
import org.eclipse.wst.json.ui.internal.JSONUIPlugin;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.provisional.style.AbstractLineStyleProvider;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;

public class LineStyleProviderForJSON
extends AbstractLineStyleProvider
implements LineStyleProvider {
    protected TextAttribute getAttributeFor(ITextRegion region) {
        String type;
        if (region != null && (type = region.getType()) != null) {
            return this.getAttributeFor(type);
        }
        return (TextAttribute)this.getTextAttributes().get("NORMAL");
    }

    protected TextAttribute getAttributeFor(String type) {
        return (TextAttribute)this.getTextAttributes().get(ColorTypesHelper.getColor(type));
    }

    protected void handlePropertyChange(PropertyChangeEvent event) {
        String styleKey = ColorTypesHelper.getNewStyle(event);
        if (event != null) {
            String prefKey = event.getProperty();
            if ("COLON".equals(prefKey)) {
                styleKey = "COLON";
            } else if ("COMMA".equals(prefKey)) {
                styleKey = "COMMA";
            } else if ("CURLY_BRACE".equals(prefKey)) {
                styleKey = "CURLY_BRACE";
            } else if ("NORMAL".equals(prefKey)) {
                styleKey = "NORMAL";
            } else if ("OBJECT_KEY".equals(prefKey)) {
                styleKey = "OBJECT_KEY";
            } else if ("VALUE_BOOLEAN".equals(prefKey)) {
                styleKey = "VALUE_BOOLEAN";
            } else if ("VALUE_NULL".equals(prefKey)) {
                styleKey = "VALUE_NULL";
            } else if ("VALUE_NUMBER".equals(prefKey)) {
                styleKey = "VALUE_NUMBER";
            } else if ("VALUE_STRING".equals(prefKey)) {
                styleKey = "VALUE_STRING";
            } else if ("COMMENT".equals(prefKey)) {
                styleKey = "COMMENT";
            }
        }
        if (styleKey != null) {
            this.addTextAttribute(styleKey);
            super.handlePropertyChange(event);
        }
    }

    public void release() {
        super.release();
    }

    public void loadColors() {
        this.addTextAttribute("NORMAL");
        this.addTextAttribute("CURLY_BRACE");
        this.addTextAttribute("COLON");
        this.addTextAttribute("COMMA");
        this.addTextAttribute("COMMENT");
        this.addTextAttribute("OBJECT_KEY");
        this.addTextAttribute("VALUE_STRING");
        this.addTextAttribute("VALUE_NUMBER");
        this.addTextAttribute("VALUE_BOOLEAN");
        this.addTextAttribute("VALUE_NULL");
    }

    protected IPreferenceStore getColorPreferences() {
        return JSONUIPlugin.getDefault().getPreferenceStore();
    }
}

