/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class BasicModel
implements Model {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private String fName;
    private Hashtable fElements;
    private Element fRoot;
    private int fUniqueNumberCounter;

    public BasicModel(String name) {
        this.fName = name;
        this.fElements = new Hashtable();
        this.fRoot = null;
        this.fUniqueNumberCounter = 0;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public int getUniqueNumber() {
        ++this.fUniqueNumberCounter;
        return this.fUniqueNumberCounter;
    }

    public String makeMUID(String name) {
        String num = String.valueOf(this.getUniqueNumber());
        String muid = String.valueOf(name) + num;
        return muid;
    }

    public boolean setRootElement(Element root) {
        if (root.getModel() == null) {
            this.addElement(root);
        } else if (root.getModel() != this) {
            return false;
        }
        this.fRoot = root;
        return true;
    }

    public Element getRootElement() {
        if (this.fRoot == null) {
            this.fRoot = this.getFirstElement();
        }
        return this.fRoot;
    }

    public Vector getElementsByName(String name) {
        Vector<Element> vector = new Vector<Element>();
        Enumeration e = this.fElements.keys();
        while (e.hasMoreElements()) {
            Element element = (Element)e.nextElement();
            if (!element.getName().equals(name)) continue;
            vector.addElement(element);
        }
        return vector;
    }

    public boolean addElement(Element element) {
        if (element.getModel() != null) {
            return false;
        }
        this.fElements.put(element, element);
        return true;
    }

    public boolean removeElement(Element element) {
        if (element.getModel() != this) {
            return false;
        }
        element.disconnectAll();
        if (this.fRoot == element) {
            this.fRoot = null;
        }
        return this.fElements.remove(element) == element;
    }

    public Enumeration getElements() {
        return this.fElements.elements();
    }

    public int getNumberOfElements() {
        return this.fElements.size();
    }

    public boolean containsElement(Element element) {
        return this.fElements.contains(element);
    }

    private Element getFirstElement() {
        Enumeration e = this.getElements();
        return e.hasMoreElements() ? (Element)e.nextElement() : null;
    }

    public String toString() {
        return this.getName();
    }
}

