/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.commands;

import javax.xml.namespace.QName;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.ui.internal.actions.SmartRenameAction;
import org.eclipse.wst.wsdl.ui.internal.commands.AddPartCommand;
import org.eclipse.wst.wsdl.ui.internal.commands.WSDLElementCommand;
import org.eclipse.wst.wsdl.ui.internal.util.NameUtil;

public final class AddMessageCommand
extends WSDLElementCommand {
    private Definition definition;
    private String localName;
    private Message message;
    private Message originalMessage;
    private boolean createPart = false;
    private final String DEFAULT_PART_NAME = "NewPart";

    public AddMessageCommand(Definition definition, String localName) {
        this.definition = definition;
        this.localName = localName;
    }

    public AddMessageCommand(Definition definition, String localName, boolean createPart) {
        this.definition = definition;
        this.localName = localName;
        this.createPart = createPart;
    }

    public AddMessageCommand(Definition definition, Message originalMessage, String localName, boolean copyPart) {
        this.definition = definition;
        this.localName = localName;
        this.createPart = copyPart;
        this.originalMessage = originalMessage;
    }

    @Override
    public void run() {
        this.message = WSDLFactory.eINSTANCE.createMessage();
        this.message.setQName(new QName(this.definition.getTargetNamespace(), this.localName));
        this.message.setEnclosingDefinition(this.definition);
        this.definition.addMessage((javax.wsdl.Message)this.message);
        if (this.originalMessage == null) {
            if (this.createPart) {
                AddPartCommand command = new AddPartCommand(this.message, "NewPart", "http://www.w3.org/2001/XMLSchema", "string", true);
                command.run();
            }
        } else if (this.originalMessage.getEParts() != null) {
            for (Part part : this.originalMessage.getEParts()) {
                AddPartCommand command = SmartRenameAction.isPartNameGenerated(part.getName(), this.originalMessage.getQName().getLocalPart()) ? new AddPartCommand(this.message, part, NameUtil.buildUniquePartName(this.message, this.message.getQName().getLocalPart())) : new AddPartCommand(this.message, part, part.getName());
                command.run();
            }
        }
    }

    public void setLocalName(String name) {
        this.localName = name;
    }

    @Override
    public WSDLElement getWSDLElement() {
        return this.message;
    }
}

