/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.nio.charset.Charset;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.CharArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.tests.internal.AbstractStringToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.TestTools;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.junit.Assert;

public class CharArrayToolsTests
extends AbstractStringToolsTests {
    public CharArrayToolsTests(String name) {
        super(name);
    }

    @Override
    protected String CR() {
        return String.valueOf(CharArrayTools.CR);
    }

    @Override
    protected void verifyReverse(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.reverse((char[])string.toCharArray()));
    }

    @Override
    protected void verifyLast(char expected, String string) {
        CharArrayToolsTests.assertEquals((char)expected, (char)CharArrayTools.last((char[])string.toCharArray()));
    }

    @Override
    protected void verifyConcatenate(String expected, String[] array) {
        TestTools.assertEquals(expected, CharArrayTools.concatenate((char[][])this.convert(array)));
        Iterable iterable = IterableTools.transform((Iterable)IterableTools.iterable((Object[])array), (Transformer)StringTools.CHAR_ARRAY_TRANSFORMER);
        TestTools.assertEquals(expected, CharArrayTools.concatenate((Iterable)iterable));
        TestTools.assertEquals(expected, CharArrayTools.concatenate(iterable.iterator()));
    }

    private char[][] convert(String[] stringArray) {
        char[][] array = new char[stringArray.length][];
        int i = 0;
        while (i < array.length) {
            array[i] = stringArray[i].toCharArray();
            ++i;
        }
        return array;
    }

    @Override
    protected void verifyConcatenate(String expected, String[] array, String delim) {
        TestTools.assertEquals(expected, CharArrayTools.concatenate((char[][])this.convert(array), (char[])delim.toCharArray()));
        Iterable iterable = IterableTools.transform((Iterable)IterableTools.iterable((Object[])array), (Transformer)StringTools.CHAR_ARRAY_TRANSFORMER);
        TestTools.assertEquals(expected, CharArrayTools.concatenate((Iterable)iterable, (char[])delim.toCharArray()));
        TestTools.assertEquals(expected, CharArrayTools.concatenate(iterable.iterator(), (char[])delim.toCharArray()));
    }

    @Override
    protected void verifyCenter(String expected, String string, int len) {
        TestTools.assertEquals(expected, CharArrayTools.center((char[])string.toCharArray(), (int)len));
    }

    @Override
    protected void verifyPad(String expected, String string, int len) {
        TestTools.assertEquals(expected, CharArrayTools.pad((char[])string.toCharArray(), (int)len));
    }

    @Override
    protected void verifyFit(String expected, String string, int len) {
        TestTools.assertEquals(expected, CharArrayTools.fit((char[])string.toCharArray(), (int)len));
    }

    @Override
    protected void verifyZeroPad(String expected, String string, int len) {
        TestTools.assertEquals(expected, CharArrayTools.zeroPad((char[])string.toCharArray(), (int)len));
    }

    @Override
    protected void verifyZeroFit(String expected, String string, int len) {
        TestTools.assertEquals(expected, CharArrayTools.zeroFit((char[])string.toCharArray(), (int)len));
    }

    @Override
    protected void verifyRepeat(String expected, String string, int length) {
        TestTools.assertEquals(expected, CharArrayTools.repeat((char[])string.toCharArray(), (int)length));
    }

    @Override
    protected void verifySeparate(String expected, String string, char separator, int segmentLength) {
        TestTools.assertEquals(expected, CharArrayTools.separate((char[])string.toCharArray(), (char)separator, (int)segmentLength));
    }

    @Override
    protected void verifyQuote(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.quote((char[])string.toCharArray()));
    }

    @Override
    protected void verifyCharDelimiter(String expected, String string, char delimiter) {
        Transformer<char[], char[]> transformer = this.buildCharDelimiter(delimiter);
        TestTools.assertEquals(expected, (char[])transformer.transform((Object)string.toCharArray()));
    }

    protected Transformer<char[], char[]> buildCharDelimiter(char delimiter) {
        return new CharArrayTools.CharDelimiter(delimiter);
    }

    @Override
    protected void verifyDelimit(String expected, String string, String delimiter) {
        TestTools.assertEquals(expected, CharArrayTools.delimit((char[])string.toCharArray(), (char[])delimiter.toCharArray()));
    }

    @Override
    protected void verifyStringDelimiter(String expected, String string, String delimiter) {
        Transformer<char[], char[]> transformer = this.buildStringDelimiter(delimiter);
        TestTools.assertEquals(expected, (char[])transformer.transform((Object)string.toCharArray()));
    }

    protected Transformer<char[], char[]> buildStringDelimiter(String delimiter) {
        return new CharArrayTools.CharArrayDelimiter(delimiter.toCharArray());
    }

    @Override
    protected void verifyRemoveFirstOccurrence(String expected, String string, char charToRemove) {
        TestTools.assertEquals(expected, CharArrayTools.removeFirstOccurrence((char[])string.toCharArray(), (char)charToRemove));
    }

    @Override
    protected void verifyRemoveAllOccurrences(String expected, String string, char charToRemove) {
        TestTools.assertEquals(expected, CharArrayTools.removeAllOccurrences((char[])string.toCharArray(), (char)charToRemove));
    }

    @Override
    protected void verifyRemoveAllSpaces(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.removeAllSpaces((char[])string.toCharArray()));
    }

    @Override
    protected void verifyRemoveAllWhitespace(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.removeAllWhitespace((char[])string.toCharArray()));
    }

    @Override
    protected void verifyCompressWhitespace(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.compressWhitespace((char[])string.toCharArray()));
    }

    @Override
    protected void verifyCommonPrefixLength(int expected, String string1, String string2) {
        CharArrayToolsTests.assertEquals((int)expected, (int)CharArrayTools.commonPrefixLength((char[])string1.toCharArray(), (char[])string2.toCharArray()));
    }

    @Override
    protected void verifyCommonPrefixLengthMax(int expected, String string1, String string2, int max) {
        CharArrayToolsTests.assertEquals((int)expected, (int)CharArrayTools.commonPrefixLength((char[])string1.toCharArray(), (char[])string2.toCharArray(), (int)max));
    }

    @Override
    protected void verifyCapitalize(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.capitalize((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.CAPITALIZER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getCapitalizer() {
        return CharArrayTools.CAPITALIZER;
    }

    @Override
    protected void verifyUncapitalize(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.uncapitalize((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.UNCAPITALIZER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getUncapitalizer() {
        return CharArrayTools.UNCAPITALIZER;
    }

    @Override
    protected void verifyIsBlank(boolean expected, String string) {
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.isBlank((char[])this.convert(string)));
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.IS_BLANK.evaluate((Object)this.convert(string)));
    }

    @Override
    protected Object getIsBlankPredicate() {
        return CharArrayTools.IS_BLANK;
    }

    @Override
    protected void verifyIsNotBlank(boolean expected, String string) {
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.isNotBlank((char[])this.convert(string)));
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.IS_NOT_BLANK.evaluate((Object)this.convert(string)));
    }

    @Override
    protected Object getIsNotBlankPredicate() {
        return CharArrayTools.IS_NOT_BLANK;
    }

    @Override
    protected void verifyEqualsIgnoreCase(boolean expected, String string1, String string2) {
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.equalsIgnoreCase((char[])this.convert(string1), (char[])this.convert(string2)));
    }

    private char[] convert(String string) {
        return string == null ? null : string.toCharArray();
    }

    @Override
    protected void verifyStartsWithIgnoreCase(boolean expected, String string, String prefix) {
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)CharArrayTools.startsWithIgnoreCase((char[])string.toCharArray(), (char[])prefix.toCharArray()));
        CharArrayTools.StartsWithIgnoreCase predicate = new CharArrayTools.StartsWithIgnoreCase(prefix.toCharArray());
        CharArrayToolsTests.assertEquals((boolean)expected, (boolean)predicate.evaluate((Object)string.toCharArray()));
    }

    @Override
    protected void verifyIsUppercase(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isUppercase((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsUppercase(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isUppercase((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsLowercase(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isLowercase((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsLowercase(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isLowercase((char[])string.toCharArray()));
    }

    @Override
    protected byte[] convertHexStringToByteArray(String string) {
        return CharArrayTools.convertHexStringToByteArray((char[])string.toCharArray());
    }

    @Override
    protected void verifyConvertCamelCaseToAllCaps(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertCamelCaseToAllCaps((char[])string.toCharArray()));
    }

    @Override
    protected void verifyConvertCamelCaseToAllCapsMaxLength(String expected, String string, int max) {
        TestTools.assertEquals(expected, CharArrayTools.convertCamelCaseToAllCaps((char[])string.toCharArray(), (int)max));
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertAllCapsToCamelCase((char[])string.toCharArray()));
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string, boolean capFirst) {
        TestTools.assertEquals(expected, CharArrayTools.convertAllCapsToCamelCase((char[])string.toCharArray(), (boolean)capFirst));
    }

    @Override
    protected void verifyIsQuoted(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isQuoted((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsQuoted(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isQuoted((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsParenthetical(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isParenthetical((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsParenthetical(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isParenthetical((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsBracketed(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBracketed((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsBracketed(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isBracketed((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsBraced(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isBraced((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsBraced(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isBraced((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsChevroned(String string) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isChevroned((char[])string.toCharArray()));
    }

    @Override
    protected void denyIsChevroned(String string) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isChevroned((char[])string.toCharArray()));
    }

    @Override
    protected void verifyIsDelimited(String string, char c) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isDelimited((char[])string.toCharArray(), (char)c));
    }

    @Override
    protected void denyIsDelimited(String string, char c) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isDelimited((char[])string.toCharArray(), (char)c));
    }

    @Override
    protected void verifyIsDelimited2(String string, char start, char end) {
        CharArrayToolsTests.assertTrue((boolean)CharArrayTools.isDelimited((char[])string.toCharArray(), (char)start, (char)end));
    }

    @Override
    protected void denyIsDelimited2(String string, char start, char end) {
        CharArrayToolsTests.assertFalse((boolean)CharArrayTools.isDelimited((char[])string.toCharArray(), (char)start, (char)end));
    }

    @Override
    protected void verifyUndelimit(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.undelimit((char[])string.toCharArray()));
    }

    @Override
    protected void verifyUndelimitInt(String expected, String string, int count) {
        TestTools.assertEquals(expected, CharArrayTools.undelimit((char[])string.toCharArray(), (int)count));
    }

    @Override
    protected void verifyConvertToJavaStringLiteral(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToJavaStringLiteral((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.JAVA_STRING_LITERAL_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getJavaStringLiteralTransformer() {
        return CharArrayTools.JAVA_STRING_LITERAL_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToJavaStringLiteralContent(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToJavaStringLiteralContent((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getJavaStringLiteralContentTransformer() {
        return CharArrayTools.JAVA_STRING_LITERAL_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlAttributeValue(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlAttributeValue((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getXmlAttributeValueTransformer() {
        return CharArrayTools.XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValue(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToDoubleQuotedXmlAttributeValue((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getDoubleQuotedXmlAttributeValueTransformer() {
        return CharArrayTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValueContent(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToDoubleQuotedXmlAttributeValueContent((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getDoubleQuotedXmlAttributeValueContentTransformer() {
        return CharArrayTools.DOUBLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValue(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToSingleQuotedXmlAttributeValue((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getSingleQuotedXmlAttributeValueTransformer() {
        return CharArrayTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValueContent(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToSingleQuotedXmlAttributeValueContent((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getSingleQuotedXmlAttributeValueContentTransformer() {
        return CharArrayTools.SINGLE_QUOTED_XML_ATTRIBUTE_VALUE_CONTENT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementText(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlElementText((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.XML_ELEMENT_TEXT_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getXmlElementTextTransformer() {
        return CharArrayTools.XML_ELEMENT_TEXT_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementCDATA(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlElementCDATA((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.XML_ELEMENT_CDATA_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getXmlElementCDATATransformer() {
        return CharArrayTools.XML_ELEMENT_CDATA_TRANSFORMER;
    }

    @Override
    protected void verifyConvertToXmlElementCDATAContent(String expected, String string) {
        TestTools.assertEquals(expected, CharArrayTools.convertToXmlElementCDATAContent((char[])string.toCharArray()));
        TestTools.assertEquals(expected, (char[])CharArrayTools.XML_ELEMENT_CDATA_CONTENT_TRANSFORMER.transform((Object)string.toCharArray()));
    }

    @Override
    protected Object getXmlElementCDATAContentTransformer() {
        return CharArrayTools.XML_ELEMENT_CDATA_CONTENT_TRANSFORMER;
    }

    @Override
    protected Class<?> getToolsClass() {
        return CharArrayTools.class;
    }

    public void testStringTransformer() throws Exception {
        Transformer transformer = CharArrayTools.STRING_TRANSFORMER;
        CharArrayToolsTests.assertEquals((String)"foo", (String)((String)transformer.transform((Object)"foo".toCharArray())));
        CharArrayToolsTests.assertEquals((String)"StringTransformer", (String)transformer.toString());
        CharArrayToolsTests.assertSame((Object)transformer, (Object)TestTools.serialize(transformer));
    }

    public void testCodePointAtInt() {
        this.verifyCodePointAtInt("foo-bar-baz", 7);
        this.verifyCodePointAtInt("caf\u00e9", 3);
    }

    private void verifyCodePointAtInt(String s, int index) {
        CharArrayToolsTests.assertEquals((int)s.codePointAt(index), (int)CharArrayTools.codePointAt((char[])s.toCharArray(), (int)index));
    }

    public void testCodePointBeforeInt() {
        this.verifyCodePointBeforeInt("foo-bar-baz", 7);
        this.verifyCodePointBeforeInt("caf\u00e9", 4);
    }

    private void verifyCodePointBeforeInt(String s, int index) {
        CharArrayToolsTests.assertEquals((int)s.codePointBefore(index), (int)CharArrayTools.codePointBefore((char[])s.toCharArray(), (int)index));
    }

    public void testCodePointCountIntInt() {
        this.verifyCodePointCountIntInt("foo-bar-baz");
        this.verifyCodePointCountIntInt("caf\u00e9");
    }

    private void verifyCodePointCountIntInt(String s) {
        CharArrayToolsTests.assertEquals((int)s.codePointCount(0, s.length()), (int)CharArrayTools.codePointCount((char[])s.toCharArray(), (int)0, (int)s.length()));
    }

    public void testCompareTo() {
        this.verifyCompareTo("foo", "bar");
        this.verifyCompareTo("foo", "foo");
        this.verifyCompareTo("foo", "zoo");
    }

    private void verifyCompareTo(String s1, String s2) {
        CharArrayToolsTests.assertEquals((int)s1.compareTo(s2), (int)CharArrayTools.compareTo((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testCompareToIgnoreCase() {
        this.verifyCompareToIgnoreCase("foo", "bar");
        this.verifyCompareToIgnoreCase("foo", "BAR");
        this.verifyCompareToIgnoreCase("foo", "foo");
        this.verifyCompareToIgnoreCase("foo", "FOO");
        this.verifyCompareToIgnoreCase("foo", "zoo");
        this.verifyCompareToIgnoreCase("foo", "ZOO");
        this.verifyCompareToIgnoreCase("foo", "fooo");
        this.verifyCompareToIgnoreCase("fooo", "foo");
    }

    private void verifyCompareToIgnoreCase(String s1, String s2) {
        CharArrayToolsTests.assertEquals((int)s1.compareToIgnoreCase(s2), (int)CharArrayTools.compareToIgnoreCase((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testConcat() {
        this.verifyConcat("foo", "bar");
        this.verifyConcat("foo", "foo");
        this.verifyConcat("foo", "zoo");
        this.verifyConcat("foo", "");
        this.verifyConcat("", "zoo");
    }

    private void verifyConcat(String s1, String s2) {
        TestTools.assertEquals(s1.concat(s2), CharArrayTools.concat((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testContainsCharSequence() {
        this.verifyContainsCharSequence("foo", "bar");
        this.verifyContainsCharSequence("foo", "foo");
        this.verifyContainsCharSequence("foo", "zoo");
        this.verifyContainsCharSequence("foo", "");
        this.verifyContainsCharSequence("", "zoo");
        this.verifyContainsCharSequence("foo", "f");
        this.verifyContainsCharSequence("foo", "o");
        this.verifyContainsCharSequence("foo", "z");
        this.verifyContainsCharSequence("foo", "oo");
    }

    private void verifyContainsCharSequence(String s1, String s2) {
        StringBuilder sb = new StringBuilder(s2);
        CharArrayToolsTests.assertEquals((boolean)s1.contains(sb), (boolean)CharArrayTools.contains((char[])s1.toCharArray(), (CharSequence)sb));
    }

    public void testContainsCharArray() {
        this.verifyContainsCharArray("foo", "bar");
        this.verifyContainsCharArray("foo", "foo");
        this.verifyContainsCharArray("foo", "zoo");
        this.verifyContainsCharArray("foo", "");
        this.verifyContainsCharArray("", "zoo");
        this.verifyContainsCharArray("foo", "f");
        this.verifyContainsCharArray("foo", "o");
        this.verifyContainsCharArray("foo", "z");
        this.verifyContainsCharArray("foo", "oo");
    }

    private void verifyContainsCharArray(String s1, String s2) {
        StringBuilder sb = new StringBuilder(s2);
        CharArrayToolsTests.assertEquals((boolean)s1.contains(sb), (boolean)CharArrayTools.contains((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testContentEqualsCharSequence() {
        this.verifyContentEqualsCharSequence("foo", "bar");
        this.verifyContentEqualsCharSequence("foo", "foo");
        this.verifyContentEqualsCharSequence("foo", "zoo");
        this.verifyContentEqualsCharSequence("foo", "");
        this.verifyContentEqualsCharSequence("", "zoo");
        this.verifyContentEqualsCharSequence("foo", "f");
        this.verifyContentEqualsCharSequence("foo", "o");
        this.verifyContentEqualsCharSequence("foo", "z");
        this.verifyContentEqualsCharSequence("foo", "oo");
    }

    private void verifyContentEqualsCharSequence(String s1, String s2) {
        StringBuilder sb = new StringBuilder(s2);
        CharArrayToolsTests.assertEquals((boolean)s1.contentEquals(sb), (boolean)CharArrayTools.contentEquals((char[])s1.toCharArray(), (CharSequence)sb));
    }

    public void testContentEqualsStringBuffer() {
        this.verifyContentEqualsStringBuffer("foo", "bar");
        this.verifyContentEqualsStringBuffer("foo", "foo");
        this.verifyContentEqualsStringBuffer("foo", "zoo");
        this.verifyContentEqualsStringBuffer("foo", "");
        this.verifyContentEqualsStringBuffer("", "zoo");
        this.verifyContentEqualsStringBuffer("foo", "f");
        this.verifyContentEqualsStringBuffer("foo", "o");
        this.verifyContentEqualsStringBuffer("foo", "z");
        this.verifyContentEqualsStringBuffer("foo", "oo");
    }

    private void verifyContentEqualsStringBuffer(String s1, String s2) {
        StringBuffer sb = new StringBuffer(s2);
        CharArrayToolsTests.assertEquals((boolean)s1.contentEquals(sb), (boolean)CharArrayTools.contentEquals((char[])s1.toCharArray(), (StringBuffer)sb));
    }

    public void testEndsWith() {
        this.verifyEndsWith("foo", "bar");
        this.verifyEndsWith("foo", "foo");
        this.verifyEndsWith("foo", "zoo");
        this.verifyEndsWith("foo", "");
        this.verifyEndsWith("", "zoo");
        this.verifyEndsWith("foo", "f");
        this.verifyEndsWith("foo", "o");
        this.verifyEndsWith("foo", "z");
        this.verifyEndsWith("foo", "oo");
    }

    private void verifyEndsWith(String s1, String s2) {
        CharArrayToolsTests.assertEquals((boolean)s1.endsWith(s2), (boolean)CharArrayTools.endsWith((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testGetBytes() {
        this.verifyGetBytes("foo");
    }

    private void verifyGetBytes(String string) {
        Assert.assertArrayEquals((byte[])string.getBytes(), (byte[])CharArrayTools.getBytes((char[])string.toCharArray()));
    }

    public void testGetBytesCharSet() throws Exception {
        this.verifyGetBytesCharSet("foo");
    }

    private void verifyGetBytesCharSet(String string) throws Exception {
        String charset = Charset.defaultCharset().name();
        Assert.assertArrayEquals((byte[])string.getBytes(charset), (byte[])CharArrayTools.getBytes((char[])string.toCharArray(), (String)charset));
    }

    public void testGetChars() {
        this.verifyGetChars("foo-bar-baz", 0, 11, 0);
        this.verifyGetChars("foo-bar-baz", 11, 11, 11);
        this.verifyGetChars("foo-bar-baz", 4, 5, 0);
        this.verifyGetChars("foo-bar-baz", 4, 11, 0);
    }

    private void verifyGetChars(String s, int srcBegin, int srcEnd, int destBegin) {
        char[] a1 = ArrayTools.fill((char[])new char[42], (char)'x');
        s.getChars(srcBegin, srcEnd, a1, destBegin);
        char[] a2 = ArrayTools.fill((char[])new char[42], (char)'x');
        CharArrayTools.getChars((char[])s.toCharArray(), (int)srcBegin, (int)srcEnd, (char[])a2, (int)destBegin);
        Assert.assertArrayEquals((char[])a1, (char[])a2);
    }

    public void testIndexOfChar() {
        this.verifyIndexOfChar("foo-bar-baz", ' ');
        this.verifyIndexOfChar("foo-bar-baz", 'f');
        this.verifyIndexOfChar("foo-bar-baz", 'b');
        this.verifyIndexOfChar("foo-bar-baz", 'z');
        this.verifyIndexOfChar("", ' ');
        this.verifyIndexOfChar("", 'f');
        this.verifyIndexOfChar("", 'b');
        this.verifyIndexOfChar("", 'z');
    }

    private void verifyIndexOfChar(String string, char c) {
        CharArrayToolsTests.assertEquals((int)string.indexOf(c), (int)CharArrayTools.indexOf((char[])string.toCharArray(), (int)c));
    }

    public void testIndexOfCharIndex() {
        this.verifyIndexOfCharIndex("foo-bar-baz", ' ');
        this.verifyIndexOfCharIndex("foo-bar-baz", 'f');
        this.verifyIndexOfCharIndex("foo-bar-baz", 'b');
        this.verifyIndexOfCharIndex("foo-bar-baz", 'z');
        this.verifyIndexOfCharIndex("", ' ');
        this.verifyIndexOfCharIndex("", 'f');
        this.verifyIndexOfCharIndex("", 'b');
        this.verifyIndexOfCharIndex("", 'z');
    }

    private void verifyIndexOfCharIndex(String string, char c) {
        CharArrayToolsTests.assertEquals((int)string.indexOf(c, 3), (int)CharArrayTools.indexOf((char[])string.toCharArray(), (int)c, (int)3));
    }

    public void testIndexOfCharSequence() {
        this.verifyIndexOfCharSequence("foo-bar-baz", "");
        this.verifyIndexOfCharSequence("foo-bar-baz", "foo-bar-baz");
        this.verifyIndexOfCharSequence("foo-bar-baz", "bar");
        this.verifyIndexOfCharSequence("foo-bar-baz", "bbb");
        this.verifyIndexOfCharSequence("", "");
        this.verifyIndexOfCharSequence("", "foo-bar-baz");
        this.verifyIndexOfCharSequence("", "bar");
        this.verifyIndexOfCharSequence("", "bbb");
    }

    private void verifyIndexOfCharSequence(String s1, String s2) {
        CharArrayToolsTests.assertEquals((int)s1.indexOf(s2), (int)CharArrayTools.indexOf((char[])s1.toCharArray(), (CharSequence)s2));
        CharArrayToolsTests.assertEquals((int)s1.indexOf(s2), (int)CharArrayTools.indexOf((char[])s1.toCharArray(), (CharSequence)s2, (int)-3));
    }

    public void testIndexOfCharArray() {
        this.verifyIndexOfCharArray("foo-bar-baz", "");
        this.verifyIndexOfCharArray("foo-bar-baz", "foo-bar-baz");
        this.verifyIndexOfCharArray("foo-bar-baz", "bar");
        this.verifyIndexOfCharArray("foo-bar-baz", "bbb");
        this.verifyIndexOfCharArray("", "");
        this.verifyIndexOfCharArray("", "foo-bar-baz");
        this.verifyIndexOfCharArray("", "bar");
        this.verifyIndexOfCharArray("", "bbb");
    }

    private void verifyIndexOfCharArray(String s1, String s2) {
        CharArrayToolsTests.assertEquals((int)s1.indexOf(s2), (int)CharArrayTools.indexOf((char[])s1.toCharArray(), (char[])s2.toCharArray()));
        CharArrayToolsTests.assertEquals((int)s1.indexOf(s2), (int)CharArrayTools.indexOf((char[])s1.toCharArray(), (char[])s2.toCharArray(), (int)-3));
    }

    public void testLastIndexOf() {
        this.verifyLastIndexOf("foo-bar-baz", "");
        this.verifyLastIndexOf("foo-bar-baz", "foo-bar-baz");
        this.verifyLastIndexOf("foo-bar-baz", "bar");
        this.verifyLastIndexOf("foo-bar-baz", "bbb");
        this.verifyLastIndexOf("", "");
        this.verifyLastIndexOf("", "foo-bar-baz");
        this.verifyLastIndexOf("", "bar");
        this.verifyLastIndexOf("", "bbb");
    }

    private void verifyLastIndexOf(String s1, String s2) {
        CharArrayToolsTests.assertEquals((int)s1.lastIndexOf(s2), (int)CharArrayTools.lastIndexOf((char[])s1.toCharArray(), (char[])s2.toCharArray()));
        CharArrayToolsTests.assertEquals((int)-1, (int)CharArrayTools.lastIndexOf((char[])s1.toCharArray(), (char[])s2.toCharArray(), (int)-3));
    }

    public void testLastIndexOfChar() {
        this.verifyLastIndexOfChar("foo-bar-baz", ' ');
        this.verifyLastIndexOfChar("foo-bar-baz", 'f');
        this.verifyLastIndexOfChar("foo-bar-baz", 'v');
        this.verifyLastIndexOfChar("foo-bar-baz", 'z');
        this.verifyLastIndexOfChar("", ' ');
        this.verifyLastIndexOfChar("", 'f');
        this.verifyLastIndexOfChar("", 'b');
        this.verifyLastIndexOfChar("", 'z');
    }

    private void verifyLastIndexOfChar(String string, char c) {
        CharArrayToolsTests.assertEquals((int)string.lastIndexOf(c), (int)CharArrayTools.lastIndexOf((char[])string.toCharArray(), (int)c));
        CharArrayToolsTests.assertEquals((int)-1, (int)CharArrayTools.lastIndexOf((char[])string.toCharArray(), (int)c, (int)-3));
    }

    public void testOffsetByCodePoints() {
        this.verifyOffsetByCodePoints("foo-bar-baz", 3, 3);
        this.verifyOffsetByCodePoints("aaaaab", 3, 3);
    }

    private void verifyOffsetByCodePoints(String string, int index, int codePointOffset) {
        CharArrayToolsTests.assertEquals((int)string.offsetByCodePoints(index, codePointOffset), (int)CharArrayTools.offsetByCodePoints((char[])string.toCharArray(), (int)index, (int)codePointOffset));
    }

    public void testMatches() {
        this.verifyMatches("foo-bar-baz", "");
        this.verifyMatches("aaaaab", "a*b");
    }

    private void verifyMatches(String s1, String s2) {
        CharArrayToolsTests.assertEquals((boolean)s1.matches(s2), (boolean)CharArrayTools.matches((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testRegionMatchesIgnoreCase() {
        this.verifyRegionMatchesBoolean("foo-bar-baz", "", true, 0, 0, 5);
        this.verifyRegionMatchesBoolean("foo-bar-baz", "foo", true, 0, 0, 3);
        this.verifyRegionMatchesBoolean("foo-bar-baz", "FOO", true, 0, 0, 3);
        this.verifyRegionMatchesBoolean("foo-bar-baz", "XXX", true, 0, 0, 3);
    }

    public void testRegionMatchesCaseSensitive() {
        this.verifyRegionMatchesBoolean("foo-bar-baz", "", false, 0, 0, 5);
        this.verifyRegionMatchesBoolean("foo-bar-baz", "foo", false, 0, 0, 3);
        this.verifyRegionMatchesBoolean("foo-bar-baz", "xxx", false, 0, 0, 3);
    }

    private void verifyRegionMatchesBoolean(String s1, String s2, boolean ignoreCase, int offset1, int offset2, int len) {
        CharArrayToolsTests.assertEquals((boolean)s1.regionMatches(ignoreCase, offset1, s2, offset2, len), (boolean)CharArrayTools.regionMatches((char[])s1.toCharArray(), (boolean)ignoreCase, (int)offset1, (char[])s2.toCharArray(), (int)offset2, (int)len));
    }

    public void testRegionMatches() {
        this.verifyRegionMatches("foo-bar-baz", "", 0, 0, 5);
        this.verifyRegionMatches("foo-bar-baz", "foo", 0, 0, 3);
        this.verifyRegionMatches("foo-bar-baz", "xxx", 0, 0, 3);
    }

    private void verifyRegionMatches(String s1, String s2, int offset1, int offset2, int len) {
        CharArrayToolsTests.assertEquals((boolean)s1.regionMatches(offset1, s2, offset2, len), (boolean)CharArrayTools.regionMatches((char[])s1.toCharArray(), (int)offset1, (char[])s2.toCharArray(), (int)offset2, (int)len));
    }

    public void testReplace() {
        this.verifyReplace("foo-bar-baz", 'b', 'x');
        this.verifyReplace("foo-bar-baz", 'X', 'T');
        this.verifyReplace("foo-bar-baz", 'X', 'X');
    }

    private void verifyReplace(String string, char oldChar, char newChar) {
        char[] array = CharArrayTools.replace((char[])string.toCharArray(), (char)oldChar, (char)newChar);
        TestTools.assertEquals(string.replace(oldChar, newChar), array);
    }

    public void testStartsWith() {
        this.verifyStartsWith("foo-bar-baz", "foo");
        this.verifyStartsWith("foo-bar-baz", "FOO");
        this.verifyStartsWith("foo-bar-baz", "bar");
    }

    private void verifyStartsWith(String s1, String s2) {
        CharArrayToolsTests.assertEquals((boolean)s1.startsWith(s2), (boolean)CharArrayTools.startsWith((char[])s1.toCharArray(), (char[])s2.toCharArray()));
    }

    public void testStartsWithOffset() {
        this.verifyStartsWithOffset("foo-bar-baz", "foo", 0);
        this.verifyStartsWithOffset("foo-bar-baz", "foo", 4);
        this.verifyStartsWithOffset("foo-bar-baz", "bar", 0);
        this.verifyStartsWithOffset("foo-bar-baz", "bar", 4);
        this.verifyStartsWithOffset("foo-bar-baz", "bar", 22);
        this.verifyStartsWithOffset("foo-bar-baz", "bar", -3);
    }

    private void verifyStartsWithOffset(String s1, String s2, int offset) {
        CharArrayToolsTests.assertEquals((boolean)s1.startsWith(s2, offset), (boolean)CharArrayTools.startsWith((char[])s1.toCharArray(), (char[])s2.toCharArray(), (int)offset));
    }

    public void testSubSequence() {
        this.verifySubSequence("foo-bar-baz", 0, 11);
        this.verifySubSequence("foo-bar-baz", 0, 3);
        this.verifySubSequence("foo-bar-baz", 0, 0);
        this.verifySubSequence("foo-bar-baz", 2, 11);
        this.verifySubSequence("foo-bar-baz", 2, 3);
        this.verifySubSequence("foo-bar-baz", 2, 2);
    }

    private void verifySubSequence(String string, int beginIndex, int endIndex) {
        char[] array = CharArrayTools.subSequence((char[])string.toCharArray(), (int)beginIndex, (int)endIndex);
        TestTools.assertEquals(string.subSequence(beginIndex, endIndex), array);
    }

    public void testTrim() {
        this.verifyTrim("foo-bar-baz");
        this.verifyTrim(" foo-bar-baz ");
        this.verifyTrim("     foo-bar-baz ");
    }

    private void verifyTrim(String string) {
        TestTools.assertEquals(string.trim(), CharArrayTools.trim((char[])string.toCharArray()));
    }
}

