/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.jaxws.testutils.jmock.Mock;
import org.eclipse.jst.ws.jaxws.testutils.jmock.MockObjectTestCase;
import org.eclipse.jst.ws.jaxws.utils.StatusUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.FileUtils;
import org.eclipse.jst.ws.jaxws.utils.resources.IFileUtils;
import org.jmock.core.Constraint;
import org.jmock.core.constraint.IsEqual;
import org.jmock.core.constraint.IsSame;

public class FileUtilsUnitTest
extends MockObjectTestCase {
    private final IFileUtils fileUtils = FileUtils.getInstance();
    private Mock<ICompilationUnit> cuMock;
    private final IProgressMonitor monitor = new NullProgressMonitor();

    protected void setUp() throws Exception {
        this.cuMock = this.mock(ICompilationUnit.class);
    }

    public void testSetCompilationUnitContentDealsCorrectlyWithWorkingCopy() throws JavaModelException {
        Mock bufferMock = this.mock(IBuffer.class);
        bufferMock.expects(this.once()).method("setContents").with((Constraint)new IsSame((Object)"MyTestContent"));
        this.cuMock.expects(this.once()).method("becomeWorkingCopy");
        this.cuMock.expects(this.once()).method("getBuffer").will(this.returnValue(bufferMock.proxy()));
        this.cuMock.expects(this.once()).method("commitWorkingCopy").with((Constraint)new IsEqual((Object)true), (Constraint)new IsSame((Object)this.monitor));
        this.cuMock.expects(this.once()).method("discardWorkingCopy");
        this.fileUtils.setCompilationUnitContent((ICompilationUnit)this.cuMock.proxy(), "MyTestContent", true, this.monitor);
    }

    public void testSetCompilationUnitContentDoesNotDiscardWorkingCopyOnJME() {
        JavaModelException testException = new JavaModelException(new CoreException(StatusUtils.statusError((String)"TEST")));
        this.cuMock.expects(this.once()).method("becomeWorkingCopy").will(this.throwException(testException));
        this.cuMock.expects(this.never()).method("discardWorkingCopy");
        this.cuMock.expects(this.never()).method("commitWorkingCopy");
        try {
            this.fileUtils.setCompilationUnitContent((ICompilationUnit)this.cuMock.proxy(), "123", true, this.monitor);
        }
        catch (JavaModelException e) {
            FileUtilsUnitTest.assertTrue((String)"Test exception was not caught", (e == testException ? 1 : 0) != 0);
        }
    }

    public void testSetCuContentSavesDirtyEditors() throws JavaModelException {
        final boolean[] saveEditorInvoked = new boolean[1];
        final boolean[] setContentsInvoked = new boolean[1];
        FileUtils myFileUtils = new FileUtils(){

            public boolean isCompilationUnitDisplayedInDirtyEditor(ICompilationUnit cu) {
                FileUtilsUnitTest.assertTrue((String)"Unexpected compilation unit", (cu == FileUtilsUnitTest.this.cuMock.proxy() ? 1 : 0) != 0);
                return true;
            }

            public void saveEditor(ICompilationUnit cu) {
                FileUtilsUnitTest.assertTrue((String)"Save editors invoked before set CU content", (boolean)setContentsInvoked[0]);
                FileUtilsUnitTest.assertTrue((String)"Unexpected compilation unit", (cu == FileUtilsUnitTest.this.cuMock.proxy() ? 1 : 0) != 0);
                saveEditorInvoked[0] = true;
            }

            public void setCompilationUnitContent(ICompilationUnit unit, String content, boolean force, IProgressMonitor monitor) throws JavaModelException {
                FileUtilsUnitTest.assertFalse((String)"Set CU content invoked after editor saved", (boolean)saveEditorInvoked[0]);
                FileUtilsUnitTest.assertEquals((String)"Unexpected CU content", (String)"MyContent", (String)content);
                setContentsInvoked[0] = true;
            }
        };
        myFileUtils.setCompilationUnitContentAndSaveDirtyEditors((ICompilationUnit)this.cuMock.proxy(), "MyContent", true, null);
        FileUtilsUnitTest.assertTrue((String)"Set contents not invoked", (boolean)setContentsInvoked[0]);
        FileUtilsUnitTest.assertTrue((String)"Save editors not invoked", (boolean)saveEditorInvoked[0]);
    }

    public void testSetCuContentDoesNotSavesCleanEditors() throws JavaModelException {
        final boolean[] isDisplayedInvoked = new boolean[1];
        final boolean[] setContentsInvoked = new boolean[1];
        FileUtils myFileUtils = new FileUtils(){

            public boolean isCompilationUnitDisplayedInDirtyEditor(ICompilationUnit cu) {
                FileUtilsUnitTest.assertTrue((String)"Unexpected compilation unit", (cu == FileUtilsUnitTest.this.cuMock.proxy() ? 1 : 0) != 0);
                isDisplayedInvoked[0] = true;
                return false;
            }

            public void saveEditor(ICompilationUnit cu) {
                FileUtilsUnitTest.fail((String)"Unexpected invocation");
            }

            public void setCompilationUnitContent(ICompilationUnit unit, String content, boolean force, IProgressMonitor monitor) throws JavaModelException {
                FileUtilsUnitTest.assertFalse((String)"Set CU content invoked after editor saved", (boolean)isDisplayedInvoked[0]);
                FileUtilsUnitTest.assertEquals((String)"Unexpected CU content", (String)"MyContent", (String)content);
                setContentsInvoked[0] = true;
            }
        };
        myFileUtils.setCompilationUnitContentAndSaveDirtyEditors((ICompilationUnit)this.cuMock.proxy(), "MyContent", true, null);
        FileUtilsUnitTest.assertTrue((String)"Set contents not invoked", (boolean)setContentsInvoked[0]);
        FileUtilsUnitTest.assertTrue((String)"Is displayed in dirty editor not invoked", (boolean)isDisplayedInvoked[0]);
    }
}

