/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.utils.tests.internal.annotations;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.jaxws.testutils.project.ClassLoadingTest;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationFactory;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationGeneratorException;
import org.eclipse.jst.ws.jaxws.utils.annotations.AnnotationWriter;
import org.eclipse.jst.ws.jaxws.utils.annotations.IAnnotation;
import org.eclipse.jst.ws.jaxws.utils.annotations.IParamValuePair;
import org.eclipse.jst.ws.jaxws.utils.annotations.IValue;
import org.eclipse.jst.ws.jaxws.utils.internal.annotations.impl.StringValueImpl;

public class StringValueImplTest
extends ClassLoadingTest {
    private static final String SRC = "src";
    private static final String PCK = "org.eclipse.demo";
    private IType endpoint;

    public void setUp() throws CoreException, IOException, AnnotationGeneratorException {
        this.createJavaProject(SRC, PCK);
        this.endpoint = this.createClass("Endpoint.src", "Endpoint");
        AnnotationFactory.removeAnnotationsFromJavaElement((IJavaElement)this.endpoint);
    }

    public void testIntegers() throws Exception {
        this.setUp();
        StringValueImpl sv = new StringValueImpl("10");
        HashSet<IParamValuePair> pv = new HashSet<IParamValuePair>();
        pv.add(AnnotationFactory.createParamValuePairValue((String)"param", (IValue)sv));
        IAnnotation ann = AnnotationFactory.createAnnotation((String)"org.eclipse.test.MyAnnotation", pv, (IJavaElement)this.endpoint);
        AnnotationWriter.getInstance().setAppliedElement(ann, (IJavaElement)this.endpoint);
        Collection annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        StringValueImplTest.assertNotNull((Object)annotattions);
        StringValueImplTest.assertTrue((annotattions.size() == 1 ? 1 : 0) != 0);
        IAnnotation readAnnotation = (IAnnotation)annotattions.iterator().next();
        readAnnotation.equals(ann);
        StringValueImplTest.assertEquals((String)ann.getPropertyValue("param").toString(), (String)"10");
        AnnotationWriter.getInstance().remove(ann);
        annotattions = AnnotationFactory.createAnnotationInspector((IType)this.endpoint).inspectType();
        StringValueImplTest.assertNotNull((Object)annotattions);
        StringValueImplTest.assertTrue((annotattions.size() == 0 ? 1 : 0) != 0);
    }

    public void testEqualsObject() {
        StringValueImpl sv1 = new StringValueImpl("10");
        StringValueImpl sv2 = new StringValueImpl("11");
        StringValueImpl sv3 = new StringValueImpl("10");
        StringValueImplTest.assertFalse((boolean)sv1.equals(null));
        StringValueImplTest.assertFalse((boolean)sv1.equals((Object)true));
        StringValueImplTest.assertFalse((boolean)sv1.equals((Object)sv2));
        StringValueImplTest.assertTrue((boolean)sv1.equals((Object)sv3));
        StringValueImplTest.assertTrue((boolean)sv1.equals((Object)sv1));
    }
}

