/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.format;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.FormattingContext;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslationAdapterFactory;
import org.eclipse.wst.jsdt.web.ui.StructuredTextViewerConfigurationJSDT;
import org.eclipse.wst.jsdt.web.ui.tests.internal.ProjectUtil;
import org.eclipse.wst.jsdt.web.ui.tests.internal.StringUtils;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;

public class FormattingTests
extends TestCase {
    private static final String PROJECT_NAME = "FormattingTests";
    private static final String PROJECT_FILES = "/testFiles/formatting";
    static IProject fProject;
    static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
    static String previousWTPAutoTestNonInteractivePropValue;

    static {
        previousWTPAutoTestNonInteractivePropValue = null;
    }

    public FormattingTests() {
        super("Formatting Tests");
    }

    public FormattingTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(FormattingTests.class, "Formatting Tests");
        return new FormattingTestsSetup((Test)ts);
    }

    public void testFormatHTMLScriptEvent() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test0.html", "test0.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test2.html", "test2-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLCommentWithInvalidJS() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test3.html", "test3.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWithJustEndHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test4.html", "test4-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWithJustStartHTMLComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test5.html", "test5-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test6.html", "test6-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_FormattingHTMLBeforeScript() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test7.html", "test7-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString_WithHTMLCommentStartAndEnd_simple() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test8.html", "test8-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScript_WithHTMLTagInString_WithHTMLCommentStartAndEnd_advanded() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test9.html", "test9-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInLeadingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test10.html", "test10-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInTrailingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test11.html", "test11-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegionWrappedWithHTMLComment_TextInLeadingComment_and_TextInTrailingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test12.html", "test12-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegion_AllOnOneLine() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test13.html", "test13-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegion_AllOnOneLine_LeadingComment() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test14.html", "test14-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormatHTMLScriptRegion_AfterEventHander() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test15.html", "test15-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testFormat_NoEdits() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test16.html", "test16-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testBug383387() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test17.html", "test17-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testWI97431() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test18.html", "test18-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testCDATAPreserved() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test19.html", "test19-fmt.html", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    public void testBug377979() throws UnsupportedEncodingException, IOException, CoreException {
        this.formatAndAssertEquals("test20.jsp", "test20-fmt.jsp", (SourceViewerConfiguration)new StructuredTextViewerConfigurationJSDT());
    }

    private void formatAndAssertEquals(String beforePath, String afterPath, SourceViewerConfiguration configuration) throws UnsupportedEncodingException, IOException, CoreException {
        StyledText text;
        IStructuredModel beforeModel = null;
        IStructuredModel afterModel = null;
        ISourceViewer viewer = null;
        try {
            beforeModel = this.getModelForEdit(beforePath);
            FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + beforePath), (Object)beforeModel);
            JsTranslationAdapterFactory.setupAdapterFactory((IStructuredModel)beforeModel);
            afterModel = this.getModelForEdit(afterPath);
            FormattingTests.assertNotNull((String)("could not retrieve structured model for : " + afterPath), (Object)afterModel);
            IStructuredDocument document = beforeModel.getStructuredDocument();
            String normalizedContents = document.get();
            normalizedContents = StringUtils.replace(normalizedContents, "\r\n", "\n");
            normalizedContents = StringUtils.replace(normalizedContents, "\r", "\n");
            document.set(normalizedContents);
            viewer = FormattingTests.getConfiguredViewer((IDocument)document, configuration);
            FormattingTests.assertNotNull((String)"Could not get viewer to run test", (Object)viewer);
            IContentFormatterExtension formatter = (IContentFormatterExtension)configuration.getContentFormatter(viewer);
            FormattingContext fContext = new FormattingContext();
            Region region = new Region(0, document.getLength());
            fContext.setProperty((Object)"formatting.context.document", (Object)true);
            fContext.setProperty((Object)"formatting.context.region", (Object)region);
            formatter.format((IDocument)document, (IFormattingContext)fContext);
            String actualContents = beforeModel.getStructuredDocument().get();
            String expectedContents = afterModel.getStructuredDocument().get();
            expectedContents = StringUtils.replace(expectedContents, "\r\n", "\n");
            expectedContents = StringUtils.replace(expectedContents, "\r", "\n");
            actualContents = StringUtils.replace(actualContents, "\r\n", "\n");
            actualContents = StringUtils.replace(actualContents, "\r", "\n");
            this.onlyWhiteSpaceDiffers(expectedContents, actualContents);
            FormattingTests.assertEquals((String)"Formatted document differs from the expected.", (String)expectedContents, (String)actualContents);
        }
        catch (Throwable throwable) {
            StyledText text2;
            if (beforeModel != null) {
                try {
                    beforeModel.releaseFromEdit();
                }
                catch (Exception exception) {}
            }
            if (afterModel != null) {
                try {
                    afterModel.releaseFromEdit();
                }
                catch (Exception exception) {}
            }
            if (viewer != null && (text2 = viewer.getTextWidget()) != null && !text2.isDisposed()) {
                text2.dispose();
            }
            throw throwable;
        }
        if (beforeModel != null) {
            try {
                beforeModel.releaseFromEdit();
            }
            catch (Exception exception) {}
        }
        if (afterModel != null) {
            try {
                afterModel.releaseFromEdit();
            }
            catch (Exception exception) {}
        }
        if (viewer != null && (text = viewer.getTextWidget()) != null && !text.isDisposed()) {
            text.dispose();
        }
    }

    private boolean onlyWhiteSpaceDiffers(String expectedContents, String actualContents) {
        CharArrayWriter writer1 = new CharArrayWriter();
        char[] expected = expectedContents.toCharArray();
        int i = 0;
        while (i < expected.length) {
            if (!Character.isWhitespace(expected[i])) {
                writer1.write(expected[i]);
            }
            ++i;
        }
        CharArrayWriter writer2 = new CharArrayWriter();
        char[] actual = actualContents.toCharArray();
        int i2 = 0;
        while (i2 < actual.length) {
            if (!Character.isWhitespace(actual[i2])) {
                writer2.write(actual[i2]);
            }
            ++i2;
        }
        writer1.close();
        writer2.close();
        char[] expectedCompacted = writer1.toCharArray();
        char[] actualCompacted = writer2.toCharArray();
        FormattingTests.assertEquals((String)"significant character differs", (String)new String(expectedCompacted), (String)new String(actualCompacted));
        return true;
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        FormattingTests.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private IStructuredModel getModelForEdit(String path) {
        IFile file = FormattingTests.getFile(path);
        IStructuredModel model = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            model = modelManager.getModelForEdit(file);
            FormattingTests.assertNotNull((String)("No model created for file type " + file.getContentDescription().getContentType().getId()), (Object)model);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        catch (IOException io) {
            io.printStackTrace();
        }
        return model;
    }

    protected void setUp() throws Exception {
        super.setUp();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (!project.isAccessible()) {
            FormattingTests._createProject();
        }
    }

    static void _createProject() {
        fProject = ProjectUtil.createProject(PROJECT_NAME, null, new String[]{"org.eclipse.wst.jsdt.core.jsNature"});
        ProjectUtil.copyBundleEntriesIntoWorkspace(PROJECT_FILES, PROJECT_NAME);
        String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
        previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
        System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
    }

    private static ISourceViewer getConfiguredViewer(IDocument document, SourceViewerConfiguration configuration) {
        StructuredTextViewer viewer = null;
        FormattingTests.assertNotNull((String)"Could not get current display to run test with.", (Object)Display.getCurrent());
        Shell shell = null;
        shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
        Composite parent = new Composite((Composite)shell, 0);
        viewer = new StructuredTextViewer(parent, null, null, false, 0);
        viewer.setDocument(document);
        viewer.configure(configuration);
        return viewer;
    }

    private static class FormattingTestsSetup
    extends TestSetup {
        public FormattingTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            FormattingTests._createProject();
        }

        public void tearDown() throws Exception {
            try {
                try {
                    fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException coreException) {
                    if (previousWTPAutoTestNonInteractivePropValue != null) {
                        System.setProperty(FormattingTests.WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
                    }
                }
            }
            finally {
                if (previousWTPAutoTestNonInteractivePropValue != null) {
                    System.setProperty(FormattingTests.WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
                }
            }
        }
    }
}

