/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSTextLayout;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.FlowUtilities;
import org.eclipse.jst.pagedesigner.css2.layout.ICSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.TextFragmentBox;
import org.eclipse.jst.pagedesigner.css2.layout.TextLayoutSupport;
import org.eclipse.jst.pagedesigner.css2.provider.ICSSTextProvider;
import org.eclipse.jst.pagedesigner.css2.style.DefaultStyle;
import org.eclipse.jst.pagedesigner.css2.style.StyleUtil;
import org.eclipse.jst.pagedesigner.viewer.CaretPositionResolver;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class CSSTextFigure
extends FlowFigure
implements ICSSFigure {
    private ICSSTextProvider _provider;
    private List _fragments = new ArrayList(1);

    public CSSTextFigure(ICSSTextProvider provider) {
        this._provider = provider;
        this.setLayoutManager((LayoutManager)this.createDefaultFlowLayout());
    }

    public ICSSStyle getCSSStyle() {
        ICSSStyle style;
        IFigure parentFigure = this.getParent();
        if (parentFigure instanceof ICSSFigure && (style = ((ICSSFigure)parentFigure).getCSSStyle()) != null) {
            return style;
        }
        return DefaultStyle.getInstance();
    }

    public boolean containsPoint(int x, int y) {
        if (!super.containsPoint(x, y)) {
            return false;
        }
        List frags = this.getFragments();
        int i = 0;
        int n = frags.size();
        while (i < n) {
            if (((FlowBox)frags.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new CSSTextLayout(this);
    }

    public List getFragments() {
        return this._fragments;
    }

    public List getFragmentsForRead() {
        return this.getFragments();
    }

    public String getText() {
        return this._provider.getTextData();
    }

    public void postValidate() {
        int right;
        int left;
        List list = this.getFragments();
        int top = left = Integer.MAX_VALUE;
        int bottom = right = Integer.MIN_VALUE;
        int i = 0;
        int n = list.size();
        while (i < n) {
            FlowBox box = (FlowBox)list.get(i);
            left = Math.min(left, box._x);
            right = Math.max(right, box._x + box._width);
            top = Math.min(top, box._y);
            bottom = Math.max(bottom, box._y + box._height);
            ++i;
        }
        this.setBounds(new Rectangle(left, top, right - left, bottom - top));
        list = this.getChildren();
        i = 0;
        n = list.size();
        while (i < n) {
            ((FlowFigure)((Object)list.get(i))).postValidate();
            ++i;
        }
    }

    protected void paintBorder(Graphics graphics) {
    }

    protected void paintFigure(Graphics g) {
        Object result = this.getCSSStyle().getColor();
        Object color = result instanceof Color ? (Color)result : (result instanceof RGB ? new Color(null, (RGB)result) : null);
        int[] range = null;
        if (!StyleUtil.isInWidget(this.getCSSStyle())) {
            range = this._provider.getSelectedRange();
        }
        if (range == null || range[0] == range[1]) {
            TextLayoutSupport.paintTextFigure(g, this._fragments, this.getCSSStyle().getCSSFont().getSwtFont(), color, (Integer)this.getCSSStyle().getStyleProperty("text-decoration"));
        } else {
            TextLayoutSupport.paintTextFigureWithSelection(g, this._fragments, this._provider.getTextData(), this.getCSSStyle().getCSSFont().getSwtFont(), color, (Integer)this.getCSSStyle().getStyleProperty("text-decoration"), range[0], range[1], ColorConstants.white, Display.getDefault().getSystemColor(26));
        }
        if (color != result && color != null) {
            color.dispose();
        }
    }

    public int getNewInsertionOffset(Point relative) {
        FlowBox closestBox = null;
        int i = 0;
        int n = this._fragments.size();
        while (i < n) {
            int offset2;
            int offset1;
            FlowBox tempBox;
            TextFragmentBox box = (TextFragmentBox)this._fragments.get(i);
            if (box.containsPoint(relative.x, relative.y)) {
                int index = FlowUtilities.getTextInWidth(box.getTextData(), this.getCSSStyle().getCSSFont().getSwtFont(), relative.x - box._x, TextLayoutSupport.getAverageCharWidth(box));
                return box._offset + index;
            }
            if (closestBox == null) {
                closestBox = box;
            } else {
                tempBox = box;
                offset1 = Math.abs(CaretPositionResolver.getYDistance(new Rectangle(tempBox._x, tempBox._y, tempBox._width, tempBox._height), relative));
                tempBox = closestBox;
                offset2 = Math.abs(CaretPositionResolver.getYDistance(new Rectangle(tempBox._x, tempBox._y, tempBox._width, tempBox._height), relative));
                if (offset1 < offset2) {
                    closestBox = box;
                }
            }
            if (box.containsPoint(box._x, relative.y)) {
                tempBox = box;
                offset1 = Math.abs(CaretPositionResolver.getXDistance(new Rectangle(tempBox._x, tempBox._y, tempBox._width, tempBox._height), relative));
                tempBox = closestBox;
                offset2 = Math.abs(CaretPositionResolver.getXDistance(new Rectangle(tempBox._x, tempBox._y, tempBox._width, tempBox._height), relative));
                if (offset1 < offset2) {
                    closestBox = box;
                }
            }
            ++i;
        }
        if (closestBox.containsPoint(((TextFragmentBox)closestBox)._x, relative.y) || closestBox.containsPoint(relative.x, ((TextFragmentBox)closestBox)._y)) {
            int offset = relative.x - ((TextFragmentBox)closestBox)._x;
            int index = FlowUtilities.getTextInWidth(((TextFragmentBox)closestBox).getTextData(), this.getCSSStyle().getCSSFont().getSwtFont(), offset, TextLayoutSupport.getAverageCharWidth((TextFragmentBox)closestBox));
            return ((TextFragmentBox)closestBox)._offset + index;
        }
        return -1;
    }

    public int getInsertionOffset(Point relative) {
        int i = 0;
        int n = this._fragments.size();
        while (i < n) {
            TextFragmentBox box = (TextFragmentBox)this._fragments.get(i);
            if (box.containsPoint(relative.x, relative.y)) {
                int index = FlowUtilities.getTextInWidth(box.getTextData(), this.getCSSStyle().getCSSFont().getSwtFont(), relative.x - box._x, TextLayoutSupport.getAverageCharWidth(box));
                return box._offset + index;
            }
            ++i;
        }
        return -1;
    }

    public Rectangle calculateCaretPosition(int offset) {
        if (offset > 0) {
            int i = this._fragments.size() - 1;
            while (i >= 0) {
                TextFragmentBox box = (TextFragmentBox)this._fragments.get(i);
                if (box._offset <= offset) {
                    if (box._offset + box._length < offset) {
                        return new Rectangle(box._x + box._width, box._y, 1, box._height);
                    }
                    String s = box.getTextData().substring(0, offset - box._offset);
                    int width = FlowUtilities.getTextExtents((String)s, (Font)this.getCSSStyle().getCSSFont().getSwtFont()).width;
                    return new Rectangle(box._x + width, box._y, 1, box._height);
                }
                --i;
            }
        } else if (this._fragments.size() > 0) {
            TextFragmentBox box = (TextFragmentBox)this._fragments.get(0);
            return new Rectangle(box._x, box._y, 1, box._height);
        }
        return new Rectangle(this.getBounds().x, this.getBounds().y, 1, this.getBounds().height);
    }
}

