/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.deque;

import java.util.NoSuchElementException;
import org.eclipse.jpt.common.utility.deque.Deque;
import org.eclipse.jpt.common.utility.internal.deque.DequeTools;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeTests;

public class ReverseDequeTests
extends DequeTests {
    private Deque<String> original;

    public ReverseDequeTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.original = DequeTools.arrayDeque();
    }

    @Override
    public Deque<String> buildDeque() {
        return DequeTools.reverse(this.original);
    }

    public void testIsEmpty_combo() {
        Deque<String> queue = this.buildDeque();
        ReverseDequeTests.assertTrue((boolean)queue.isEmpty());
        this.original.enqueueTail((Object)"first");
        ReverseDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.enqueueTail((Object)"second");
        ReverseDequeTests.assertFalse((boolean)queue.isEmpty());
        this.original.enqueueHead((Object)"zero");
        ReverseDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueHead();
        ReverseDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueHead();
        ReverseDequeTests.assertFalse((boolean)queue.isEmpty());
        queue.dequeueTail();
        ReverseDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueTailAndDequeueTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
    }

    public void testEnqueueHeadAndDequeueHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueHead((Object)first);
        this.original.enqueueHead((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
    }

    public void testEnqueueAndDequeue_combo() {
        Deque<String> queue = this.buildDeque();
        String negative = "negative";
        String zero = "zero";
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        this.original.enqueueHead((Object)zero);
        this.original.enqueueHead((Object)negative);
        ReverseDequeTests.assertEquals((String)negative, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEnqueueTailAndPeekTail() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
    }

    public void testEnqueueHeadAndPeekHead() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueHead((Object)first);
        this.original.enqueueHead((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
    }

    public void testEnqueueAndPeek_combo() {
        Deque<String> queue = this.buildDeque();
        String negative = "negative";
        String zero = "zero";
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        this.original.enqueueHead((Object)zero);
        this.original.enqueueHead((Object)negative);
        ReverseDequeTests.assertEquals((String)negative, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)negative, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)negative, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)zero, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testEmptyDequeExceptionPeekTail_combo() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        boolean exCaught = false;
        try {
            queue.peekTail();
            ReverseDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReverseDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionPeekHead_combo() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueHead((Object)first);
        this.original.enqueueHead((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        boolean exCaught = false;
        try {
            queue.peekHead();
            ReverseDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReverseDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionDequeueTail_combo() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueTail((Object)first);
        this.original.enqueueTail((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekTail()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueTail()));
        boolean exCaught = false;
        try {
            queue.dequeueTail();
            ReverseDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReverseDequeTests.assertTrue((boolean)exCaught);
    }

    public void testEmptyDequeExceptionDequeueHead_combo() {
        Deque<String> queue = this.buildDeque();
        String first = "first";
        String second = "second";
        this.original.enqueueHead((Object)first);
        this.original.enqueueHead((Object)second);
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)first, (String)((String)queue.dequeueHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.peekHead()));
        ReverseDequeTests.assertEquals((String)second, (String)((String)queue.dequeueHead()));
        boolean exCaught = false;
        try {
            queue.dequeueHead();
            ReverseDequeTests.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ReverseDequeTests.assertTrue((boolean)exCaught);
    }

    @Override
    public void testClone() {
    }

    @Override
    public void testToString() throws Exception {
        Deque<String> queue = this.buildDeque();
        ReverseDequeTests.assertTrue((boolean)queue.toString().startsWith("ReverseDeque"));
        ReverseDequeTests.assertTrue((boolean)queue.toString().endsWith("([])"));
        queue.enqueueTail((Object)"first");
        ReverseDequeTests.assertTrue((boolean)queue.toString().startsWith("ReverseDeque"));
        ReverseDequeTests.assertTrue((boolean)queue.toString().endsWith("([first])"));
        queue.enqueueTail((Object)"second");
        ReverseDequeTests.assertTrue((boolean)queue.toString().startsWith("ReverseDeque"));
        ReverseDequeTests.assertTrue((boolean)queue.toString().endsWith("([second, first])"));
        queue.enqueueTail((Object)"third");
        ReverseDequeTests.assertTrue((boolean)queue.toString().startsWith("ReverseDeque"));
        ReverseDequeTests.assertTrue((boolean)queue.toString().endsWith("([third, second, first])"));
        queue.enqueueHead((Object)"foo");
        ReverseDequeTests.assertTrue((boolean)queue.toString().startsWith("ReverseDeque"));
        ReverseDequeTests.assertTrue((boolean)queue.toString().endsWith("([third, second, first, foo])"));
    }

    public void testCtor_nullDeque() {
        boolean exCaught = false;
        try {
            Deque deque = DequeTools.reverse(null);
            ReverseDequeTests.fail((String)("bogus deque: " + deque));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        ReverseDequeTests.assertTrue((boolean)exCaught);
    }
}

