/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.tests;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.sse.ui.tests.Logger;

public class ActionTestView
extends ViewPart {
    private static final String ACTIONTEXT = "actiontext";
    private static final String DEFAULT_ACTION_TEXT = "Use either the toolbar or the menu to run your actions\n\nWrite new lines with file paths and hit enter to open them.\n\n";
    StyledText fControl = null;
    ISelection fSelection;
    private ISelectionListener fSelectionListener;
    private IDocument fDocument = new Document();

    private List<Action> createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(new EmptyTextSetter());
        actions.add(new ComponentViewer());
        return actions;
    }

    private List<IContributionItem> createContribututions() {
        ArrayList<IContributionItem> actions = new ArrayList<IContributionItem>();
        return actions;
    }

    public void createPartControl(Composite parent) {
        TextViewer text = new TextViewer(parent, 2);
        text.setDocument(this.fDocument);
        this.fControl = text.getTextWidget();
        this.fControl.addKeyListener((KeyListener)new KeyAdapter((ITextViewer)text, parent){
            private final /* synthetic */ ITextViewer val$text;
            private final /* synthetic */ Composite val$parent;
            {
                this.val$text = iTextViewer;
                this.val$parent = composite;
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\r') {
                    int offset = ActionTestView.this.fControl.getCaretOffset();
                    try {
                        IRegion lineInformation = this.val$text.getDocument().getLineInformationOfOffset(offset - 1);
                        String path = this.val$text.getDocument().get(lineInformation.getOffset(), lineInformation.getLength());
                        if (path.trim().length() > 0) {
                            Event event = new Event();
                            event.type = 46;
                            event.text = path.trim();
                            event.widget = ActionTestView.this.fControl;
                            Method m = this.val$parent.getDisplay().getClass().getDeclaredMethod("sendEvent", Integer.TYPE, Event.class);
                            m.setAccessible(true);
                            m.invoke((Object)this.val$parent.getDisplay(), event.type, event);
                        }
                    }
                    catch (BadLocationException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                    catch (NoSuchMethodException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                    catch (SecurityException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                    catch (IllegalArgumentException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        Logger.logException(e);
                        e.printStackTrace();
                    }
                }
                super.keyReleased(keyEvent);
            }
        });
    }

    public void saveState(IMemento memento) {
        memento.putString(ACTIONTEXT, this.fDocument.get());
        super.saveState(memento);
    }

    private ISelectionListener getSelectionListener() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    ActionTestView.this.fSelection = selection;
                }
            };
        }
        return this.fSelectionListener;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site);
        String contents = memento.getString(ACTIONTEXT);
        if (contents == null || contents.length() == 0) {
            contents = DEFAULT_ACTION_TEXT;
        }
        this.fDocument.set(contents);
        List<Action> actions = this.createActions();
        int i = 0;
        while (i < actions.size()) {
            site.getActionBars().getToolBarManager().add((IAction)actions.get(i));
            site.getActionBars().getMenuManager().add((IAction)actions.get(i));
            ++i;
        }
        List<IContributionItem> contributions = this.createContribututions();
        int i2 = 0;
        while (i2 < contributions.size()) {
            site.getActionBars().getToolBarManager().add(contributions.get(i2));
            site.getActionBars().getMenuManager().add(contributions.get(i2));
            ++i2;
        }
        site.getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionListener());
    }

    void print(String s) {
        this.fControl.append(s);
    }

    public void setFocus() {
        if (this.fControl != null && !this.fControl.isDisposed()) {
            this.fControl.setFocus();
        }
    }

    private class ComponentViewer
    extends Action {
        private ComponentViewer() {
        }

        public void run() {
            IResource resource;
            IVirtualResource[] virtualResources;
            IStructuredSelection selection;
            super.run();
            if (ActionTestView.this.fSelection != null && !ActionTestView.this.fSelection.isEmpty() && ActionTestView.this.fSelection instanceof IStructuredSelection && (selection = (IStructuredSelection)ActionTestView.this.fSelection).getFirstElement() instanceof IResource && (virtualResources = ComponentCore.createResources((IResource)(resource = (IResource)selection.getFirstElement()).getProject())) != null) {
                int i = 0;
                while (i < virtualResources.length) {
                    System.out.println(virtualResources[i].getComponent().getRootFolder().getWorkspaceRelativePath());
                    ++i;
                }
            }
        }
    }

    class EmptyTextSetter
    extends Action {
        public EmptyTextSetter() {
            super("Set Text Editor text to empty");
            this.setToolTipText("Set Text Editor text to empty using set() API");
        }

        public void run() {
            super.run();
            IEditorPart editor = ActionTestView.this.getViewSite().getPage().getActiveEditor();
            ITextEditor textEditor = null;
            textEditor = editor instanceof ITextEditor ? (ITextEditor)editor : (ITextEditor)editor.getAdapter(ITextEditor.class);
            if (textEditor != null) {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                document.set("");
            } else {
                ActionTestView.this.print("Error getting IDocument.\n");
            }
        }
    }
}

