/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.jsf.facesconfig.emf.ActionListenerType;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.DefaultRenderKitIdType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.MessageBundleType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationCaseType;
import org.eclipse.jst.jsf.facesconfig.emf.NavigationRuleType;

public final class FacesConfigModelUtil {
    public static NavigationRuleType findNavigationHandlerRuleByDescriptionText(List navRules, String descriptionText) {
        if (descriptionText == null) {
            return null;
        }
        for (NavigationRuleType navHandlerType : navRules) {
            if (FacesConfigModelUtil.findDescriptionType((List)navHandlerType.getDescription(), descriptionText) == null) continue;
            return navHandlerType;
        }
        return null;
    }

    public static NavigationRuleType findNavigationHandlerRuleByDisplayName(List navRules, String displayName) {
        if (displayName == null) {
            return null;
        }
        for (NavigationRuleType navHandlerType : navRules) {
            if (FacesConfigModelUtil.findDisplayNameType((List)navHandlerType.getDisplayName(), displayName) == null) continue;
            return navHandlerType;
        }
        return null;
    }

    public static DisplayNameType findDisplayNameType(List descTypes, String matchText) {
        if (matchText == null) {
            return null;
        }
        for (DisplayNameType descType : descTypes) {
            if (!matchText.equals(descType.getTextContent())) continue;
            return descType;
        }
        return null;
    }

    public static DescriptionType findDescriptionType(List descTypes, String matchText) {
        if (matchText == null) {
            return null;
        }
        for (DescriptionType descType : descTypes) {
            if (!matchText.equals(descType.getTextContent())) continue;
            return descType;
        }
        return null;
    }

    public static IconType findIconTypeByLang(List iconTypes, String xmlLangMatch) {
        for (IconType icon : iconTypes) {
            if (xmlLangMatch == null && icon.getLang() == null) {
                return icon;
            }
            if (xmlLangMatch == null || !xmlLangMatch.equals(icon.getLang())) continue;
            return icon;
        }
        return null;
    }

    public static NavigationCaseType findNavigationCaseByDisplayName(List navigationCases, String displayName) {
        for (NavigationCaseType navCase : navigationCases) {
            if (displayName == null || FacesConfigModelUtil.findDisplayNameType((List)navCase.getDisplayName(), displayName) == null) continue;
            return navCase;
        }
        return null;
    }

    public static ApplicationType findApplicationById(List applications, String id) {
        for (ApplicationType app : applications) {
            if (id == null || !id.equals(app.getId())) continue;
            return app;
        }
        return null;
    }

    public static ActionListenerType findActionListenerById(List actionListeners, String id) {
        for (ActionListenerType app : actionListeners) {
            if (id == null || !id.equals(app.getId())) continue;
            return app;
        }
        return null;
    }

    public static DefaultRenderKitIdType findDefaultRenderKitIdTypeById(List defaultRenderKits, String id) {
        for (DefaultRenderKitIdType renderKitId : defaultRenderKits) {
            if (id == null || !id.equals(renderKitId.getId())) continue;
            return renderKitId;
        }
        return null;
    }

    public static MessageBundleType findMessageBundleTypeById(List messageBundles, String id) {
        for (MessageBundleType messageBundle : messageBundles) {
            if (id == null || !id.equals(messageBundle.getId())) continue;
            return messageBundle;
        }
        return null;
    }

    public static EObject findEObjectElementById(List eObjects, String id) {
        for (EObject eObject : eObjects) {
            Object value;
            EStructuralFeature feature = eObject.eClass().getEStructuralFeature("id");
            if (feature == null || !((value = eObject.eGet(feature)) instanceof String) || !value.equals(id)) continue;
            return eObject;
        }
        return null;
    }
}

