/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.layouts;

import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ExposedPropertyCreationSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutDataInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowDataInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.VirtualLayoutDataCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.VirtualLayoutDataVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.grid.GridDataInfo;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class VirtualLayoutDataTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_virtual_initial() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        CreationSupport creationSupport = dataInfo.getCreationSupport();
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)creationSupport);
        VirtualLayoutDataTest.assertTrue((boolean)creationSupport.canDelete());
        VirtualLayoutDataTest.assertEquals((Object)"virtual-layout_data: org.eclipse.swt.layout.RowData", (Object)creationSupport.toString());
        VariableSupport variableSupport = dataInfo.getVariableSupport();
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)variableSupport);
        VirtualLayoutDataTest.assertTrue((boolean)variableSupport.isDefault());
        VirtualLayoutDataTest.assertEquals((Object)"(virtual layout data)", (Object)variableSupport.getTitle());
        VirtualLayoutDataTest.assertEquals((Object)"virtual-layout-data", (Object)variableSupport.toString());
        try {
            variableSupport.getStatementTarget();
            VirtualLayoutDataTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        VirtualLayoutDataTest.assertNotNull((Object)dataInfo.getObject());
    }

    @Test
    public void test_virtual_whenDeleteReal() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "    RowData data = new RowData();", "    button.setLayoutData(data);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataCreationSupport.class, dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataVariableSupport.class, dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(InvocationChildAssociation.class, (Object)dataInfo.getAssociation());
        dataInfo.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo newDataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertNotSame((Object)dataInfo, (Object)newDataInfo);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)newDataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)newDataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)newDataInfo.getAssociation());
    }

    @Test
    public void test_virtual_materialize() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        dataInfo.getPropertyByTitle("width").setValue((Object)100);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setLayoutData(new RowData(100, SWT.DEFAULT));", "  }", "}");
        VirtualLayoutDataTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyVariableSupport.class, (Object)dataInfo.getVariableSupport());
        dataInfo.delete();
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo newDataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertNotSame((Object)dataInfo, (Object)newDataInfo);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)newDataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)newDataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)newDataInfo.getAssociation());
    }

    @Test
    public void test_virtual_whenAdd() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "  }", "}");
        shell.refresh();
        RowLayoutInfo layout = (RowLayoutInfo)shell.getLayout();
        ControlInfo button = BTestUtils.createButton();
        layout.command_CREATE(button, null);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = LayoutInfo.getLayoutData((ControlInfo)button);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_virtual_whenMove() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setText('New Button');", "      }", "    }", "  }", "}");
        shell.refresh();
        RowLayoutInfo layout = (RowLayoutInfo)shell.getLayout();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        layout.command_MOVE(button, null);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
    }

    @Test
    public void test_virtual_removeWhenMoveFrom() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "    }", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(1);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        FillLayoutInfo fillLayout = (FillLayoutInfo)composite.getLayout();
        fillLayout.command_MOVE(button, null);
        VirtualLayoutDataTest.assertTrue((boolean)button.getChildrenJava().isEmpty());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    //", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout());", "      {", "        Button button = new Button(composite, SWT.NONE);", "        button.setText('New Button');", "      }", "    }", "  }", "}");
    }

    @Test
    public void test_virtual_whenNewLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        LayoutInfo newLayout = BTestUtils.createLayout("org.eclipse.swt.layout.FillLayout");
        shell.setLayout(newLayout);
        VirtualLayoutDataTest.assertTrue((boolean)button.getChildrenJava().isEmpty());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout(SWT.HORIZONTAL));", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "  }", "}");
    }

    @Test
    public void test_real_whenNewLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "    RowData data = new RowData();", "    data.width = 50;", "    data.height = 70;", "    button.setLayoutData(data);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        LayoutDataInfo dataInfo = (LayoutDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataCreationSupport.class, dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataVariableSupport.class, dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(InvocationChildAssociation.class, (Object)dataInfo.getAssociation());
        LayoutInfo newLayout = BTestUtils.createLayout("org.eclipse.swt.layout.FillLayout");
        shell.setLayout(newLayout);
        VirtualLayoutDataTest.assertTrue((boolean)button.getChildrenJava().isEmpty());
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout(SWT.HORIZONTAL));", "    Button button = new Button(this, SWT.NONE);", "    button.setText('new button');", "  }", "}");
    }

    @Test
    public void test_virtual_whenNewLayout2() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        composite.refresh();
        VirtualLayoutDataTest.assertInstanceOf(GridLayoutInfo.class, (Object)composite.getLayout());
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        GridDataInfo dataInfo = (GridDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        LayoutInfo newLayout = BTestUtils.createLayout("org.eclipse.swt.layout.RowLayout");
        composite.setLayout(newLayout);
        VirtualLayoutDataTest.assertSame((Object)newLayout, (Object)composite.getLayout());
        this.assertEditor("public class Test extends Composite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('New Button');", "    }", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        dataInfo = (RowDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
    }

    @Test
    public void test_implicitLayout_1() throws Exception {
        VirtualLayoutDataTest.setFileContentSrc("test/GridComposite.java", this.getTestSource("public class GridComposite extends Composite {", "  public GridComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "  }", "}"));
        VirtualLayoutDataTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    Button button = new Button(this, SWT.NONE);", "    button.setText('New Button');", "  }", "}");
        composite.refresh();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertInstanceOf(GridLayoutInfo.class, (Object)composite.getLayout());
        GridDataInfo dataInfo = (GridDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        LayoutInfo newLayout = BTestUtils.createLayout("org.eclipse.swt.layout.RowLayout");
        composite.setLayout(newLayout);
        VirtualLayoutDataTest.assertSame((Object)newLayout, (Object)composite.getLayout());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "    Button button = new Button(this, SWT.NONE);", "    button.setText('New Button');", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        RowDataInfo dataInfo2 = (RowDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo2.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo2.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo2.getAssociation());
        newLayout.delete();
        VirtualLayoutDataTest.assertInstanceOf(GridLayoutInfo.class, (Object)composite.getLayout());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    Button button = new Button(this, SWT.NONE);", "    button.setText('New Button');", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        dataInfo = (GridDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
    }

    @Test
    public void test_implicitLayout_2() throws Exception {
        VirtualLayoutDataTest.setFileContentSrc("test/GridComposite.java", this.getTestSource("public class GridComposite extends Composite {", "  public GridComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout());", "  }", "}"));
        VirtualLayoutDataTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "    Button button = new Button(this, SWT.NONE);", "    button.setText('New Button');", "  }", "}");
        composite.refresh();
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        VirtualLayoutDataTest.assertInstanceOf(RowLayoutInfo.class, (Object)composite.getLayout());
        RowDataInfo dataInfo = (RowDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        dataInfo.setWidth(101);
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataCreationSupport.class, dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertNotInstanceOf(VirtualLayoutDataVariableSupport.class, dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(InvocationChildAssociation.class, (Object)dataInfo.getAssociation());
        dataInfo.delete();
        dataInfo = (RowDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(RowDataInfo.class, (Object)dataInfo);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
        composite.getLayout().delete();
        VirtualLayoutDataTest.assertInstanceOf(GridLayoutInfo.class, (Object)composite.getLayout());
        this.assertEditor("public class Test extends GridComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    Button button = new Button(this, SWT.NONE);", "    button.setText('New Button');", "  }", "}");
        VirtualLayoutDataTest.assertEquals((int)1, (int)button.getChildrenJava().size());
        dataInfo = (GridDataInfo)button.getChildrenJava().get(0);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)dataInfo.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)dataInfo.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyAssociation.class, (Object)dataInfo.getAssociation());
    }

    @Test
    public void test_whenExposedControl_deleteExplicitData_restoreVirtual() throws Exception {
        VirtualLayoutDataTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  private Button m_button;", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "    m_button = new Button(this, SWT.NONE);", "  }", "  public Button getButton() {", "    return m_button;", "  }", "}"));
        VirtualLayoutDataTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "    myComposite.getButton().setLayoutData(new GridData());", "  }", "}");
        shell.refresh();
        CompositeInfo myComposite = (CompositeInfo)VirtualLayoutDataTest.getJavaInfoByName("myComposite");
        ControlInfo button = (ControlInfo)VirtualLayoutDataTest.getJavaInfoByName("getButton()");
        GridDataInfo gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        VirtualLayoutDataTest.assertInstanceOf(ConstructorCreationSupport.class, (Object)gridData.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(EmptyVariableSupport.class, (Object)gridData.getVariableSupport());
        VirtualLayoutDataTest.assertInstanceOf(ExposedPropertyCreationSupport.class, (Object)button.getCreationSupport());
        VirtualLayoutDataTest.assertTrue((boolean)button.canDelete());
        button.delete();
        this.assertEditor("class Test extends Shell {", "  Test() {", "    MyComposite myComposite = new MyComposite(this, SWT.NONE);", "  }", "}");
        VirtualLayoutDataTest.assertTrue((boolean)myComposite.getChildren().contains(button));
        gridData = GridLayoutInfo.getGridData((ControlInfo)button);
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataCreationSupport.class, (Object)gridData.getCreationSupport());
        VirtualLayoutDataTest.assertInstanceOf(VirtualLayoutDataVariableSupport.class, (Object)gridData.getVariableSupport());
    }

    @Test
    public void test_delete_shouldKeepSameInstance() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout());", "    Button button = new Button(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        LayoutDataInfo initialData = LayoutInfo.getLayoutData((ControlInfo)button);
        initialData.delete();
        VirtualLayoutDataTest.assertSame((Object)initialData, (Object)LayoutInfo.getLayoutData((ControlInfo)button));
    }
}

