/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;

public abstract class JavaInfoDeleteManager {
    protected final IDatabindingsProvider m_provider;

    public JavaInfoDeleteManager(IDatabindingsProvider provider, ObjectInfo objectInfoRoot) {
        this.m_provider = provider;
        objectInfoRoot.addBroadcastListener((Object)new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                JavaInfoDeleteManager.this.deleteJavaInfo(child);
            }
        });
    }

    public final void deleteJavaInfo(ObjectInfo javaInfo) throws Exception {
        String reference;
        ArrayList<IBindingInfo> deleteList = new ArrayList<IBindingInfo>();
        List<IBindingInfo> bindings = this.m_provider.getBindings();
        if (!this.m_provider.getBindings().isEmpty() && this.accept(javaInfo) && (reference = this.getReference(javaInfo)) != null) {
            for (IBindingInfo binding : new ArrayList<IBindingInfo>(bindings)) {
                if (!this.equals(javaInfo, reference, binding.getTarget()) && !this.equals(javaInfo, reference, binding.getModel())) continue;
                deleteList.add(binding);
                this.deleteBinding(binding, bindings);
            }
        }
        if (!deleteList.isEmpty()) {
            bindings.removeAll(deleteList);
            this.m_provider.saveEdit();
        }
    }

    protected abstract void deleteBinding(IBindingInfo var1, List<IBindingInfo> var2) throws Exception;

    protected abstract boolean accept(ObjectInfo var1) throws Exception;

    protected abstract String getReference(ObjectInfo var1) throws Exception;

    protected abstract boolean equals(ObjectInfo var1, String var2, IObserveInfo var3) throws Exception;
}

