/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.ClassLoaderDelegateClassSupplier;
import io.github.toolfactory.jvm.function.catalog.DeepConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.template.ThrowingFunction;
import io.github.toolfactory.jvm.util.ObjectProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;

public interface ConvertToBuiltinClassLoaderFunction
extends ThrowingFunction<ClassLoader, ClassLoader, Throwable> {

    public static class ForJava9
    implements ConvertToBuiltinClassLoaderFunction {
        protected MethodHandles.Lookup consulter;
        protected Class<?> builtinClassLoaderClass;
        protected MethodHandle classLoaderDelegateConstructor;

        public ForJava9(Map<Object, Object> context) throws Throwable {
            ObjectProvider functionProvider = ObjectProvider.get(context);
            Class classLoaderDelegateClass = (Class)functionProvider.getOrBuildObject(ClassLoaderDelegateClassSupplier.class, context).get();
            this.consulter = (MethodHandles.Lookup)functionProvider.getOrBuildObject(DeepConsulterSupplyFunction.class, context).apply(classLoaderDelegateClass);
            Class builtinClassLoaderDelegateClass = (Class)functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, context).get();
            this.classLoaderDelegateConstructor = this.consulter.findConstructor(classLoaderDelegateClass, MethodType.methodType(Void.TYPE, builtinClassLoaderDelegateClass, ClassLoader.class, MethodHandle.class));
            this.builtinClassLoaderClass = (Class)functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, context).get();
        }

        @Override
        public ClassLoader apply(ClassLoader classLoader) throws Throwable {
            if (this.builtinClassLoaderClass.isAssignableFrom(classLoader.getClass())) {
                return classLoader;
            }
            MethodHandle loadClassMethodHandle = this.consulter.findVirtual(classLoader.getClass(), "loadClass", MethodType.methodType(Class.class, String.class, Boolean.TYPE));
            return (ClassLoader)this.classLoaderDelegateConstructor.invokeWithArguments(null, classLoader, loadClassMethodHandle);
        }
    }

    public static class ForJava7
    implements ConvertToBuiltinClassLoaderFunction {
        public ForJava7(Map<Object, Object> context) {
        }

        @Override
        public ClassLoader apply(ClassLoader classLoader) {
            return null;
        }
    }
}

