/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.burningwave.core.Criteria;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.classes.MemberCriteria;
import org.burningwave.core.classes.Members;
import org.burningwave.core.function.TriPredicate;

public abstract class ExecutableMemberCriteria<E extends Executable, C extends ExecutableMemberCriteria<E, C, T>, T extends Criteria.TestContext<E, C>>
extends MemberCriteria<E, C, T> {
    public C parameterTypes(Predicate<Class<?>[]> predicate) {
        this.predicate = this.concat(this.predicate, (context, member) -> predicate.test(member.getParameterTypes()));
        return (C)this;
    }

    public C parameterTypesAreAssignableFrom(Class<?> ... argumentsClasses) {
        return this.parameterTypesMatch((argClasses, paramTypes, innerIdx) -> argClasses.get((int)innerIdx) == null || StaticComponentContainer.Classes.isAssignableFrom(paramTypes[innerIdx], (Class)argClasses.get((int)innerIdx)), argumentsClasses);
    }

    public C parameterTypesExactlyMatch(Class<?> ... argumentsClasses) {
        return this.parameterTypesMatch((argClasses, paramTypes, innerIdx) -> argClasses.get((int)innerIdx) == null || StaticComponentContainer.Classes.getClassOrWrapper(paramTypes[innerIdx]).equals(StaticComponentContainer.Classes.getClassOrWrapper((Class)argClasses.get((int)innerIdx))), argumentsClasses);
    }

    public C parameterTypesAreAssignableFromTypesOf(Object ... arguments) {
        return this.parameterTypesAreAssignableFrom(StaticComponentContainer.Classes.retrieveFrom(arguments));
    }

    public C parameterTypesExactlyMatchTypesOf(Object ... arguments) {
        return this.parameterTypesAreAssignableFrom(StaticComponentContainer.Classes.retrieveFrom(arguments));
    }

    private C parameterTypesMatch(TriPredicate<List<Class<?>>, Class<?>[], Integer> predicate, Class<?> ... arguments) {
        Class[] argumentsClasses;
        if (arguments == null) {
            arguments = new Class[]{null};
        }
        if ((argumentsClasses = arguments) != null && argumentsClasses.length > 0) {
            List<Class<?>> argumentsClassesAsList = Arrays.asList(argumentsClasses);
            for (int i = 0; i < argumentsClasses.length; ++i) {
                int index = i;
                this.predicate = this.concat(this.predicate, (context, member) -> {
                    Parameter[] memberParameter = member.getParameters();
                    if (memberParameter.length > 1 && memberParameter[memberParameter.length - 1].isVarArgs() && memberParameter.length - 1 > argumentsClassesAsList.size()) {
                        return false;
                    }
                    Class<?>[] memberParameterTypes = Members.Handler.OfExecutable.retrieveParameterTypes(member, argumentsClassesAsList);
                    if (argumentsClassesAsList.size() == memberParameterTypes.length) {
                        if (((ExecutableMemberCriteria)context.getCriteria()).getClassSupplier() == null) {
                            return predicate.test(argumentsClassesAsList, memberParameterTypes, index);
                        }
                        return predicate.test(((ExecutableMemberCriteria)context.getCriteria()).retrieveUploadedClasses(argumentsClasses), memberParameterTypes, index);
                    }
                    return false;
                });
                if (index >= arguments.length - 1) continue;
                this.and();
            }
        } else {
            this.parameterTypes(parameters -> ((Class[])parameters).length == 0);
        }
        return (C)this;
    }

    public C parameterType(BiPredicate<Class<?>[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((criteria, member) -> member.getParameterTypes(), (criteria, array, index) -> predicate.test((Class<?>[])array, (Integer)index)));
        return (C)this;
    }

    public C parameterType(TriPredicate<Map<Class<?>, Class<?>>, Class<?>[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((context, member) -> member.getParameterTypes(), (context, array, index) -> predicate.test(((ExecutableMemberCriteria)context.getCriteria()).getUploadedClasses(), (Class<?>[])array, (Integer)index)));
        return (C)this;
    }

    public C parameter(BiPredicate<Parameter[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((testContext, member) -> member.getParameters(), (testContext, array, index) -> predicate.test((Parameter[])array, (Integer)index)));
        return (C)this;
    }

    public C parameter(TriPredicate<Map<Class<?>, Class<?>>, Parameter[], Integer> predicate) {
        this.predicate = this.concat(this.predicate, this.getPredicateWrapper((testContext, member) -> member.getParameters(), (testContext, array, index) -> predicate.test(((ExecutableMemberCriteria)testContext.getCriteria()).getUploadedClasses(), (Parameter[])array, (Integer)index)));
        return (C)this;
    }
}

