/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public final class EventListenerList {
    private final Map<Class<?>, List<Object>> listeners = new HashMap();

    public synchronized <T> void addListener(Class<T> c, Object listener) {
        if (listener == null || c == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.computeIfAbsent(c, newC -> new CopyOnWriteArrayList()).add(listener);
    }

    public synchronized <T> boolean containsListener(Class<T> c) {
        return this.listeners.containsKey(c);
    }

    public synchronized <T> Iterator<T> getListeners(Class<T> listenerType) {
        return this.listeners.getOrDefault(listenerType, Collections.emptyList()).iterator();
    }

    public synchronized <T> Iterable<T> getListenersIterable(Class<T> listenerType) {
        return this.listeners.getOrDefault(listenerType, Collections.emptyList());
    }

    public synchronized <T> void removeListener(Class<T> c, Object listener) {
        if (listener == null || c == null) {
            throw new IllegalArgumentException();
        }
        List<Object> specListeners = this.listeners.get(c);
        if (specListeners != null) {
            specListeners.remove(listener);
            if (specListeners.isEmpty()) {
                this.listeners.remove(c);
            }
        }
    }
}

