/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.animation.effects;

import org.eclipse.nebula.cwt.animation.effects.IEffect;
import org.eclipse.nebula.cwt.animation.movement.IMovement;

public abstract class AbstractEffect
implements IEffect {
    protected Runnable runnableOnStop = null;
    protected Runnable runnableOnCancel = null;
    protected long length = 0L;
    protected long startTime = -1L;
    protected boolean done = false;
    protected IMovement easingFunction;

    public AbstractEffect(long lengthMilli, IMovement movement, Runnable onStop, Runnable onCancel) {
        this.length = lengthMilli;
        this.easingFunction = movement;
        this.runnableOnCancel = onCancel;
        this.runnableOnStop = onStop;
    }

    public abstract void applyEffect(long var1);

    protected void doCancel() {
        if (this.runnableOnCancel != null) {
            this.runnableOnCancel.run();
        }
    }

    protected void doStop() {
        if (this.runnableOnStop != null) {
            this.runnableOnStop.run();
        }
    }

    public long getCurrentTime() {
        long currentTime;
        long time = System.currentTimeMillis();
        if (this.startTime == -1L) {
            this.startTime = time;
        }
        if ((currentTime = time - this.startTime) > this.length) {
            currentTime = this.length;
        }
        return currentTime;
    }

    public void processEnd() {
        if (this.done) {
            return;
        }
        if (this.getCurrentTime() == this.length) {
            this.done = true;
            this.doStop();
        }
    }

    @Override
    public void cancel() {
        this.done = true;
        this.doCancel();
    }

    @Override
    public void doEffect() {
        long currentTime = this.getCurrentTime();
        this.applyEffect(currentTime);
        this.processEnd();
    }

    @Override
    public boolean isDone() {
        return this.done;
    }
}

