/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.animation;

import org.eclipse.nebula.animation.AnimationRunner;
import org.eclipse.nebula.animation.effects.IEffect;
import org.eclipse.nebula.animation.effects.MoveScrollBarEffect;
import org.eclipse.nebula.animation.movement.IMovement;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;

public class ScrollingSmoother {
    Scrollable component;
    ScrollBar verticalScrollBar;
    ScrollBar horizontalScrollBar;
    IMovement movement = null;
    int duration = 2000;
    AnimationRunner animationRunner = new AnimationRunner();
    Listener mouseWheelListener = event -> {
        int start;
        event.doit = false;
        ScrollBar currentScrollBar = this.getScrollbar(event);
        int end = start = currentScrollBar.getSelection();
        IEffect current = this.animationRunner.getEffect();
        if (current instanceof MoveScrollBarEffect) {
            MoveScrollBarEffect mseffect = (MoveScrollBarEffect)current;
            start = mseffect.getCurrent();
            end = mseffect.getEnd();
        }
        if ((end -= event.count * currentScrollBar.getIncrement()) > currentScrollBar.getMaximum() - currentScrollBar.getThumb()) {
            end = currentScrollBar.getMaximum() - currentScrollBar.getThumb();
        }
        if (end < currentScrollBar.getMinimum()) {
            end = currentScrollBar.getMinimum();
        }
        this.animationRunner.runEffect(new MoveScrollBarEffect(currentScrollBar, start, end, this.duration, this.movement, null, null));
    };
    Listener cancelEffectIfUserSelection = e -> {
        if (!(e.data instanceof MoveScrollBarEffect)) {
            this.animationRunner.cancel();
        }
    };

    public ScrollingSmoother(Scrollable c2, IMovement movement) {
        this.component = c2;
        this.verticalScrollBar = c2.getVerticalBar();
        this.horizontalScrollBar = c2.getHorizontalBar();
        this.movement = movement;
    }

    public ScrollingSmoother(Scrollable c2, IMovement movement, int duration) {
        this(c2, movement);
        this.duration = duration;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setFPS(int fps) {
        this.animationRunner = new AnimationRunner(fps);
    }

    protected ScrollBar getScrollbar(Event event) {
        ScrollBar result = this.verticalScrollBar;
        if (result == null) {
            result = this.horizontalScrollBar;
        }
        return result;
    }

    public void smoothControl(boolean enable) {
        if (enable) {
            this.component.addListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.addListener(13, this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.addListener(13, this.cancelEffectIfUserSelection);
            }
        } else {
            this.component.removeListener(37, this.mouseWheelListener);
            if (this.verticalScrollBar != null) {
                this.verticalScrollBar.removeListener(13, this.cancelEffectIfUserSelection);
            }
            if (this.horizontalScrollBar != null) {
                this.horizontalScrollBar.removeListener(13, this.cancelEffectIfUserSelection);
            }
        }
    }
}

