/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class CharacterPropertyEditor
extends AbstractTextPropertyEditor {
    public static final PropertyEditor INSTANCE = new CharacterPropertyEditor();

    private CharacterPropertyEditor() {
    }

    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value instanceof Character) {
            return String.valueOf(((Character)value).charValue());
        }
        return null;
    }

    @Override
    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    @Override
    protected boolean setEditorText(Property property, String text) throws Exception {
        if (text.length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
            return true;
        }
        if (text.length() > 1) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.CharacterPropertyEditor_notValid, text));
            return false;
        }
        property.setValue(Character.valueOf(text.charAt(0)));
        return true;
    }
}

