/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import java.util.Objects;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;

public final class DocumentTextNode
extends AbstractDocumentObject {
    public static final String P_TEXT = "P_TEXT";
    public static final String P_CDATA = "P_CDATA";
    private boolean m_isCDATA;
    private DocumentElement m_enclosingElement;
    private String m_text;
    private int m_offset;
    private int m_length;

    public DocumentTextNode(boolean isCDATA) {
        this.m_isCDATA = isCDATA;
    }

    public void setEnclosingElement(DocumentElement element) {
        this.m_enclosingElement = element;
    }

    public DocumentElement getEnclosingElement() {
        return this.m_enclosingElement;
    }

    public void setText(String text) {
        if (!Objects.equals(this.m_text, text)) {
            String oldValue = this.m_text;
            this.m_text = text;
            this.firePropertyChanged(this, P_TEXT, oldValue, this.m_text);
        }
    }

    public String getText() {
        return this.m_text;
    }

    public String getRawText() {
        if (this.m_isCDATA) {
            return "<![CDATA[" + this.m_text + "]]>";
        }
        return this.m_text;
    }

    public boolean isCDATA() {
        return this.m_isCDATA;
    }

    public void setCDATA(boolean isCDATA) {
        if (this.m_isCDATA != isCDATA) {
            boolean oldValue = this.m_isCDATA;
            this.m_isCDATA = isCDATA;
            this.firePropertyChanged(this, P_CDATA, oldValue, this.m_isCDATA);
        }
    }

    public void setOffset(int offset) {
        this.m_offset = offset;
    }

    public int getOffset() {
        return this.m_offset;
    }

    public void setLength(int length) {
        this.m_length = length;
    }

    public int getLength() {
        return this.m_length;
    }
}

