/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.selection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.header.AbstractHeaderSelectionEditPolicy;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.border.LineBorder;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.DimensionHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.selection.ResizeHintFigure;
import org.eclipse.wb.internal.swing.FormLayout.model.FormDimensionInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;

abstract class DimensionSelectionEditPolicy<T extends FormDimensionInfo>
extends AbstractHeaderSelectionEditPolicy {
    private IFigure m_lineFeedback;
    private ResizeHintFigure m_feedback;
    private ChangeBoundsRequest m_lastResizeRequest;
    protected Command m_resizeCommand;

    public DimensionSelectionEditPolicy(LayoutEditPolicy mainPolicy) {
        super(mainPolicy);
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        MoveHandle moveHandle = new MoveHandle(this.getHost(), (Locator)new HeaderMoveHandleLocator());
        moveHandle.setForegroundColor(ColorConstants.red);
        handles.add((Handle)moveHandle);
        return handles;
    }

    protected List<Handle> createStaticHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        DimensionHeaderEditPart<T> headerEditPart = this.getHostHeader();
        if (!((FormDimensionInfo)headerEditPart.getDimension()).isGap()) {
            handles.add(this.createResizeHandle());
        }
        return handles;
    }

    protected abstract Handle createResizeHandle();

    private DimensionHeaderEditPart<T> getHostHeader() {
        return (DimensionHeaderEditPart)this.getHost();
    }

    protected final FormLayoutInfo getLayout() {
        return this.getHostHeader().getLayout();
    }

    protected final T getDimension() {
        return this.getHostHeader().getDimension();
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == "resize";
    }

    public Command getCommand(Request request) {
        if (!this.getLayout().canChangeDimensions()) {
            return null;
        }
        return new Command(){

            public void execute() {
                DimensionSelectionEditPolicy.this.getHost().getViewer().getEditDomain().getCommandStack().execute(DimensionSelectionEditPolicy.this.m_resizeCommand);
            }
        };
    }

    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        this.m_resizeCommand = null;
        if (this.m_lineFeedback == null) {
            this.m_lineFeedback = new Figure();
            LineBorder border = new LineBorder(ColorConstants.red, 2);
            this.m_lineFeedback.setBorder((Border)border);
            this.addFeedback(this.m_lineFeedback);
        }
        IFigure hostFigure = this.getHostFigure();
        Rectangle bounds = changeBoundsRequest.getTransformedRectangle(hostFigure.getBounds());
        FigureUtils.translateFigureToAbsolute((IFigure)hostFigure, (Translatable)bounds);
        this.m_lineFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new ResizeHintFigure();
            feedbackLayer.add((IFigure)this.m_feedback);
        }
        Point mouseLocation = changeBoundsRequest.getLocation().getCopy();
        Point feedbackLocation = this.getTextFeedbackLocation(mouseLocation);
        FigureUtils.translateAbsoluteToFigure((IFigure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_lastResizeRequest = changeBoundsRequest;
        this.updateFeedbackText((Request)changeBoundsRequest, changeBoundsRequest.isSnapToEnabled());
        String hintSize = ((FormDimensionInfo)this.getDimension()).getSize().getComponentSize() == null ? "minimum" : "constant";
        this.m_feedback.setSizeHint(hintSize);
    }

    private void updateFeedbackText(Request request, boolean snapToEnabled) {
        this.m_feedback.setText(this.getTextFeedbackText(this.m_lastResizeRequest, snapToEnabled));
    }

    public void eraseSourceFeedback(Request request) {
        this.removeFeedback(this.m_lineFeedback);
        this.m_lineFeedback = null;
        this.m_feedback.getParent().remove((IFigure)this.m_feedback);
        this.m_feedback = null;
    }

    public void performRequest(Request request) {
        KeyRequest keyRequest;
        if (this.m_feedback != null && request instanceof KeyRequest && (keyRequest = (KeyRequest)request).getKeyCode() == 262144) {
            this.m_feedback.setShowSizeHint(!keyRequest.isPressed());
            this.updateFeedbackText(request, true);
        }
    }

    protected abstract Point getTextFeedbackLocation(Point var1);

    protected abstract String getTextFeedbackText(ChangeBoundsRequest var1, boolean var2);

    private class HeaderMoveHandleLocator
    implements Locator {
        private HeaderMoveHandleLocator() {
        }

        public void relocate(IFigure target) {
            IFigure reference = DimensionSelectionEditPolicy.this.getHostFigure();
            Rectangle bounds = reference.getBounds().getCopy();
            FigureUtils.translateFigureToFigure((IFigure)reference, (IFigure)target, (Translatable)bounds);
            target.setBounds(bounds);
        }
    }
}

