/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.ObjectInfoVisitor;
import org.eclipse.wb.internal.core.model.variable.LazyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.osgi.framework.Bundle;

public final class DataBindingsCodeUtils {
    private static final Bundle EXTRAS_BUNDLE = Platform.getBundle((String)"org.eclipse.wb.swing.extras");

    public static boolean hasDBLibraries(IJavaProject javaProject) {
        return ProjectUtils.hasType((IJavaProject)javaProject, (String)"org.jdesktop.beansbinding.AutoBinding");
    }

    public static Bundle getExtrasBundle() {
        return EXTRAS_BUNDLE;
    }

    public static boolean isDBAvailable(IJavaProject javaProject) {
        return DataBindingsCodeUtils.hasDBLibraries(javaProject) || DataBindingsCodeUtils.getExtrasBundle() != null;
    }

    public static boolean ensureDBLibraries(IJavaProject javaProject) throws Exception {
        Bundle extrasBundle = DataBindingsCodeUtils.getExtrasBundle();
        if (!DataBindingsCodeUtils.hasDBLibraries(javaProject) && extrasBundle != null) {
            ProjectUtils.addJar((IJavaProject)javaProject, (Bundle)extrasBundle, (String)"lib/beansbinding-1.2.1.jar", (String)"lib/beansbinding-1.2.1-src.zip");
            return true;
        }
        return false;
    }

    public static MethodDeclaration getLastInfoDeclaration(MethodDeclaration initDataBindings, JavaInfo rootJavaInfo) throws Exception {
        LastComponentVisitor visitor = new LastComponentVisitor(initDataBindings, rootJavaInfo);
        MethodDeclaration method = AstNodeUtils.getEnclosingMethod((ASTNode)visitor.getLastNode());
        Assert.isNotNull((Object)method);
        return method;
    }

    public static void ensureInvokeInitDataBindings(AstEditor editor, MethodDeclaration lastInfoMethod) throws Exception {
        StatementTarget methodTarget;
        InitDataBindingsVisitor visitor = new InitDataBindingsVisitor();
        editor.getAstUnit().accept((ASTVisitor)visitor);
        if (visitor.isInvoke()) {
            return;
        }
        visitor.reset();
        lastInfoMethod.accept((ASTVisitor)visitor);
        String initDBInvokeSource = "initDataBindings();";
        Statement windowVisibleStatement = visitor.getWindowVisibleStatement();
        List statements = DomGenerics.statements((Block)lastInfoMethod.getBody());
        if (windowVisibleStatement != null) {
            methodTarget = new StatementTarget(windowVisibleStatement, true);
        } else if (statements.isEmpty()) {
            methodTarget = new StatementTarget(lastInfoMethod, true);
        } else {
            Statement lastStatement = (Statement)statements.get(statements.size() - 1);
            methodTarget = new StatementTarget(lastStatement, lastStatement instanceof ReturnStatement);
        }
        editor.addStatement(initDBInvokeSource, methodTarget);
    }

    private static class InitDataBindingsVisitor
    extends ASTVisitor {
        private boolean m_invoke;
        private boolean m_checkDoubleInvokeInitDB;
        private Statement m_windowVisibleStatement;

        private InitDataBindingsVisitor() {
        }

        public boolean visit(MethodInvocation node) {
            String methodName = node.getName().getIdentifier();
            if (node.arguments().isEmpty()) {
                if ("initDataBindings".equals(methodName)) {
                    if (this.m_checkDoubleInvokeInitDB) {
                        Assert.isTrue((!this.m_invoke ? 1 : 0) != 0, (String)"Double invoke initDataBindings()");
                    }
                    this.m_invoke = true;
                } else if ("setVisible".equals(methodName) && AstNodeUtils.isSuccessorOf((Expression)node.getExpression(), (String)"java.awt.Window")) {
                    Assert.isNull((Object)this.m_windowVisibleStatement, (String)"Double invoke %window%.setVisible()");
                    this.m_windowVisibleStatement = AstNodeUtils.getEnclosingStatement((ASTNode)node);
                }
            }
            return false;
        }

        public boolean isInvoke() {
            return this.m_invoke;
        }

        public Statement getWindowVisibleStatement() {
            return this.m_windowVisibleStatement;
        }

        public void reset() {
            this.m_invoke = false;
            this.m_checkDoubleInvokeInitDB = true;
            this.m_windowVisibleStatement = null;
        }
    }

    private static class LastComponentVisitor
    extends ObjectInfoVisitor {
        private final MethodDeclaration m_initDataBindings;
        private ASTNode m_lastNode;

        public LastComponentVisitor(MethodDeclaration initDataBindings, JavaInfo rootJavaInfo) throws Exception {
            this.m_initDataBindings = initDataBindings;
            this.m_lastNode = rootJavaInfo.getCreationSupport().getNode();
            rootJavaInfo.accept0((ObjectInfoVisitor)this);
        }

        public ASTNode getLastNode() {
            return this.m_lastNode;
        }

        public boolean visit(ObjectInfo objectInfo) throws Exception {
            if (objectInfo instanceof ComponentInfo) {
                ComponentInfo componentInfo = (ComponentInfo)objectInfo;
                Statement node = componentInfo.getAssociation().getStatement();
                if (node == null && !(componentInfo.getVariableSupport() instanceof LazyVariableSupport)) {
                    node = componentInfo.getCreationSupport().getNode();
                }
                if (node != null && AstNodeUtils.getEnclosingMethod((ASTNode)node) != this.m_initDataBindings) {
                    this.m_lastNode = node;
                }
            }
            return true;
        }
    }
}

