/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.internal.core.EnvironmentUtils;

public final class Expectations {
    private static String m_hostName;
    private static String m_OSName;

    static {
        try {
            m_hostName = EnvironmentUtils.HOST_NAME;
            m_OSName = SystemUtils.OS_NAME;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static <V> V get(V default_value, Map<String, V> values) {
        List<String> keys = Expectations.getKeys();
        for (String key : keys) {
            V value = values.get(key);
            if (value == null) continue;
            return value;
        }
        if (default_value != null) {
            return default_value;
        }
        throw new IllegalArgumentException(MessageFormat.format("Unable to find value in {0}, using keys {1}", values, keys));
    }

    public static <V> V get(Map<String, V> values) {
        return Expectations.get(null, values);
    }

    public static <V> V get(String key_1, V value_1, String key_2, V value_2) {
        Map<String, V> map = Map.of(key_1, value_1, key_2, value_2);
        return Expectations.get(map);
    }

    public static <V> V get(String key_1, V value_1, String key_2, V value_2, String key_3, V value_3) {
        Map<String, V> map = Map.of(key_1, value_1, key_2, value_2, key_3, value_3);
        return Expectations.get(map);
    }

    public static int get(String key_1, int value_1, String key_2, int value_2) {
        Map<String, Integer> map = Map.of(key_1, value_1, key_2, value_2);
        return Expectations.get(map);
    }

    public static int get(String key_1, int value_1, String key_2, int value_2, String key_3, int value_3) {
        Map<String, Integer> map = Map.of(key_1, value_1, key_2, value_2, key_3, value_3);
        return Expectations.get(map);
    }

    public static double get(String key_1, double value_1, String key_2, double value_2) {
        Map<String, Double> map = Map.of(key_1, value_1, key_2, value_2);
        return Expectations.get(map);
    }

    public static double get(String key_1, double value_1, String key_2, double value_2, String key_3, double value_3) {
        Map<String, Double> map = Map.of(key_1, value_1, key_2, value_2, key_3, value_3);
        return Expectations.get(map);
    }

    private static List<String> getKeys() {
        String keyHostOS = m_hostName + " " + m_OSName;
        String keyHost = m_hostName;
        String keyOS = m_OSName;
        String timeZone = Calendar.getInstance().getTimeZone().getID();
        return List.of(keyHostOS, keyHost, keyHost.toLowerCase(Locale.ENGLISH), keyHost.toUpperCase(Locale.ENGLISH), keyOS, timeZone);
    }

    public static <V> V get(V default_value, KeyValue<V> ... values) {
        HashMap map = new HashMap();
        KeyValue<V>[] keyValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            KeyValue<V> value = keyValueArray[n2];
            map.put(value.key, value.value);
            ++n2;
        }
        return Expectations.get(default_value, map);
    }

    public static <V> V get(KeyValue<V>[] values) {
        return Expectations.get(null, values);
    }

    public static String get(String default_value, StrValue ... values) {
        HashMap<String, String> map = new HashMap<String, String>();
        StrValue[] strValueArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            StrValue value = strValueArray[n2];
            map.put(value.key, (String)value.value);
            ++n2;
        }
        return Expectations.get(default_value, map);
    }

    public static <V> State<V> get(V def) {
        HashMap map = new HashMap();
        return new State<V>(def, map);
    }

    public static class BoolValue
    extends KeyValue<Boolean> {
        public BoolValue(String _key, Boolean _value) {
            super(_key, _value);
        }
    }

    public static class DblValue
    extends KeyValue<Double> {
        public DblValue(String _key, Double _value) {
            super(_key, _value);
        }
    }

    public static class DimValue
    extends KeyValue<Dimension> {
        public DimValue(String _key, Dimension _value) {
            super(_key, _value);
        }
    }

    public static class InsValue
    extends KeyValue<Insets> {
        public InsValue(String _key, Insets _value) {
            super(_key, _value);
        }
    }

    public static class IntValue
    extends KeyValue<Integer> {
        public IntValue(String _key, Integer _value) {
            super(_key, _value);
        }
    }

    public static class KeyValue<V> {
        public String key;
        public V value;

        public KeyValue(String _key, V _value) {
            this.key = _key;
            this.value = _value;
        }
    }

    public static class RectValue
    extends KeyValue<Rectangle> {
        public RectValue(String _key, Rectangle _value) {
            super(_key, _value);
        }
    }

    public static class State<V> {
        private final V def;
        private final Map<String, V> map;

        public State(V def, Map<String, V> map) {
            this.def = def;
            this.map = map;
        }

        public State<V> or(String key, V value) {
            this.map.put(key, value);
            return this;
        }

        public V get() {
            return Expectations.get(this.def, this.map);
        }
    }

    public static class StrValue
    extends KeyValue<String> {
        public StrValue(String _key, String _value) {
            super(_key, _value);
        }
    }
}

